/*
 *  rup version 0.8 ruptime client for use with in.rupd for Linux
 *  Copyright (C) 1995  Adam Migus, Memorial University of Newfoundland
 *	(MUN)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  If you make modifications to the source, I would be happy to have
 *  them to include in future releases.  Feel free to send them to:
 *      Adam Migus	      				
 *		amigus@cs.mun.ca 
 *      amigus@ucs.mun.ca   
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>

#define SERVICE "mun-ruptime"
#define PROTOCOL "tcp"

char *program_name;

char version[] = "version 0.8\n";

void usage()
{
	printf("Usage: %s [host] [port] -v -h -?\n"\
			"\t-h,	get this message\n"\
			"\t-?,	get this message\n"\
			"\t-v,	get version and exit\n"\
			"\tport is optional.\n",program_name);
}
void get_data(char *host_name, int given_port)
{
	int plug;						
	struct sockaddr_in socketname; 
    struct hostent *remote_host;  
	struct servent *server;
	char buf[BUFSIZ];

	server = getservbyname(SERVICE,PROTOCOL);

	if(given_port != -1) {
    	socketname.sin_port = htons(given_port);
	} 
	else if(server != (struct servent *)NULL) {
   		socketname.sin_port = server->s_port; 
	}
	else {
		fprintf(stderr,"%s: No valid port found.\n",program_name);
		exit(0);
	}
	socketname.sin_family = AF_INET;

	if ((plug = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		fprintf(stderr,"Error opening socket...\n");
	
	if ((remote_host = gethostbyname((char *)host_name)) == NULL) { 
		perror("gethostbyname");
    	fprintf(stderr, "%s: unknown host: %s\n", program_name , host_name);
		exit(0);
	}
	(void)bcopy(remote_host->h_addr,&socketname.sin_addr,
				sizeof(remote_host->h_length));

	if((connect(plug,(struct sockaddr *)&socketname,sizeof(socketname))) <0)
		fprintf(stderr,"%s: cannot connect to %s.\n",program_name, host_name);

	bzero(&buf,sizeof(buf));
	while(recv(plug, buf,sizeof(buf),0) > 0) {
		printf("%s\n",buf);
		bzero(&buf,sizeof(buf));
	}
	(void)close(plug);
	exit(0);
}
void main(int argc, char **argv)
{
	char c;

	if((program_name = (rindex(argv[0],'/'))) != NULL)
		program_name = program_name++;
	else
		program_name = argv[0];
	
	while((c = getopt(argc, argv,"h?v")) != -1) {
		switch(c) {
			case 'v':
						 printf("%s %s",program_name,version);
						 exit(0);
			case 'h':
			case '?':
			 default: 
						usage();
						exit(0);
		}
	}
	switch(argc) {
		case 2:
			get_data(argv[1],-1);
			break;
		case 3:
			get_data(argv[1],atoi(argv[2]));
			break;
		default:
			usage();
			exit(0);
	}
}

