/* 
 * config.c
 *
 * This file is responsible for setting the vgetty, pvf tools and zplay
 * options to a default value. Then it parses the configuration file and
 * after that the command line options.
 *
 * NOTE: Configuration file support is currently missing.
 *
 */

char config_c[] = "$Id: config.c,v 1.1 1995/04/11 19:18:32 marc Exp $";

#include "voice.h"

void voice_config _P2((argc, argv), int argc, char *argv[])
	{
	dtmf_len = DTMF_LEN;
	dtmf_threshold = DTMF_THRESHOLD;
	rec_compression = REC_COMPRESSION;
	rec_silence_len = REC_SILENCE_LEN;
	rec_silence_threshold = REC_SILENCE_THRESHOLD;
	rec_remove_silence = REC_REMOVE_SILENCE;
	rec_max_len = REC_MAX_LEN;
	speaker_answer_volume = SPEAKER_ANSWER_VOLUME;
	toll_saver_rings = TOLL_SAVER_RINGS;
	rec_always_keep_message = REC_ALWAYS_KEEP_MESSAGE;
	dist_ring = DIST_RING;
	dist_ring_init = make_string(DIST_RING_INIT);
	dist_ring_voice = DIST_RING_VOICE;
	dist_ring_data = DIST_RING_DATA;
	dist_ring_fax = DIST_RING_FAX;
	vgetty_log_path = make_string(VGETTY_LOG_PATH);
	voice_dir = make_string(VOICE_DIR);
	vgetty_receive_dir = make_string(make_path(voice_dir,
	  VGETTY_RECEIVE_DIR));
	vgetty_message_dir = make_string(make_path(voice_dir,
	  VGETTY_MESSAGE_DIR));
	fft_program = make_string(FFT_PROGRAM);
	message_flag_file = make_string(MESSAGE_FLAG_FILE);
	vgetty_answer_file = make_string(VGETTY_ANSWER_FILE);
	vgetty_message_list = make_string(VGETTY_MESSAGE_LIST);
	vgetty_backup_message = make_string(VGETTY_BACKUP_MESSAGE);
	message_program = make_string(MESSAGE_PROGRAM);
	button_program = make_string(BUTTON_PROGRAM);
	dtmf_program = make_string(DTMF_PROGRAM);
	call_program = make_string(CALL_PROGRAM);
	vgetty_ata = make_string(VGETTY_ATA);
	zplay_max_rings = ZPLAY_MAX_RINGS;
	zplay_speaker_volume = ZPLAY_SPEAKER_VOLUME;
	zplay_send_baud = ZPLAY_SEND_BAUD;
	zplay_log_path = make_string(ZPLAY_LOG_PATH);
	zyxel_rom = ZYXEL_ROM;
	};
