/*
    bomb - automatic interactive visual stimulation
    Copyright (C) 1994  Scott Draves <spot@cs.cmu.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define sym_one          0
#define sym_tile4        1
#define sym_mirror4      2
#define sym_mirror2      3
#define sym_frame_buffer 4

#define fill_hramp  0
#define fill_vramp  1
#define fill_grid   2
#define fill_noise  3
#define fill_vnoise 4    /* vert sym */
#define fill_sparse 5    /* each bit 1/(2^4) */
#define nfills      6


#define rule_rug            0
#define rule_rug2           1
#define rule_static         2
#define rule_rotorug        3
#define rule_acidlife1      4
#define rule_acidlife2      5
#define rule_rug_anneal     6
#define rule_rug_anneal2    7
#define rule_rug_rug        8
#define rule_rug_brain      9
#define rule_shade         10
#define rule_wave          11
#define rule_rug_image     12
#define rule_slip          13
#define rule_fuse          14
#define rule_rug_multi     15
#define nrules             16

#define cmap_mono   0
#define cmap_mono4  1
#define cmap_loop   2
#define cmap_heat   3
#define cmap_plain  4
#define cmap_split  5
#define cmap_noise  6
#define cmap_black  7


#define distrib_original   0
#define distrib_new        1
#define distrib_continuous 2
#define distrib_rule_lock  4


extern rule_t rule;
extern int current_cmap[256 * 3];

void fill_board(fill_t *p);
void pix2heat(image8_t *fb, board_t *dst);
