#include <stdio.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "global.h"

void rspf_dump(unsigned char *data, int length)
{
	int bptr, nodes, links, adjs;
	
	printf("RSPF: version %u ", data[0]);
	
	switch(data[1])
	{
		case 3:	/* RRH */
			printf("type RRH seq %#04x flags %d\n",ntohs(*((u_short*)(&data[8]))), data[10]);
			bptr = 11;
			while (bptr < length)			
				putchar(data[bptr++]);
			printf("\n");
			break;
		case 1: /*Routing update*/
			printf("type ROUTING UPDATE ");
			printf("fragment %u frag total %u sync %u #nodes %u env_id %u\n", data[2], data[3], data[6], data[7], ntohs(*((u_short*)(&data[8]))));
			
			bptr = data[6] + 6;
			nodes = data[7];
			while(nodes-- && (length - bptr) > 8)
			{
				printf("\t Reporting Router: %s Seq %u Subseq %u #links %u\n", inet_ntoa(*((struct in_addr*)(&data[bptr]))), ntohs(*((u_short*)(&data[bptr+4]))), data[bptr+6], data[bptr+7]);
				links = data[bptr+7];
				bptr += 8;
				while(links-- && (length - bptr) > 4)
				{
					printf("\t \t horizon %u ERP factor %u cost %u #adjacencies %u\n", data[bptr], data[bptr+1], data[bptr+2], data[bptr+3]);
					adjs = data[bptr+3];
					bptr += 4;
					while(adjs-- && (length - bptr) > 4)
					{
						printf("\t \t \t %s/%d \n", inet_ntoa(*((struct in_addr*)(&data[bptr+1]))), data[bptr] & 0x3f);
						bptr += 5;
					}
				}
			} 											
			break;
		default:
			printf("Unknown packet type %d\n", data[1]);
			break;
	}
}

