////////////////////////////////////////////////////////////////////////////////
//                                                                            //  
//  LAST EDIT: Thu Jun 16 15:53:39 1994 by Barth(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>
#include <scient/scient.h>

int main() {
    RT_init();

    RT_PixmapDisplay *px = new RT_PixmapDisplay( "px", 600, 600 );
    px->doublebuffer();

    RT_Scene *sc = new RT_Scene("sc");

    RT_Light *al;
    sc->insert( al = new RT_AmbientLight( "al" ));
    al->color( RT_Color( 0.2, 0.2, 0 ));
    
    RT_Coord *cx, *cy, *cz;
    RT_AxisType at = X;
    sc->insert( cx = new RT_Coord( "cx", X) );
    RT_AxisType yt = Y;
    sc->insert( cy = new RT_Coord( "cy", yt) );
    sc->insert( cz = new RT_Coord( "cz", Z) );

    cx->format("%f");
    cx->start( -1.2 );
    cx->len( 4.0 );
    cx->incr( 1 );
    cx->marginsize( 0.3 );
    cx->labelsize( 0.4 );

    cy->len( 5.0 );
    cy->start( -1.0 );
    cy->incr( 1.0 );
    cy->labelsize( 0.5 );

    cz->len( 4.0 );
    cz->incr( 1.0 );

    RT_Light *red = new RT_PointLight( "red" );
    red->color( RT_Color(1,1,1));
    red->origin( RT_Vector( 3, 1, 10));
    sc->insert( red );

    RT_Light *blue = new RT_PointLight( "blue" );
    blue->color( RT_Color(1,1,1));
    blue->origin( RT_Vector( -5, 3, 4));
    sc->insert( blue );

    RT_LookatCamera *cam = new RT_LookatCamera("cam", RT_Vector( 5, 5, 10), RT_Vector(0,0,0));
    cam->zfar( 15 ); cam->angle( 40 );

    cam->pixmap( px );
    cam->scene( sc );
    cam->rendering();
    char cmd[100];
    fprintf( stdout, "Type \"run\" to have a little animation.\n" );
    while (1) {
	fprintf( stdout, "-> " );
	fgets( cmd, 100, stdin ); 
	if (!strcmp( cmd, "run\n" )) break;
	fprintf( stdout, "%s\n", RT_eval( cmd ) );
	cam->rendering();
    }

    double w = 5.0;
    double h = 0.7;
    float wincr = 0.05;
    float hincr = 0.05;
    int rounds = 0;
    while(1) {
	cam->rendering();
	if ( w> 8.0 ) wincr = -wincr;
	if ( w<= 0.5) wincr = -wincr;
	if ( h> 4.0 ) hincr = -hincr;
	if ( h<= 0.5) hincr = -hincr;
	rounds++;
	cx->rotate( RT_Vector( 0.0, 0.01, 0 ));
	cy->rotate( RT_Vector( -0.01, 0.0, 0 ));
	cz->rotate( RT_Vector( 0.01, -0.01, 0 ));
    }
}



