////////////////////////////////////////////////////////////////////////////////
//  implementations of special classes                                        //  
//  LAST EDIT: Tue Jun 28 12:42:04 1994 by Barth(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <scient/coord.h>

#define ANGLE M_PI_2

void RT_Coord::deleteAxis() {
    for (int i=0; i<steps; i++ ) {
	delete shortLines[i];
	if ( labs[i] ) delete labs[i];
    }
    delete shortLines;
    if ( labs ) delete labs;
    delete baseLine;
}

void RT_Coord::create() {
    double x, x1, x2, y, y1, y2, z;
    p[0] = startPoint;
    switch ( direction ) {
      case X:
	p[1] = RT_Vector( p[0].x + length, p[0].y, p[0].z );
	x = startPoint.x; z = 0.0;
	y1 = marginSize; y2 = -y1;
	break;
      case Y:
	p[1] = RT_Vector( p[0].x, p[0].y + length, p[0].z );
	y = startPoint.y; z = 0.0;
	x1 = marginSize; x2 = -x1;
	break;
      case Z:
	p[1] = RT_Vector( p[0].x, p[0].y, p[0].z + length );
	z = startPoint.z; x = 0.0;
	y1 = marginSize; y2 = -y1;
	break;
    }
    baseLine = new RT_Polyline( 0, 2, p );
    RT_Surface tsf;
    baseLine->surface( tsf );
    baseLine->father(this);
    shortLines = new RT_Polyvertex*[steps];
    labs = new RT_Text*[steps];
    for ( int j=0; j<steps; j++ ) labs[j] = NULL;
    RT_Vector sp[2], labPos;
    char tmp[20];
// following the declaration of "sprintf" ( char* or int ):
#ifdef SUNOS_4
    char *err;
#else
    int err;
#endif
    for (int i=0; i<steps; i++) {
	switch ( direction ) {
	  case X:
	    sp[0] = RT_Vector( x, y1, z );
	    sp[1] = RT_Vector( x, y2, z );
	    if ( labRelPos == UP ) labPos = RT_Vector(x, y1 , z );
	    if ( labRelPos == DOWN ) labPos = RT_Vector(x, y2 , z );
	    err = sprintf(tmp, formatString, x);
	    x += increment;
	    break;
	  case Y:
	    sp[0] = RT_Vector( x1, y, z );
	    sp[1] = RT_Vector( x2, y, z );
	    if ( labRelPos == LEFT ) labPos = RT_Vector(x2 * 1.5, y, z );
	    if ( labRelPos == RIGHT ) labPos = RT_Vector(x1 * 1.5, y, z );
	    err = sprintf(tmp, formatString, y);
	    y += increment;
	    break;
	  case Z:
	    sp[0] = RT_Vector( x, y1, z );
	    sp[1] = RT_Vector( x, y2, z );
	    if ( labRelPos == UP ) labPos = RT_Vector(x, y1 , z );
	    if ( labRelPos == DOWN ) labPos = RT_Vector(x, y2 , z );
	    err = sprintf(tmp, formatString, z);
	    z += increment;
	    break;
	}
	shortLines[i] = new RT_Polyline( 0, 2, sp );
	shortLines[i]->surface(tsf);
	shortLines[i]->father( this );
	marginsCreated = 1;
	if ( drawLabels == ON ) {
	    if ( err <= 0 ) {
		rt_Output->errorVar(" no valid format: ", formatString, 0 );
		// to prevent crash, to allow further work:
		labs[i] = new RT_Text(0, "error", RT_Vector(0, 0, 0) );
	    } else {
		labs[i] = new RT_Text(0, tmp, RT_Vector(0, 0, 0) );
	    }
	    labs[i]->translate( labPos );
	    labelWidth = charWidth * strlen(tmp);
	    labs[i]->width( labelWidth );
	    labs[i]->surface( tsf );
	    labs[i]->father( this );
	    switch ( direction ) {
	      case X:
		if (labelPlane == YZ) labs[i]->rotate( RT_Vector(0, ANGLE, 0) );
		if ( labelPath == HORIZ ) {
		    labs[i]->xalign( 0 );
		    if ( labRelPos == UP ) labs[i]->yalign( -2 );
		    if ( labRelPos == DOWN ) labs[i]->yalign( 2 );
		}
		if ( labelPath == VERT ) {
		    labs[i]->rotate( RT_Vector( 0, 0, ANGLE ) );
		    labs[i]->yalign( 0 );
		    if ( labRelPos == UP ) labs[i]->xalign( -1 );
		    if ( labRelPos == DOWN ) labs[i]->xalign( 1 );
		}
		break;
	      case Y:
		if (labelPlane == XZ) labs[i]->rotate( RT_Vector(ANGLE * (-1), 0, 0) );
		if ( labelPath == HORIZ ) {
		    if ( labRelPos == LEFT ) labs[i]->xalign( 1 );
		    if ( labRelPos == RIGHT ) labs[i]->xalign( -1 );
		    labs[i]->yalign( -1 );
		}
		if ( labelPath == VERT ) {
		    labs[i]->rotate( RT_Vector( 0, 0, ANGLE ) );
		    if ( labRelPos == LEFT ) labs[i]->yalign( -2 );
		    if ( labRelPos == RIGHT ) labs[i]->yalign( 2 );
		    labs[i]->xalign( 0 );
		}
		break;
	      case Z:
		if (labelPlane == YZ) labs[i]->rotate( RT_Vector(0, ANGLE, 0) );
		if ( labelPath == HORIZ ) {
		    labs[i]->xalign( 0 );
		    if ( labRelPos == UP ) labs[i]->yalign( -2 );
		    if ( labRelPos == DOWN ) labs[i]->yalign( 2 );
		}
		if ( labelPath == VERT ) {
		    labs[i]->rotate( RT_Vector( 0, 0, ANGLE ) );
		    labs[i]->yalign( 0 );
		    if ( labRelPos == UP ) labs[i]->xalign( -1 );
		    if ( labRelPos == DOWN ) labs[i]->xalign( 1 );
		}
		break;
	    }
	    labs[i]->height( labelSize );
	    labelsCreated = 1;
	} else labelsCreated = 0;
    }
    for ( i=0; i<steps; i++) if ((hidden[i]) && (i<MAXHIDDEN) ) labs[i]->invisible();
}

void RT_Coord::hidelabel( int _h ) {
    if ( _h >= MAXHIDDEN ) {
	rt_Output->errorVar("Sorry, can't hide this label.",0 );
	return;
    }
    hidden[ _h ] = 1;
    if ( marginsCreated ) deleteAxis();
    geomChanged();
}

void RT_Coord::discoverlabel( int _h ) {
    if ( _h >= MAXHIDDEN ) {
	rt_Output->errorVar("Sorry, can't discover this label.",0 );
	return;
    }
    hidden[ _h ] = 0;
    if ( marginsCreated ) deleteAxis();
    geomChanged();
}

void RT_Coord::labels( RT_SwitchType _ls ) {
    drawLabels = _ls;
    if ( marginsCreated ) deleteAxis();
    geomChanged();
}

void RT_Coord::labelplane( RT_PlaneType _p ) {
    switch ( direction ) {
      case X: case Z:
	if ( _p == XZ ) {
	    rt_Output->errorVar("This plane is not usable for this axis. Use XY( =0) or YZ( =2).",0 );
	    return;
	}
	break;
      case Y:
	if ( _p == YZ ) {
	    rt_Output->errorVar("This plane is not usable for this axis. Use XY ( =0) or XZ ( =1).",0 );
	    return;
	}
	break;
    }
    labelPlane = _p;
    if ( marginsCreated ) deleteAxis();
    geomChanged();
}

void RT_Coord::labelpath( RT_PathType _lp ) {
    if (( _lp != HORIZ ) && ( _lp != VERT)) {
	rt_Output->errorVar("The path is must be HORIZ ( =0) or VERT ( =1).",0 );
	return;
    }
    labelPath = _lp;
    if ( marginsCreated ) deleteAxis();
    geomChanged();
}

void RT_Coord::labelpos( RT_DirType _lp ) {
    switch ( direction ) {
      case X: case Z:
	if (( _lp == LEFT ) || ( _lp == RIGHT )) {
	    rt_Output->errorVar(" This labelposition is not available for this axistype. Use UP ( =2) or DOWN ( =3).", 0 );
	    return;
	}
	break;
      case Y:
	if (( _lp == UP ) || ( _lp == DOWN )) {
	    rt_Output->errorVar(" This labelposition is not available for this axistype. Use LEFT (=0) or RIGHT ( =1).", 0 );
	    return;
	}
	break;
    }
    labRelPos = _lp;
    lpChanged = 1;
    if ( marginsCreated ) deleteAxis();
    geomChanged();
}

void RT_Coord::marginsize( double _ms ) {
    if ( _ms <= 0.0 ) {
	rt_Output->errorVar(" marginSize must be greater than zero.", 0 );
	return;
    }
    marginSize = _ms;
    msChanged = 1;
    if ( marginsCreated ) deleteAxis();
    geomChanged();
}

void RT_Coord::labelsize( double _ls ) {
    if ( _ls <= 0.0 ) {
	rt_Output->errorVar(" marginSize must be greater than zero.", 0 );
	return;
    }
    labelSize = _ls;
    lsChanged = 1;
    if ( labelsCreated ) deleteAxis();
    geomChanged();
}

void RT_Coord::charwidth( double _cw ) {
    if ( _cw <= 0.0 ) {
	rt_Output->errorVar(" Charcter width must be greater than zero.", 0 );
	return;
    }
    charWidth = _cw;
    cwChanged = 1;
    if ( labelsCreated ) deleteAxis();
    geomChanged();
}

void RT_Coord::incr( double _inc ) {
    if ( _inc <=0.0 ) {
	rt_Output->errorVar(" Sorry, increment must be greater than zero ! ", 0 );
	return;
    }
    if ( marginsCreated ) deleteAxis();
    steps = (int)floor(length / _inc) + 1;
    increment = _inc;
    incChanged = 1;
    geomChanged();
}

void RT_Coord::step( int _stp ) {
    if ( _stp <=0 ) {
	rt_Output->errorVar(" Sorry, need at least one step ! ", 0 );
	return;
    }
    if ( marginsCreated ) deleteAxis();
    steps = _stp;
    increment = length / (double)(steps -1 );
    geomChanged();
}

void RT_Coord::len( double _nl ) {
    if ( _nl <= 0.0 ) {
	rt_Output->errorVar(" Length must be greater than zero ! ", 0 );
	return;
    }
    length = _nl;
    if ( marginsCreated ) deleteAxis();
    steps = (int)floor(length / increment) + 1;
    geomChanged();
}

void RT_Coord::start( double _sp ) {
    switch ( direction ) {
      case X:
	startPoint.x = _sp;
	break;
      case Y:
	startPoint.y = _sp;
	break;
      case Z:
	startPoint.z = _sp;
	break;
    }
    if ( marginsCreated ) deleteAxis();
    steps = (int)floor(length / increment) + 1;
    stpChanged = 1;
    geomChanged();
}


void RT_Coord::format( char *_fs ) {
    if ( strncmp( _fs, "%", 1)) {
	rt_Output->warningVar(" no valid format string: ", _fs, 0 );
	return;
    }
    sprintf(formatString, "%s",_fs );
    if ( marginsCreated ) deleteAxis();
    geomChanged();
}

double RT_Coord::get_start() {
    switch ( direction ) {
      case X: return startPoint.x;
      case Y: return startPoint.y;
      case Z: return startPoint.z;
    }
}

char *RT_Coord::fmtV;
int RT_Coord::fmtF, RT_Coord::spF, RT_Coord::lenF, RT_Coord::incF, RT_Coord::stpF, RT_Coord:: stpV, RT_Coord::lsF, RT_Coord::msF, RT_Coord::labF, RT_Coord::lwF, RT_Coord::lpatF, RT_Coord::planF, RT_Coord::hidF, RT_Coord::dcvF, RT_Coord::cwF;
int RT_Coord::labV, RT_Coord::orgV, RT_Coord::lposF, RT_Coord::lposV, RT_Coord::lpatV, RT_Coord::planV, RT_Coord::hidV, RT_Coord::dcvV;
double RT_Coord::spV, RT_Coord::lenV, RT_Coord::incV, RT_Coord::msV, RT_Coord::lsV, RT_Coord::cwV;
int RT_Coord::spG, RT_Coord::lenG, RT_Coord::incG, RT_Coord::stpG, RT_Coord::msG, RT_Coord::lsG, RT_Coord::labG, RT_Coord::typG, RT_Coord::fmtG, RT_Coord::lposG, RT_Coord::lpatG, RT_Coord::planG, RT_Coord::cwG;

RT_ParseEntry RT_Coord::table[] = {
    { "-format", RTP_STRING, (char*)&fmtV, &fmtF, "Specify a new {ARG 1 Format} for the labels.", RTPS_STRING },
    { "-start", RTP_DOUBLE, (char*)&spV, &spF, "Specify a new {ARG 1 Startpoint} for the axis.",RTPS_DOUBLE },
    { "-len", RTP_DOUBLE, (char*)&lenV, &lenF, "Specify a new {ARG 1 Length} for the axis.",RTPS_DOUBLE },
    { "-incr", RTP_DOUBLE, (char*)&incV, &incF, "Specify a new {ARG 1 Increment} for the axis labels.",RTPS_DOUBLE },
    { "-marginsize", RTP_DOUBLE, (char*)&msV, &msF, "Specify a new {ARG 1 Marginsize} for the axis margins.",RTPS_DOUBLE },
    { "-labelsize", RTP_DOUBLE, (char*)&lsV, &lsF, "Specify a new {ARG 1 Labelsize} for the axis labels.",RTPS_DOUBLE },
    { "-charwidth", RTP_DOUBLE, (char*)&cwV, &cwF, "Specify a new {ARG 1 Charcter width} for the axis labels.",RTPS_DOUBLE },
    { "-labelpos", RTP_INTEGER, (char*)&lposV, &lposF, "Specify a new {ARG 1 Labelposition} for the axis labels. Possible values are (from zero) {ENUM 1 \"Left Right Up Down\"}.",RTPS_INTEGER },
    { "-labelpath", RTP_INTEGER, (char*)&lpatV, &lpatF, "Specify a new {ARG 1 Labelpath} for the axis labels. Possible values are (from zero) {ENUM 1 \"Horiz Vert \"}.",RTPS_INTEGER },
    { "-labelplane", RTP_INTEGER, (char*)&planV, &planF, "Specify a new {ARG 1 Labelplane} for the axis labels. Possible value are (from zero) {ENUM 1 \"XY XZ YZ\"}.",RTPS_INTEGER },
    { "-discoverlabel", RTP_INTEGER, (char*)&dcvV, &dcvF, "Specify an {ARG 1 Index} to discover an axis label.",RTPS_INTEGER },
    { "-hidelabel", RTP_INTEGER, (char*)&hidV, &hidF, "Specify an {ARG 1 Index} to hide an axis label.",RTPS_INTEGER },
    { "-step", RTP_INTEGER, (char*)&stpV, &stpF, "Specify a new {ARG 1 Step} count for the axis labels.",RTPS_INTEGER },
    { "-labels", RTP_INTEGER, (char*)&labV, &labF, "Specify to draw  {ARG 1 Labels} or not. Possible values are (from zero) {ENUM 2 \"Off On\"}.",RTPS_INTEGER },
    { "-get_len", RTP_NONE, 0, &lenG, "Get the length of the axis.", RTPS_NONE },
    { "-get_incr", RTP_NONE, 0, &incG, "Get the increment for the labels.", RTPS_NONE },
    { "-get_step", RTP_NONE, 0, &stpG, "Get the number of steps.", RTPS_NONE },
    { "-get_start", RTP_NONE, 0, &spG, "Get the start value.", RTPS_NONE },
    { "-get_marginsize", RTP_NONE, 0, &msG, "Get the size of the margins.", RTPS_NONE },
    { "-get_labelsize", RTP_NONE, 0, &lsG, "Get the size of the labels.", RTPS_NONE },
    { "-get_charwidth", RTP_NONE, 0, &cwG, "Get the width of the charcters of the labels.", RTPS_NONE },
    { "-get_labelpos", RTP_NONE, 0, &lposG, "Get the position of the labels.", RTPS_NONE },
    { "-get_labelpath", RTP_NONE, 0, &lpatG, "Get the path of the labels.", RTPS_NONE },
    { "-get_labelplane", RTP_NONE, 0, &lpatG, "Get the plane of the labels.", RTPS_NONE },
    { "-get_labels", RTP_NONE, 0, &labG, "Get the draw - labels - flag.", RTPS_NONE },
    { "-get_type", RTP_NONE, 0, &typG, "Get the axis type.", RTPS_NONE },
    { "-get_format", RTP_NONE, 0, &fmtG, "Get the axis type.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_Coord::objectCMD(char *argv[]) {
    int t = RT_Primitive::objectCMD( argv );
    RT_parseTable( argv, table );
    if (fmtF) { format(fmtV); t++; }
    if (spF) { start( spV ); t++; }
    if (lenF) { len( lenV ); t++; }
    if (incF) { incr( incV ); t++; }
    if (stpF) { step( stpV ); t++; }
    if (msF) { marginsize( msV ); t++; }
    if (lsF) { labelsize( lsV ); t++; }
    if (cwF) { charwidth( cwV ); t++; }
    if (lposF) { labelpos( (RT_DirType)lposV ); t++; }
    if (lpatF) { labelpath( (RT_PathType)lpatV ); t++; }
    if (planF) { labelplane( (RT_PlaneType)planV ); t++; }
    if (hidF) { hidelabel( hidV ); t++; }
    if (dcvF) { discoverlabel( dcvV ); t++; }
    if (labF) { labels( (RT_SwitchType)labV ); t++; }
    if (spG) {
	t++; char tmp[30];
	RT_double2string( get_start(), tmp ); RT_Object::result( tmp );
    }
    if (lenG) {
	t++; char tmp[30];
	RT_double2string( get_len(), tmp ); RT_Object::result( tmp );
    }
    if (incG) {
	t++; char tmp[30];
	RT_double2string( get_incr(), tmp ); RT_Object::result( tmp );
    }
    if (stpG) {
	t++; char tmp[30];
	RT_int2string( get_step(), tmp ); RT_Object::result( tmp );
    }
    if (msG) {
	t++; char tmp[30];
	RT_double2string( get_marginsize(), tmp ); RT_Object::result( tmp );
    }
    if (lsG) {
	t++; char tmp[30];
	RT_double2string( get_labelsize(), tmp ); RT_Object::result( tmp );
    }
    if (cwG) {
	t++; char tmp[30];
	RT_double2string( get_charwidth(), tmp ); RT_Object::result( tmp );
    }
    if (labG) {
	t++; char tmp[30];
	RT_int2string( (int)get_labels(), tmp ); RT_Object::result( tmp );
    }
    if (typG) {
	t++; char tmp[30];
	RT_int2string( (int)get_type(), tmp ); RT_Object::result( tmp );
    }
    if (lposG) {
	t++; char tmp[30];
	RT_int2string( (int)get_labelpos(), tmp ); RT_Object::result( tmp );
    }
    if (lpatG) {
	t++; char tmp[30];
	RT_int2string( (int)get_labelpath(), tmp ); RT_Object::result( tmp );
    }
    if (planG) {
	t++; char tmp[30];
	RT_int2string( (int)get_labelplane(), tmp ); RT_Object::result( tmp );
    }
    if (fmtG) {
	t++; char tmp[30];
	RT_Object::result( get_format() );
    }
    return t;
}

int RT_Coord::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res = _classCMD( cd, ip, argc, argv );
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", RTN_COORD, " { String String } {  Creates a coordinate axis. {ARG 1 Name} of the new object, direction  {ARG 2 Direction}.}}", 0 );
	return TCL_OK;
    }
    if (res == TCL_OK) { 
	if (argc != 3) { 
	    Tcl_AppendResult( ip, "Bad number of arguments. Try \"", RTN_COORD, " ?\".", 0 ); 
	    return TCL_ERROR;
	}

	int axis;
	if ( RT_string2int( argv[2], axis ) ) {
	    if ( ( axis >= 0 ) && ( axis <= 2 ) ) {
		new RT_Coord( argv[1], (RT_AxisType)axis );
		return TCL_OK;
	    } else {
		rt_Output->errorVar( argv[0], ": No valid axis specified. Could not create one !", 0);
		return TCL_ERROR;
	    }
	} else {
	    rt_Output->errorVar( argv[0], ": Arg 2 should be an integer", 0);
	    return TCL_ERROR;
	}
    }

}

int RT_Coord::isA(const char *_c)const {
    if (RTM_isA(_c, RTN_COORD )) { printf(" is a 1 \n"); return 1; }
    return RT_Primitive::isA( _c );
}
