//  LAST EDIT: Fri Jun 17 08:58:44 1994 by Barth(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  An implementation of coordinate axes with margins and labels.             //  
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              barth@prakinf.tu-ilmenau.de                                   //
//		ekki@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////
#ifndef __COORD_H__
#define __COORD_H__

#include <poly.h>
#include <high/text.h>

// the class COORDINATES

#define RTN_COORD "Coord"
#define MAXHIDDEN 30

typedef enum { X, Y, Z } RT_AxisType;
typedef enum { OFF, ON } RT_SwitchType;
typedef enum { XY, XZ, YZ } RT_PlaneType;
typedef enum { LEFT, RIGHT, UP, DOWN } RT_DirType;
typedef enum { HORIZ, VERT } RT_PathType;

class RT_Coord: public RT_Primitive {
    void create();
    static RT_ParseEntry table[];
    RT_Vector p[2];
    RT_Polyvertex *baseLine;
    RT_Polyvertex **shortLines;
    RT_AxisType direction;
    RT_Vector startPoint;
    double length, charWidth;
    double marginSize, labelSize, labelWidth;
    RT_Text **labs;
    double increment;
    int steps;
    char formatString[10];
    int labelsCreated, marginsCreated;
    int stpChanged, incChanged, msChanged, lsChanged, cwChanged, lpChanged;
    int hidden[ MAXHIDDEN ];
    RT_SwitchType drawLabels;
    RT_PlaneType labelPlane;
    RT_DirType labRelPos;
    RT_PathType labelPath;
    //##### statics for parameter parsing:
    static int fmtF, spF, lenF, incF, stpF, stpV, lsF, msF, labV, labF, orgV, cwF, cwG;
    static int lwF, lposF, lposV, lpatF, lpatV, planF, planV, hidF, hidV, dcvF, dcvV;
    static int spG, lenG, incG, stpG, msG, lsG, labG, typG, fmtG, lposG, lpatG, planG;
    static char *fmtV;
    static double spV, lenV, incV, lsV, msV, cwV;

  private:
  void deleteAxis();
  public:
    //#### the public methods:
    RT_Coord( char *_name, RT_AxisType _dir ) : RT_Primitive(_name) {
	direction = _dir;
	startPoint = RT_Vector( 0, 0, 0 );
	labs = NULL;
	length = 1.0;
	steps = 3;
	increment = length / (double)(steps - 1);
	stpChanged = incChanged = msChanged = lsChanged = cwChanged = lpChanged = 0;
	sprintf(formatString,"%s", "%g");
	labelsCreated = marginsCreated = 0;
	drawLabels = ON;
	marginSize = length * 0.1;
	labelSize = marginSize * 2;
	charWidth = increment * 0.15;
	switch ( direction ) {
	  case X:
	    labRelPos = DOWN;
	    break;
	  case Y:
	    labRelPos = LEFT;
	    break;
	  case Z:
	    labRelPos = DOWN;
	    break;
	}
	labelPath = HORIZ;
	labelPlane = XY;
	for (int i=0; i<MAXHIDDEN; i++) hidden[i] = 0;
    }
    const char *get_class()const { return RTN_COORD; }
    int isA( const char* )const;
    const char *get_description()const { return "An axis with labels."; }
    void printCon(FILE *f)const { 
	RT_Primitive::printCon( f );
	fprintf( f, "%d", direction );
	fprintf( f, "\n" );
    }
    void print(FILE *f)const { 
	RT_Primitive::print( f );
	fprintf( f, "\n%s ", get_name() );
	if ( stpChanged ) fprintf(f, "-start "); startPoint.print(f);
	if ( length != 1.0 ) fprintf(f, "-len %lf ", length );
	if ( steps !=3 ) fprintf(f, "-step %i ", steps );
	if ( incChanged ) fprintf(f, "-incr %lf ", increment );
	if ( strcmp( formatString, "%g" ) ) fprintf(f, "-format %s ", formatString );
	if ( !drawLabels ) fprintf(f, "-labels %i ", drawLabels );
	if ( msChanged ) fprintf(f, "-marginsize %lf ", marginSize );
	if ( lsChanged ) fprintf(f, "-labelsize %lf ", labelSize );
	if ( cwChanged ) fprintf(f, "-charwidth %lf ", charWidth );
	if ( lpChanged ) fprintf(f, "-labelpos %i ", labRelPos );
	if ( labelPath ) fprintf(f, "-labelpath %i ", labelPath);
	if ( labelPlane ) fprintf(f, "-labelplane %i ", labelPlane );
	for ( int i=0; i< steps; i++ ) 
	    if (( i<MAXHIDDEN ) && ( hidden[i] )) fprintf(f, "-hidden %i ", hidden[i] );

	fprintf( f, "\n");
    }

    //##### class specific methods

    void format( char *_fs );
  void start( double _sp );
  void len( double _nl );
  void incr( double _inc );
  void step( int _stp );
  void marginsize( double _ms );
  void labelsize( double _ls );
  void charwidth( double _lw );
  void labels( RT_SwitchType _ls );
  void plane( RT_PlaneType _p );
  void labelpath( RT_PathType _lp );
  void labelpos( RT_DirType _lp );
  void labelplane( RT_PlaneType _lp );
  void hidelabel( int _h );
  void discoverlabel( int _d );
  double get_start();
  double get_len() { return length; }
  double get_incr() { return increment; }
  int get_step() { return steps; }
  double get_marginsize() { return marginSize; }
  double get_labelsize() { return labelSize; }
  double get_charwidth() { return charWidth; }
  RT_SwitchType get_labels() { return drawLabels; }
  RT_AxisType get_type() { return direction; }
  RT_DirType get_labelpos() { return labRelPos; }
  RT_PathType get_labelpath() { return labelPath; }
  RT_PlaneType get_labelplane() { return labelPlane; }
  int get_hidden();
  char *get_format() { return formatString; }

  
    //#### the tcl commands:
    static int classCMD( ClientData, Tcl_Interp *, int, char *[]);
    int objectCMD( char *[]);
};

#endif
