//  LAST EDIT: Fri Jul  1 12:46:33 1994 by Barth(@prakinf.tu-ilmenau.de)
#ifndef __LAT2D_H__
#define __LAT2D_H__
////////////////////////////////////////////////////////////////////////////////
// Declarations of the Implementation Level for Sci.Visualization.            //  
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              barth@prakinf.tu-ilmenau.de                                   //
//	        ekki@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////
#include <scient/base.h>
#include <poly.h>

// some forwards:
class RT_Quadmesh;

typedef void (*D2LatGetParamFunc)( const ParamSet &pS, int _x, int _y, int dimY, double *p );

class RT_2DLattice:
public RT_2DGeometry,
public RT_Lattice {
static RT_ParseEntry table[];
static int parF;
static char *parV;
protected:
  RT_Quadmesh quadmesh;
  RT_Polyvertex **ilines;
  int maxIsol, currIsol;
  D2LatGetParamFunc l2Dgetfunc[MAX_PARAM];
public:
  RT_2DLattice( char * _name):
RT_2DGeometry(),RT_Lattice(_name),/* RT_Scientific( _name) , */
  quadmesh( 0, 0, 0, 0 ) {
      quadmesh.father( this );
      ilines = 0; currIsol = 0;
      maxIsol = 0;
  }
  void create();
  void createGeometry();
  // create the geometry from file or numerical algorithms
  void createParameters();
  // create the parameters from file or numerical algorithms
private:
  void cmap( int pnr, double _hmin, double _hmax, double _sat, double _val );
  void delete_cmap();
  void zmap( int _pnr );
  void drawIso( int _pnr );
  void isolines( int _pnr );
  void isoareas( int _pnr );
  void compute_line( double *x, double *y, double *z );
  void compute_area( double *x, double *y, double *z, int index );
  void tri_shift( double *v1, double *v2, double *v3 );
  void tri_area_shift( double *v1, double *v2, double *v3, int index );
  void delete_isolines();
  void printParams( FILE *f )const {
      fprintf( f, "\n%s ", get_name() );
      for ( int n=0; n<MAX_PARAM; n++ ) if ( paramData[n].loaded ) {
	  fprintf( f, " -loadParameters { %i {", n );
	  double *p = new double[ dims[0] * dims[1] ];
	  for ( int i=0; i < dims[0]; i++ ) 
	      for ( int j=0; j < dims[1]; j++ ) 
		  getParameter( n, i, j, &p[ i*dims[1] + j] );
	  for ( i=0; i< (dims[0] * dims[1]); i++ ) fprintf( f, " %lf", p[i] );
	  fprintf( f, " } }" );
	  delete p;
      }
  }
public:
  void loadParameters( int _np, RT_ScType _pt, double *_p );
  void loadParameters( int _np, RT_ScType _pt, float *_p );
  void loadParameters( int _np, RT_ScType _pt, int *_p );
  void loadParameters( int _np, RT_ScType _pt, char *_p );
  void setParamType( int _pnr, RT_ScType _pt );
  void setVertex(int *, double*);
  void getVertex(int *, double*)const;
  int objectCMD(char *argv[]);
  void setParameter(int pnr, int _x, int _y, double _p );
  void setParameter(int pnr, int _x, int _y, float _p );
  void setParameter(int pnr, int _x, int _y, int _p );
  void setParameter(int pnr, int _x, int _y, char _p );
  void getParameter(int pnr, int _x, int _y, double *_p )const;
  void getParExtremes( int pnr, double *pmin, double *pmax );
  void setParExtremes( int pnr, double pmin, double pmax );
  void updateParExtremes( int _pnr );
  void print(FILE *f)const { 
      RT_Scientific::print( f );
  }
};


#define RTN_2D_P_LATTICE "2DPerimetricLattice"

class RT_2DPerimetricLattice: public RT_2DLattice {
  static int pgeoF;
  static char *pgeoV;
public:
  RT_2DPerimetricLattice( char *_name ) : RT_2DLattice(_name) /* , RT_Scientific(_name) */ {}
  static RT_ParseEntry table[];
  void createGeometry();
  // create the geometry from file or numerical algorithms
  void createParameters();
  // create the parameters from file or numerical algorithms

private:
  void printGeometry( FILE *f )const {
      fprintf( f, "\n%s ", get_name() );
      if ( (dims[0]) && (dims[1]) && (dims[2]) ) {
	  fprintf( f, "-loadGeometry { %i %i { ", dims[0], dims[1] );
	  int indices[3];
	  double vtx[4], *vx, *vy;
	  vx = new double[ dims[0] ]; vy = new double[ dims[1] ];
	  for ( int i=0; i < dims[0]; i++ ) 
	      for ( int j=0; j < dims[1]; j++ ) {
		  indices[0] = i; indices[1] = j;
		  getVertex( indices, vtx );
		  vx[i] = vtx[0]; vy[j] = vtx[1];
	      }
	  for ( i=0; i<dims[0]; i++ ) fprintf( f, "%lf ", vx[i] );
	  fprintf( f, "} { " );
	  for ( i=0; i<dims[1]; i++ ) fprintf( f, "%lf ", vy[i] );
	  fprintf( f, "} }" );
	  delete vx; delete vy;
      }
  }
public:
  void loadGeometry( int _nx, int _ny, double *_x, double *_y );
  const char *get_class() const { return RTN_2D_P_LATTICE; }
  int isA(const char *)const;
  void findParameters();
  //#### the tcl commands:
  static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
  int objectCMD(char *argv[]);
  const char *get_description() const { return "A 2D perimetric lattice."; }
  void printCon(FILE *f)const { 
      RT_Primitive::printCon( f );
  }
  void print(FILE *f)const { 
      fprintf( f, "\n");
      RT_2DLattice::print( f );
  }
};



#define RTN_2D_U_LATTICE "2DUniformLattice"

class RT_2DUniformLattice: public RT_2DLattice {
  static int ugeoF;
  static char *ugeoV;
  double x0, y0, dx, dy;
public:
  RT_2DUniformLattice( char *_name ) : RT_2DLattice(_name) /* , RT_Scientific(_name) */ {
  }
  static RT_ParseEntry table[];
  void createGeometry();
  // create the geometry from file or numerical algorithms
  void createParameters();
  // create the parameters from file or numerical algorithms
  
private:
  void printGeometry( FILE *f )const {
      fprintf( f, "\n%s ", get_name() );
      if ( (dims[0]) && (dims[1]) ) fprintf( f, "-loadGeometry { %i %i %lf %lf %lf %lf }", dims[0], dims[1], x0, y0, dx, dy );
  }

public:
  void loadGeometry( int _nx, int _ny, double _x0, double _y0, double _dx, double _dy );
  const char *get_class()const { return RTN_2D_U_LATTICE; }
  int isA(const char *)const;
  void findParameters();

  //#### the tcl commands:
  static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
  int objectCMD(char *argv[]);
  const char *get_description()const { return "A 2D uniform lattice."; }
  void printCon(FILE *f)const { 
      RT_Primitive::printCon( f );
  }
  void print(FILE *f)const { 
      fprintf( f, "\n");
      RT_2DLattice::print( f );
  }
};


#define RTN_2D_C_LATTICE "2DCurvilinearLattice"

class RT_2DCurvilinearLattice: public RT_2DLattice {
  static int cgeoF;
  static char *cgeoV;
public:
  RT_2DCurvilinearLattice( char *_name ) : RT_2DLattice(_name) /* , RT_Scientific(_name) */ {}
  static RT_ParseEntry table[];
  void createGeometry();
  // create the geometry from file or numerical algorithms
  void createParameters();
  // create the parameters from file or numerical algorithms

private:
  void printGeometry( FILE *f )const {
      fprintf( f, "\n%s ", get_name() );
      if ( (dims[0]) && (dims[1]) ) {
	  fprintf( f, "-loadGeometry { %i %i {", dims[0], dims[1] );
	  int indices[3];
	  double vtx[4], *x, *y;
	  x = new double[ dims[0] * dims[1] ];
	  y = new double[ dims[0] * dims[1] ];
	  for ( int i=0; i < dims[0]; i++ ) 
	      for ( int j=0; j < dims[1]; j++ ) {
		  indices[0] = i; indices[1] = j;
		  getVertex( indices, vtx );
		  x[ i * dims[1] + j ] = vtx[0];
		  y[ i * dims[1] + j ] = vtx[1];
	      }
	  for ( i=0; i< dims[0] * dims[1]; i++ ) fprintf( f, "%lf ", x[i] );
	  fprintf( f, "} { " );
	  for ( i=0; i< dims[0] * dims[1]; i++ ) fprintf( f, "%lf ", y[i] );
	  fprintf( f, "} } " );
	  delete x; delete y;
      }
  }
public:
  void loadGeometry( int _nx, int _ny, double *_x, double *_y );
  const char *get_class()const { return RTN_2D_C_LATTICE; }
  int isA(const char *)const;
  void findParameters();

  //#### the tcl commands:
  static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
  int objectCMD(char *argv[]);
  const char *get_description()const { return "A 2D curvilinear lattice."; }
  void printCon(FILE *f)const { 
      RT_Primitive::printCon( f );
  }
  void print(FILE *f)const { 
      fprintf( f, "\n");
      RT_2DLattice::print( f );
  }
};

#endif

