#ifndef __VR_COMM_H__
#define __VR_COMM_H__

////////////////////////////////////////////////////////////////////////////////
//  Definition of classes for communication                                   //  
//  LAST EDIT: Tue Nov 29 17:04:12 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART VR extension. Copying, distribution and     //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright '94 '95 Ekkehard 'Ekki' Beier                                //
////////////////////////////////////////////////////////////////////////////////

extern "C" {
    #include <tcl.h>
    #include <tk.h>
}

#include "vr_defs.h"

class VR_User;

class VR_Hostname: public RT_String {
  public:
    VR_Hostname();
};

extern VR_Hostname vr_Hostname;

class VR_SceneCommunicator {
    // this class implements the communicator of a scene
    // for IPC the console is used (for test purposes)

    static int YARTeval( Tcl_Interp *,char *[] );

    Tcl_Interp *ip;
    // this is the externally accessible interpreter;
    // the YART interpreter is hidden
  public:
    VR_SceneCommunicator();
    virtual ~VR_SceneCommunicator();

    char *eval(char*);
    // eval by YART interpreter
    
    ///// overloadable communicator methods: 
    // send a text string to the specified user:
    virtual void sendText2user(VR_User *USR, const char *TXT);
    // send a Tcl command to the specified user:
    virtual void sendCmd2user(VR_User *USR, const char *CMD);

    // send a binary large object to the specified user
    // the blob is specified by FILENAME
    virtual void sendBlob2user(VR_User *USR, const char *FILENAME, const char *REMOTE_NAME, int COMPRESS = 0);
    
    // go into endless loop and wait for IPC:
    virtual void loop();
    // remove the user from communicator data:
    virtual void killUser(VR_User*) {}

    ///// externally accessible Tcl commands:
    static int loginCMD(ClientData, Tcl_Interp *, int, char *[]);
    static int logoutCMD(ClientData, Tcl_Interp *, int, char *[]);
    static int sendCMD(ClientData, Tcl_Interp *, int, char *[]);
    static int forwardCMD(ClientData, Tcl_Interp *, int, char *[]);
    static int pickCMD(ClientData, Tcl_Interp *, int, char *[]);
};

// the global polymorphic scene communicator object:
extern VR_SceneCommunicator *vr_SceneCommunicator;

class VR_UserCommunicator {
    // this class implements a local communicator of the scene, e.g. no IPC
  protected:
    Tcl_Interp *ip;

    const char *getRepresentation(); // get users representation as string
  public:
    VR_UserCommunicator(Tcl_Interp *, const char *SCENE);
    
    void send(const RT_String &cmd) { send( (char*)cmd); }
    virtual void send(char *CMD);
    virtual void receive() {}

    // externally accessible Tcl commands:
    static int sceneEvalCMD(ClientData, Tcl_Interp *, int, char *[]);
};

// the global polymorphic user communicator object:
extern VR_UserCommunicator *vr_UserCommunicator;
    
class VR_UserData {
    // the class is provided for user data that is 
    // specific to a communication implementation
};

#endif

