// test.h - macros for test cases

#include <iostream.h>
#include <stdlib.h>

static int _errors = 0;

static void PASSED()  
{
    if (_errors == 0) {
	cout << "\n*** All Tests Passed ***\n";
	exit(0);
    }
    cout << "\n*** " << _errors << " errors occurred ***\n";
    exit(1);
}

#define FAILED(x)  {cout << "\"" << __FILE__ << "\", line " << __LINE__ << ": " << x << endl << flush; _errors++;}

#define TEST(ex) { if (!(ex)) { FAILED("Test failed"); } }
	
#define TESTE(ex) { if (!(ex)) { FAILED("Test failed"); exit(1); } }

