////////////////////////////////////////////////////////////////////////////////
//  The global include header. Include this file to have the declarations,    //
//  prototypes for all YART stuff.                                            //  
//  LAST EDIT: Fri Feb 10 15:44:16 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __YART_H__
#define __YART_H__

#include "utils.h"

#include "scene.h"
#include "camera.h"
#include "pixmap.h"
#include "image.h"

#include "attrobj.h"
#include "tclclass.h"
#include "tclerror.h"

#include "quadmesh.h"
#include "polyhdrn.h"

#include "high/text.h"
#include "high/analytic.h"
#include "high/height.h"
#include "high/quadric.h"
#include "high/off.h"
#include "high/offpolyh.h"
#include "high/oba.h"
#include "high/usefprim.h"
#include "high/usefligh.h"
#include "high/usefmapp.h"
#include "high/useftext.h"
#include "high/lookat.h"
#include "high/oneray.h"
#include "high/recorder.h"
#include "high/curves.h"
#include "high/forms.h"
#include "high/rotforms.h"

#include "input/input.h"
#include "input/device.h"
#include "input/locator.h"
#include "input/pick.h"
#include "input/filedev.h"
#include "input/mdevice.h"
#include "input/vpick.h"

// for C++ usage only:

int RT_pureInit( Tcl_Interp * );
// initialize the Tcl class commands only

int RT_init( Tcl_Interp * = 0);
// initialize *ALL* YART graphics stuff

void RT_exit();

char *RT_eval(char*);
// eval command

// commands that are available in Tcl, too:

char *RT_packages();
// get a string containing all C++ packages

char *RT_primitiveClasses();
// get a string containing all C++ primitive classes

void RT_save(char*);
// save all objects into a file

void RT_sleep( int n);
// sleep for n milli seconds

RT_GeneralList *RT_primitives();
// returns a list with all non-hidden primitives
// the list must be cleared and removed later

#endif
