////////////////////////////////////////////////////////////////////////////////
// This demo shows the extension of the attributes by defining a "Price" attri//
// bute. The unit is U.S. dollars.                                            //
// LAST EDIT: Fri Aug  5 09:09:24 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

//#### declarations ####

const char *RTN_PRICE_ATTR = "Price";

class RT_PriceAttrImpl:public RT_AttrImpl {
  protected:
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int prV, prF, prG;
  public:
    //#### interface of PRICE attribute:
    virtual void price(int) = 0;
    virtual int get_price() = 0;
    //#### the Tcl commands:
    static int parseCMD(char *[], RT_Primitive*); 
};

class RT_PriceAttribute: public RT_Attribute, public RT_PriceAttrImpl {
    int prc;
  public:
    static RT_PriceAttribute Default;
    RT_PriceAttribute( int _prc = 1): prc(_prc) {}
    int set (const char *);
    const char *get() const;
    const char *getClass() const { return RTN_PRICE_ATTR;}
    const RT_Attribute *getDefault() { return &Default; }
    // dont check the consistency here
    // assuming that "a" is a RT_ResolutionAttribute reference
    void operator=(const RT_Attribute &a) {
	prc = ((RT_PriceAttribute &)a).prc;
	setNamesList( a.getNamesList() );
    }
    int operator!=(const RT_Attribute &a) const {
	return !( prc == ((RT_PriceAttribute &)a).prc );
    }
    //#### interface of PRICE attribute:
    void price(int p) { prc = p; changed(); }
    int get_price() { return prc; }
};

//#### implementations ####

int RT_PriceAttribute::set (const char *s) {
    int np, res;
    if ( res = RT_string2int( s, np )) prc = np;
    return res;
}

const char *RT_PriceAttribute::get() const {
    static char v[10];
    RT_int2string( prc, v );
    return v;
}

int RT_PriceAttrImpl::prV; 
int RT_PriceAttrImpl::prF; 
int RT_PriceAttrImpl::prG; 

RT_ParseEntry RT_PriceAttrImpl::table[] = {
    { "-price", RTP_INTEGER, (char*)&prV, &prF, "Specify a new {ARG 1 Price} for the object.", RTPS_INTEGER },
    { "-get_price", RTP_NONE, 0, &prG, "Get the current price of the object.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_PriceAttrImpl::parseCMD(char *argv[], RT_Primitive *p) { 
    RT_parseTable( argv, table );
    if (prF) {
	RT_PriceAttribute *attr = (RT_PriceAttribute*)p->get_privAttribute( RTN_PRICE_ATTR );
	if (!attr) {
	    p->attribute( RT_PriceAttribute() );
	    attr = (RT_PriceAttribute*)p->get_privAttribute( RTN_PRICE_ATTR );
	}
	attr->price( prV );
    }
    if (prG) RT_Object::result( p->get_attribute( RTN_PRICE_ATTR ).get() );
    return prF + prG;
}

RT_PriceAttribute RT_PriceAttribute::Default;

// #### extension of attribute access ####

class MY_AttributeObject:public RT_AttributeObject, public RT_PriceAttrImpl {
  public:
    RT_Attribute *create(const char *cls, const char *val) const {
	RT_Attribute *at;
	if (!strcmp( cls, RTN_PRICE_ATTR )) {
	    at = new RT_PriceAttribute;
	    if (!val || at->set( val )) return at;
	    delete at;
	}
	return RT_AttributeObject::create( cls, val );
    }
    int parse( char *argv[], RT_Primitive *prim ) {
	int r = RT_AttributeObject::parse( argv, prim );
	r += RT_PriceAttrImpl::parseCMD( argv, prim );
	return r;
    }
    int objectCMD(char *argv[]) { 
	MY_AttributeObject *obj = (MY_AttributeObject*)rt_AttributeObject;
	RT_parseTable( argv, RT_PriceAttrImpl::table );
	if (prF) obj->price( prV );
	if (prG) RT_Object::result( RT_PriceAttribute::Default.get() );
	return prF + prG; 
    }
    //#### interface of PRICE attribute:
    void price(int s) { 
	RT_PriceAttribute::Default.price(s); 
	RT_PriceAttribute::Default.reset();
    }
    int get_price() { return  RT_PriceAttribute::Default.get_price(); }
};

// #### test it out ####

void MY_init() {
    RT_init();
    delete rt_AttributeObject;
    rt_AttributeObject = new MY_AttributeObject;
    rt_DefaultAttributes.append( &RT_PriceAttribute::Default );
}

int main() {
    MY_init();
    RT_FileDevice *console = new RT_FileDevice( "console", 0, 1 ); 
    console->addCB( new RT_ConsoleInputCB );
    rt_InputServer->loop();
}
