/*  LAST EDIT: Thu Apr 21 11:31:20 1994 by ekki(@prakinf.tu-ilmenau.de)
*/


#include "X11/Xlib.h"
#include "X11/extensions/XI.h"
#include "X11/extensions/XInput.h"
#include "X11/Xutil.h"
#include "X11/keysym.h"
#include "xspbdev.h"

int rt_spaceballInit( Display *display, Window window, SpaceballDeviceInfo *sp ) {
    /* Define the new events for the spaceball device: */
    XDeviceInfoPtr list;

    int i, ndevices;
    /* GET THE LIST OF INPUT DEVICES THAT ARE ATTACHED TO THE DISPLAY NOW */
    list = (XDeviceInfoPtr) XListInputDevices(display, &ndevices);
    sp->device = 0;
    for(i = 0; i < ndevices; i++) {

	/* OPEN THE SPACEBALL DEVICE */
	if (strcmp(list[i].name, "spaceball") == 0) {
	    /*
	     * Note that the device_id is not guaranteed to be the
	     * same all the time
	     */
	    sp->device = XOpenDevice(display, list[i].id);
	} ;
    }

    /* set the window in sp to check the window in spaceballEvent proc */
    sp->window = window;

    if (sp->device) {
	XEventClass listOfEventClass[NUM_SPACEBALL_EVENTS];
	XDevice *d;
	int eType,eClass,n;
	d = sp->device;
	for (n=0;n<NUM_SPACEBALL_EVENTS;n++) {
	    /* SELECT EXTENSION EVENTS FOR THE SPACEBALL */
	    switch (n) {
	      case SPACEBALL_BALL_EVENT: 
		DeviceMotionNotify(d,eType,eClass);
		break;
	      case SPACEBALL_BUTTON_PRESS_EVENT:
		DeviceButtonPress(d,eType,eClass);
		break;
	      case SPACEBALL_BUTTON_RELEASE_EVENT:
		DeviceButtonRelease(d,eType,eClass);
		break;
	    }
	    
	    sp->eventType[n]= eType;
	    sp->eventClass[n]= eClass;
	    listOfEventClass[n]= eClass;
	}
	XSelectExtensionEvent(display,window,listOfEventClass,NUM_SPACEBALL_EVENTS);
	return 1;
    }

    return 0;
}



void rt_spaceballRemove(Display *d, SpaceballDeviceInfo *sp) {
    /*    XCloseDevice(d,sp->device); */
}

int rt_spaceballEvent(XEvent *event, SpaceballData *data, SpaceballDeviceInfo *sp) {
    if (event->type == sp->eventType[SPACEBALL_BALL_EVENT]) 
	{
	    XDeviceMotionEvent *M = (XDeviceMotionEvent *) event;
	    if (M->deviceid == sp->device->device_id) 
		{
		    /* variable to hold the period time wich
		       come on event before the axis */
		    static long time=1, last_time=0;
		    static int ignore_event = 0;
		    int i;
		    short tmp[6];


		    for(i=0;i<6;i++) tmp[i]=0;
		    for(i=0;i<M->axes_count;i++)
			tmp[M->first_axis+i]=M->axis_data[i];

                     /* Calculate the PERIOD (16ths of a millisecond) */
		    data->period=16*(time?50:M->time-last_time);
		    last_time=M->time;

		    /* if time event the set time and ignore */
		    if (tmp[0]==0 && tmp[1]==0 && tmp[2]==0
			&& tmp[3]==0 && tmp[4]==0 && tmp[5]==0) 
			{time =1 ; return 0; }
			
			
		    data->transX=tmp[0]/127;
		    data->transY=tmp[1]/127;
		    data->transZ=tmp[2]/127;
		    
		    data->twistX=tmp[3]/127;
		    data->twistY=tmp[4]/127;
		    data->twistZ=tmp[5]/127;

		    data->b1=0;
		    data->b2=0;
		    data->b3=0;
		    data->b4=0;
		    data->b5=0;
		    data->b6=0;
		    data->b7=0;
		    data->b8=0;
		    data->pick=0;
		    return 1;
		}
	} else 
	    if (event->type == sp->eventType[SPACEBALL_BUTTON_PRESS_EVENT]) { 
		/* THESE ARE SPACEBALL BUTTON PRESSES */
		XDeviceButtonEvent *b = (XDeviceButtonEvent *)event;
		
		data->b1=0;
		data->b2=0;
		data->b3=0;
		data->b4=0;
		data->b5=0;
		data->b6=0;
		data->b7=0;
		data->b8=0;
		data->pick=0;

		switch(b->button) {
		  case 1: data->b1 = 1; break;
		  case 2: data->b2 = 1; break;
		  case 3: data->b3 = 1; break;
		  case 4: data->b4 = 1; break;
		  case 5: data->b5 = 1; break;
		  case 6: data->b6 = 1; break;
		  case 7: data->b7 = 1; break;
		  case 8: data->b8 = 1; break;
		  case 9: data->pick = 1; break;
		}
		data->transX=0;
		data->transY=0;
		data->transZ=0;
		data->twistX=0;
		data->twistY=0;
		data->twistZ=0;
		data->period=0;
		return 1;

	    } 


return 0;

}





