////////////////////////////////////////////////////////////////////////////////
// YART interface to IBM GL (comparable to SGI 3.2).                          //  
// LAST EDIT: Tue Aug  9 16:44:22 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../high/usefligh.h"
#include "../high/lookat.h"
#include "../quadmesh.h"
#include "../pixmap.h"
#include "../poly.h"
#include "../polyhdrn.h"

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <gl.h>
#include <gl/device.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

// utility functions:

void rt_glVertMaterial(const RT_Surface &surface) {
    float tmp[4];
    lmcolor(LMC_SPECULAR);
    surface.spec.get_float( tmp );
    c3f( tmp );
    lmcolor(LMC_AD);
    tmp[3] = 1-surface.tran;
    surface.diff.get_float( tmp );
    c4f(tmp);
    lmcolor(LMC_EMISSION);
    surface.emmi.get_float( tmp );
    c3f(tmp);
}

void rt_glVertColor(const RT_Surface &surface) {
    float tmp[4];
    lmcolor(LMC_COLOR);
    tmp[3] = 1-surface.tran;
    surface.diff.get_float( tmp );
    c4f(tmp);
}


// low level display list functions:

void RT_dlOpen(long id) {
//    fprintf( stderr, "open %i\n", id );
    if (isobj((Object)id)) delobj( (Object)id );
    makeobj( (Object)id );
}

void RT_dlClose(long) { closeobj(); }

void RT_dlDelete(long id) {
    if (isobj((Object)id)) delobj( (Object)id );
}

void RT_dlMatrix(const RT_Matrix &mat) {
    Matrix m;
    for (int i = 0; i < 4; i++)
	for (int j = 0; j < 4; j++)
	    m[i][j] = mat.get(j, i);
    pushmatrix();
    multmatrix( m );
}

void RT_dlUnMatrix() {
    popmatrix();
}

void RT_dlSurface(const RT_Surface &surface) {
    float lmat[21];
    lmat[0] = DIFFUSE;
    lmat[1] = surface.diff.r;
    lmat[2] = surface.diff.g;
    lmat[3] = surface.diff.b;
    lmat[4] = EMISSION;
    lmat[5] = surface.emmi.r;
    lmat[6] = surface.emmi.g;
    lmat[7] = surface.emmi.b;
    lmat[8] = SPECULAR;
    lmat[9] = surface.spec.r;
    lmat[10] = surface.spec.g;
    lmat[11] = surface.spec.b;
    lmat[12] = SHININESS;
    lmat[13] = surface.shin;
    lmat[14] = ALPHA;
    lmat[15] = 1-surface.tran;
    lmat[16] = AMBIENT;
    lmat[17] = surface.diff.r;
    lmat[18] = surface.diff.g;
    lmat[19] = surface.diff.b;
    lmat[20] = LMNULL;
    lmdef( DEFMATERIAL, 1, 21, lmat);
    lmbind( MATERIAL, 1);
}

void RT_dlCall(long id) {
    callobj( (Object) id );
}

// the class PixmapDisplay:

#ifndef TK
// the class PixmapDisplay:

class RT_PixmapDisplayData {
  public:
    long id;
    int left, middle, right;
};

RT_PixmapDisplay::~RT_PixmapDisplay() { winclose( data->id ); delete data; }   

RT_PixmapDisplay::RT_PixmapDisplay(char *_name, int _w, int _h): RT_Pixmap(_name, _w, _h) {
    data = new RT_PixmapDisplayData;
    maxsize( w, h );
    minsize( w, h );
    data->id = winopen( _name );
    RGBmode();
    zbuffer( 1 );
    ::singlebuffer();
    sglBuf = 1;
    gconfig();
    concave(1);
    qdevice( LEFTMOUSE );
    qdevice( MIDDLEMOUSE );
    qdevice( RIGHTMOUSE );
    qdevice( MOUSEX );
    qdevice( MOUSEY );

    data->left = data->middle = data->right = 0;
}

void RT_PixmapDisplay::activate() { winset( data->id ); readsource(SRC_FRONT); }

void RT_PixmapDisplay::clear(const RT_Color &x) { 
    float f[3];
    f[0] = x.r; f[1] = x.g; f[2] = x.b; 
    c3f( f ); ::clear(); zclear(); 
}

void RT_PixmapDisplay::singlebuffer() { ::singlebuffer(); gconfig(); sglBuf = 1; }

void RT_PixmapDisplay::doublebuffer() { ::doublebuffer(); gconfig(); sglBuf = 0; }

RT_Color RT_PixmapDisplay::getPixel(int _x, int _y) {
    if (!checkIndices( _x, _y)) return RT_Color( 0,0,0);
    long val[1];
    lrectread(_x, _y, _x, _y, val );
    return RT_Color( *val );
}

void RT_PixmapDisplay::putPixel(int x, int y, const RT_Color &colr) {
    long u = (long)(colr);
    frontbuffer( 1 );
    lrectwrite( x, y, x, y, &u );
    frontbuffer( 0 );
}

void RT_PixmapDisplay::event() {
    short val;
    RT_Event *event = NULL;
    if (qtest()) {
	switch (qread( &val )) {

	    // the point events

	  case LEFTMOUSE:
	  case MIDDLEMOUSE:
	  case RIGHTMOUSE: {
	    RT_ButtonEvent *pev = new RT_ButtonEvent;
	    Device mdev[2];
	    mdev[0] = MOUSEX; mdev[1] = MOUSEY; 
	    pev->left   = (int) getbutton( LEFTMOUSE );
	    pev->middle = (int) getbutton( MIDDLEMOUSE );
	    pev->right  = (int) getbutton( RIGHTMOUSE );
	    long ox, oy;
	    short xy[2];
	    getorigin( &ox, &oy );
	    getsize( (long *) &pev->w, (long *) &pev->h );
	    getdev( 2, mdev, xy );
	    pev->x = ( xy[0]-(int)ox);  
	    pev->y = ( xy[1]-(int)oy); 
	    event = (RT_Event*) pev;
	    break; }

	  case MOUSEX:
	  case MOUSEY:
	    {
	    RT_MotionEvent *pev = new RT_MotionEvent;
	    Device mdev[2];
	    mdev[0] = MOUSEX; mdev[1] = MOUSEY; 
	    pev->left   = (int) getbutton( LEFTMOUSE );
	    pev->middle = (int) getbutton( MIDDLEMOUSE );
	    pev->right  = (int) getbutton( RIGHTMOUSE );
	    long ox, oy;
	    short xy[2];
	    getorigin( &ox, &oy );
	    getsize( (long *) &pev->w, (long *) &pev->h );
	    getdev( 2, mdev, xy );
	    pev->x = ( xy[0]-(int)ox);  
	    pev->y = ( xy[1]-(int)oy); 
	    event = (RT_Event*) pev;
	    break; }
	}; 
	if (event) {
	    if (xcamera) xcamera->event( *event );
	    delete event;
	}
    }
}

#endif
// GL_LightNumber define the number of the next light
// 0 <= GL_LightNumber < MAXLIGHTS  
int GL_LightNumber = 0;

// class LookatCamera:

void RT_LookatCamera::shading() {
    if (!get_pixmap() || !get_scene()) return;
    if (xpixmap) { xpixmap->activate(); xpixmap->clear( get_scene()->get_background() ); } 
    mmode(MVIEWING);
    pushmatrix();
    perspective( (short)xangle*10, xpixmap->getW()/(double)xpixmap->getH(), xnear, xfar );
    lookat( vp.x, vp.y, vp.z, rp.x, rp.y, rp.z, 10 * xtwist );
    float lm[7];
    lm[0] = AMBIENT;
    lm[1] = 0.0;
    lm[2] = 0.0;
    lm[3] = 0.0;
    lm[4] = TWOSIDE;
    lm[5] = 1.0;
    lm[6] = LMNULL;
    lmdef( DEFLMODEL, 1, 7, lm);
    lmbind( LMODEL, 1);
    lmbind( MATERIAL, 0);
    for (int i = 0; i<8 ; i++) lmbind(LIGHT0+i,0);
    GL_LightNumber = 0;	
    blendfunction(BF_ONE,BF_ZERO);
    RT_RenderLightFunc lfunc;
    RT_RenderPrimitiveFunc pfunc;
    get_scene()->doWithElements( &lfunc );
    get_scene()->doWithElements( &pfunc );
    feedback->doWithElements( &pfunc );
    swapbuffers();
    popmatrix();
}

///// the shading primitives for GL:

void RT_Polymarker::render() {
    // get the default surface
    const RT_Surface *surface = &get_surface();
    RT_Vertex *v;
    const RT_Vector *vn;
    const RT_Surface *vsurface;
    int nr = 0;
    float ng[4],n[4],f[4];
    
    rt_glVertMaterial(*surface);
    bgnpoint();
    
    // the default normal
    get_gnormal().get( ng );
    n3f( ng );
    
    
    // draw the vertex points
    while ( v = get( nr++ ) ) {
	
	// if a vertex surface defined 
	vsurface=v->getSurface() ;
	if (vsurface) { rt_glVertMaterial(*vsurface);}
	
	// if a vertex normal defined
	vn = v->getNormal();
	if (vn) {
	    vn->get(n); n3f( n );} else { n3f( ng ); }
	// set the vertex point
	v->getPoint().get( f );
	v3f( f );
	
	// restore the normal and surface propertys
	if (vsurface) { rt_glVertMaterial(*surface);}
	if (vsurface||vn) {n3f( ng );}
    }
    endpoint();
}


void RT_Polyline::render() {
    // get the default surface
    const RT_Surface *surface;
    surface = &get_surface();
    RT_Vertex *v;
    int nr = 0;
    float ng[4],n[4],f[4];
    
    rt_glVertColor( *surface );
    bgnline();
    lmbind( LMODEL, 0);
    // the default normal
    //get_gnormal().get( ng );
    //n3f( ng );
    
    // draw the vertex line
    while ( v = get( nr++ ) ) {
	// if a vertex surface defined 
	//vsurface=v->getSurface() ;
	//if (vsurface) { rt_glVertMaterial(*vsurface);}
	
	// if a vertex normal defined
	//vn = v->getNormal();
	//if (vn) { vn->get(n); n3f( n );} else { n3f( ng ); }
	// set the vertex line
	v->getPoint().get( f );
	v3f( f );
	// restore the normal and surface propertys
	//if (vsurface) { rt_glVertMaterial(*surface);}
	//if (vsurface||vn) {n3f( ng );}
    }
    endline();
    lmbind( LMODEL, 1);
}

void RT_Polygon::render() {
    // get the default surface
    const RT_Surface *surface;
    surface = &get_surface();
    int fstyle = get_fillstyle();
    
    RT_Vertex *v;
    const RT_Vector *vn;
    const RT_Surface *vsurface;
    int nr = 0;
    float ng[4],n[4],f[4];
    
    if (fstyle) {

	rt_glVertMaterial( *surface );
	bgnpolygon();
	// the default normal
	get_gnormal().get( ng );
	n3f( ng );

    } else {

	lmbind( LMODEL, 0);
	rt_glVertColor( *surface );
	bgnclosedline();
    }	
 
   // draw the vertex points
    while ( v = get( nr++ ) ) {
	
	if (fstyle) {
	    // if a vertex surface defined 
	    vsurface=v->getSurface() ;
	    if (vsurface) { rt_glVertMaterial( *vsurface );}
	
	    // if a vertex normal defined
	    vn = v->getNormal();
	    if (vn) {
		vn->get(n); n3f( n );} else { n3f( ng ); }
	}


	// set the vertex point
	v->getPoint().get( f );
	v3f( f );
	
	if (fstyle) {
	    // restore the normal and surface propertys
	    if (vsurface) { rt_glVertMaterial( *surface );}
	    if (vsurface||vn) {n3f( ng );}
	}
    }
    if (fstyle) 
	endpolygon();
    else {
	endclosedline();
	lmbind( LMODEL, 1);
    }
}

void RT_Quadmesh::render() {
    // get the default surface
    const RT_Surface *surface;
    surface = &get_surface();
    
    RT_Vertex *v;
    const RT_Vector *vn;
    const RT_Surface *vsurface;
    float ng[4],n[4],f[4];
    int cols,rows,nr = 0;
    rows = get_x();
    cols = get_y();
    

    
    if(get_fillstyle()) {

	rt_glVertMaterial( *surface );
	// the default normal
	get_gnormal().get( ng );
	n3f( ng );
	// draw filled quadmesh:
	for( int i = 0; i < rows-1; i++ ) {
	    bgntmesh();
	    for( int j = 0; j < cols; j++ ) {
		for( int p = 0; p < 2; p++) {
		    v = get(i+p,j);  
		    // if a vertex surface is defined 
		    vsurface=v->getSurface() ;
		    if (vsurface) {
			rt_glVertMaterial( *vsurface );
			n3f( ng );
		    }
		    
		    // if a vertex normal defined
		    vn = v->getNormal();
		    if (vn) { vn->get(n); n3f( n );} 
		    
		    // set the vertex point:
		    v->getPoint().get( f );
		    v3f( f );
		    
		    // restore the normal and surface propertys:
		    if (vsurface) { rt_glVertMaterial( *surface);}
		    if (vsurface||vn) {n3f( ng );}
		    
		}
	    }
	    endtmesh();
	}
    } else {

	// draw wireframed quadmesh:	
	lmbind( LMODEL, 0);
	rt_glVertColor( *surface );
	for( int i = 0; i < rows; i++ ) {
	    bgnline();
	    for( int j = 0; j < cols; j++ ) {
		v = get(i,j);  
		// set the vertex point:
		v->getPoint().get( f );
		v3f( f );
	    }
	    endline();
	}
	for( int j = 0; j < cols; j++ ) {
	    bgnline();
	    for( int i = 0; i < rows; i++ ) {
		v = get(i,j);  
		// set the vertex point:
		v->getPoint().get( f );
		    v3f( f );
	    }
	    endline();
	}
	lmbind( LMODEL, 1);
    }
}

void RT_Polyhedron::render() {
    // get the default surface
    const RT_Surface *surface;
    surface = &get_surface();
    int fstyle = get_fillstyle();
    
    RT_Vertex *v;
    const RT_Vector *vn;
    const RT_Surface *vsurface;
    int nr = 0;
    float ng[4],n[4],f[4];
    
    rt_glVertMaterial( *surface );

    // draw the vertex points
    for (int i = 0; i < get_nfacets(); i++) {
    	if (fstyle) 
	    bgnpolygon();
   	else {
	    bgnclosedline();
	    lmbind( LMODEL, 0);
	}

	for ( int j = 0; j < facets[i].get_number(); j++) {
	    v = get(i, j);
	
	    if (fstyle) {
		// if a vertex surface defined 
		vsurface=v->getSurface() ;
		if (vsurface) { rt_glVertMaterial( *vsurface );}
	
		// if a vertex normal defined
		vn = v->getNormal();
		if (vn) {
		    vn->get(n); n3f( n );} else { n3f( ng ); }
	    }

	    // set the vertex point
	    v->getPoint().get( f );
	    v3f( f );
	    
	    if (fstyle) {
		// restore the normal and surface propertys
		if (vsurface) { rt_glVertMaterial( *surface );}
		if (vsurface||vn) {n3f( ng );}
	    }
	}

    	if (fstyle) 
	    endpolygon();
    	else { 
	    endclosedline();
	    lmbind( LMODEL, 1);
	}
    }
}


// the light sources:

void RT_PointLight::render() {
    if (get_on()) {
	if (GL_LightNumber < 8) {
	    RT_Color color = get_color();
	    RT_Vector vector = get_origin();
	    float lt[21];
	    lt[0] =	LCOLOR;
	    lt[1] =     color.r;
	    lt[2] =     color.g;
	    lt[3] =     color.b;
	    lt[4] =     POSITION;
	    lt[5] =     -vector.x;
	    lt[6] =     -vector.y;
	    lt[7] =     -vector.z;
	    lt[8] =     1.0;
	    lt[9] =     AMBIENT;
	    lt[10] =    0.0;
	    lt[11] =    0.0;
	    lt[12] =    0.0;
	    lt[13] =    SPOTLIGHT;
	    lt[14] =    0.0;
	    lt[15] =    180.0;
	    lt[16] =    SPOTDIRECTION;
	    lt[17] =    0.0;
	    lt[18] =    0.0;
	    lt[19] =    -1.0;
	    lt[20] =    LMNULL;
	    lmdef(DEFLIGHT, GL_LightNumber+1, 20, lt);
	    lmbind( LIGHT0+GL_LightNumber, GL_LightNumber+1);
	    GL_LightNumber ++;
	} else {
	    rt_Output->warning("GL cant define more then 8 lights!");
	}
    }
}

void RT_AmbientLight::render() {
    if (get_on()) {
	RT_Color color = get_color();
	float lm[5];
	lm[0] =	    AMBIENT;
	lm[1] =     color.r;
	lm[2] =     color.g;
	lm[3] =     color.b;
	lm[4] =     LMNULL;
	lmdef( DEFLMODEL, 1, 5, lm);
	lmbind( LMODEL, 1);
    }
}

#ifdef RTD_RSY
void RT_LookatCamera::RSYshading() {
  float max_rend = -BIGFLOAT;
  RT_RS_Scene* rscene = ((RT_RSYScene*)get_scene())->get_rscene(); //the radiosity scene to render
  long i, cnt,
       a_dcnt = rscene->Areas->get_diffcnt(),      //number of diffuse patches
       a_icnt = rscene->Areas->get_inscnt(),       //number of non-diffuse patches
       p_dcnt = rscene->Points->get_diffcnt(),     //number of diffuse patches
       p_icnt = rscene->Points->get_inscnt();      //number of non-diffuse patches
  int j, k, m, corners;
  int render_nondiff = xmode == RTE_LC_RADIOSITY; //render non-diffuse components ? (if any)
  int wireframe = xmode == RTE_LC_WIREFRAME_RADIOSITY;
  int auto_view_scale = rscene->Points->view_scale < epsilon && !wireframe;
  float max_scale = rscene->Points->max_scale;
  RT_RS_Area* ar;                            //the current patch
  RT_RS_3DVector prp(vp.x, vp.y, vp.z);      //projection reference point
  RT_Vector vv(rp - vp);                     //view vector                                 
  vv = vv.UNITIZE();                         //norm. view vector
  RT_RS_3DVector vdir(vv.x, vv.y, vv.z);
  RT_RS_Vtx *vtx[4],                         //the vertices of the current patch
  view_dir( prp, vdir ); //view direction
  
  RT_RS_DiffRGB xcolr[4];                    //the colors of the vertices

  if (xpixmap) { xpixmap->activate(); xpixmap->clear( get_scene()->get_background() ); } 
  mmode(MVIEWING);
  pushmatrix();
  perspective( (short)xangle*10, xpixmap->getW()/(double)xpixmap->getH(), xnear, xfar );
  lookat( vp.x, vp.y, vp.z, rp.x, rp.y, rp.z, 10 * xtwist );
  lmbind( LMODEL, 0);
  blendfunction(BF_ONE,BF_ZERO);

  rscene->Points->reset_vis();
  for(m = 0; m < 2; m++) {  //for all (diffuse + non-diffuse patches)
    cnt = m ? p_icnt : p_dcnt;
    for(i = 0; i < cnt; i++) {
      if(m) *vtx = rscene->Points->get_ins(i);
      else *vtx = rscene->Points->get_diff(i); //get the patch
      if((*vtx)->get_view_val(*xcolr, view_dir, render_nondiff))
        if(auto_view_scale) {
          if(xcolr->r > max_rend && xcolr->r < max_scale) max_rend = xcolr->r;
          if(xcolr->g > max_rend && xcolr->g < max_scale) max_rend = xcolr->g;
          if(xcolr->b > max_rend && xcolr->b < max_scale) max_rend = xcolr->b;
        }
    }
  }
  
  if(auto_view_scale) rscene->Points->view_scale = 1.0 / max_rend;
  rscene->Points->scale_view_vals();

  float crd[4][3], colr[3], Green[3], White[3];
  Green[0] = 0;  Green[1] = 1; Green[2] = 0;
  White[0] = 1;  White[1] = 1; White[2] = 1;

  //render:
  for(k = wireframe ? 0 : 1; k < 2; k++) {
    for(m = 0; m < 2; m++) {  //for all (diffuse + non-diffuse patches)
      cnt = m ? a_icnt : a_dcnt;
      for(i = 0; i < cnt; i++) {
        if(m) ar = rscene->Areas->get_ins(i); else ar = rscene->Areas->get_diff(i); //get the patch
        corners = ar->vidx[2] == ar->vidx[3] ? 3 : 4;
        int xbackface = 0;
        for(j = 0; j < corners; j++) {
          vtx[j] = ar->get_vtx(ar->vidx[j]);   //get the vertices
          //get the vertex intensity in direction to point of view
          if(!vtx[j]->get_view_val(xcolr[j], view_dir, render_nondiff))
            xbackface++;  //this vertex is back-facing 
         }
         xbackface = xbackface == corners;
         if(wireframe && (xbackface && !k || !xbackface && k) || !wireframe && !xbackface) {  //render this patch
         for(j = 0; j < corners; j++) {
           crd[j][0] = vtx[j]->pnt.x; 
           crd[j][1] = vtx[j]->pnt.y; 
           crd[j][2] = vtx[j]->pnt.z;
         }  
         if(wireframe) {    //draw as a wireframe
            bgnclosedline();                             
            if(xbackface) c3f(Green); else c3f(White); 
            for (j = 0; j < corners; j++) { 
              v3f(crd[j]); 
            }           
            endclosedline();           
          } else {		
            bgnpolygon();
            for (j = 0; j < corners; j++) {
              colr[0] = xcolr[j].r; colr[1] = xcolr[j].g; colr[2] = xcolr[j].b; 
              c3f(colr); v3f(crd[j]);
            }            
	    endpolygon(); 
          }
        }
      }
    }
  }
  if(auto_view_scale) rscene->Points->view_scale = 0.;

  swapbuffers();
  popmatrix();
}
#endif

