//  LAST EDIT: Mon Dec 20 10:33:55 1993 by ekki(@prakinf.tu-ilmenau.de)
#ifndef __FTYPE_H__
#define __FTYPE_H__

#include "fconst.h"

typedef void *Anyptr;
typedef signed char schar;
typedef unsigned char uchar;
typedef int boolean;

typedef double mat4[4][4];    /* homogene Matrix */

typedef struct vct3 {         /* affiner Vektor oder Punkt */
  float x, y, z;
} vct3;

typedef struct vct4 {         /* homogener Vektor oder Punkt */
  float w, x, y, z;
} vct4;

typedef struct rgb {
  float r, g, b;
} rgb;

typedef struct rgbB {
  uchar r, g, b;
} rgbB;

typedef struct rgbI {
  int r, g, b;
} rgbI;

typedef struct vertex {       /* Objektpunkt mit Farbe */
  vct3 crd, nrm;              /* Koordinaten, Normale */
  rgb c;                      /* Farbe */
} vertex;

typedef vertex polyOBJtyp[maxPnts];   /* Polygon im Objekt */

typedef struct TrafStackTyp { /* zu speichernde Matrizen im Transformations-Stack */
  mat4 MC_WC, MC_NPC, MC_DC, WC_MC, WC_DC, WC_NPC, NPC_MC, NPC_DC;
  struct TrafStackTyp *vor, *nach; /* Zeiger fuer verkettete Liste */
} TrafStackTyp;

typedef struct SHD_VTX {      /* Belicht. Pkt. im DC */
  long x, y, z;
  rgbI c;
} SHD_VTX;

typedef SHD_VTX polySCRtyp[maxPnts]; /* Belicht. Poly. im DC */

typedef enum {
  Gouraud, Flat
} TShadingMeth;                      /* Art der Schattierung */

typedef enum {
  Palette, TrueColour
} TColorTyp;                         /* Art des Grafikadapters */

typedef enum {
  ambient, infinite, positional, spot
} LSType;                            /* Art der Lichtquelle   */

typedef enum {
  inside, outside, toClip
} TClipMode;               

typedef struct surfacePropertyTyp {  /* Typ fuer Variablen zum */
  float Ka, Kd, Ks, Oe;              /* Abspeichern der Ober- */
  rgb Os;                            /* flaecheneigenschaften  */
} surfacePropertyTyp;

typedef struct LsEntry {             /* Pointer auf Lichtquellenliste */
  long nr;
  LSType typ;
  boolean active;
  rgb Lc, KaLc, KdLc, KsOsLc;        /* Farbe u. Zwischenergebnisse*/
  float C1, C2, cosAsh, Le;          /* Bei Punkt- u. Spotlights   */
  vct3 Ld, Lp;                       /* Richtung u. Position       */
  struct LsEntry *Next, *Pred;       /* Vorige, naechste Lichtquelle*/
  struct LsEntry *NextActThisTyp;    /* Vorige bzw. naechste aktive */
  struct LsEntry *PredActThisTyp;    /* Lichtq. des gleichen Typs  */
} LsEntry;

typedef struct _MeshPntTyp {         /* Typ fuer Punkte in einem Mesh  */
  boolean isVis;                     /* Flag: nach Flipping sichtbar  */
  boolean isInNPC, isInWC;           /* Flags, wohin der Punkt schon  */
  boolean isInDC;                    /* transformiert wurde           */
  vertex a;                          /* affiner Punkt + Norm. + Farbe */
  vct4 h;                            /* homogener Punkt (nur Koord.)  */
  SHD_VTX l;                         /* Beleuchteter Punkt im DC      */
} _MeshPntTyp;

typedef _MeshPntTyp _MeshLineTyp[maxPnts + 1];

typedef unsigned int TzBuffer;

typedef rgbB CTable[256];       /* Farbtabelle */

#endif 
