//  LAST EDIT: Fri Feb 11 04:03:54 1994 by ekki(@prakinf.tu-ilmenau.de)
#include "fisher.h"

float gpow(float x, float y) {
  /* berechnet y=f(x) mit
				 /  0    fuer x < e^-8
			   f(x)= |  x^y  fuer e^-8 <= x <= 1-epsilon
                                 \  1    sonst

     Diese Bereichseinschraenkung fuer x wurde vorgenommen um ber- bzw.
     Unterlaeufe zu vermeiden. Da pow nur fuer Skallarprodukte von normierten
     Vektoren benutzt wird, diese aber hoechstens durch Rechenungenauigkeiten
     > 1 werden koennen, ist die Beschraenkung von x nach oben zulaessig.     */
  if (x > 1 - epsilon)
    return 1.0;
  else {
    x = log(x) * y;
    if (x < -8)
      return 0.0;
    else
      return exp(x);
  }
}


void DoLight(vertex p, rgbB *c) {
  /* Belichtet den Punkt p, der in Weltkkordinaten vorligen muss
     (Normale normiert) und liefert als Ergebnis die Farbe c
     auf ColRange normiert.                                                  */
  LsEntry *LsP;     /* Ptr. auf gerade aktuelle Lichtquelle         */
  vct3 vl;          /* Eiheitsvektor von p zur Lichtquelle          */
  vct3 vr;          /* Richtung des reflektierten Lichtes           */
  vct3 ve;          /* Eiheitsvektor von p zum Auge                 */
  float norm;       /* Abstand (p,Lichtquelle)                      */
  float cosa, tcosa;/* Skallarprodukt Vn*Vl und 2*(Vn*Vl)           */
  float cosb;       /* Skallarprodukt Ve*Vr                         */
  float cosc;       /* Skallarprodukt Ld*-Vl                        */
  float La;         /* Lichtschwaechung bei Punkt- und Spotlichtq.   */
  float fl, fl1;    /* Zwischenergebnisse                           */
  rgb Ca, Cd, Cs;   /* Farbanteile der verschiedenen Reflexionsarten*/
  double TEMP, TEMP1, TEMP2;

  Cd.r = 0.0; Cd.g = 0.0; Cd.b = 0.0; /* diffusen Anteil initialisieren */
  Cs.r = 0.0; Cs.g = 0.0; Cs.b = 0.0; /* dito fuer specularen Anteil     */
  ve.x = eyePoint.x - p.crd.x;   /* Vektor von p zum Auge          */
  ve.y = eyePoint.y - p.crd.y;
  ve.z = eyePoint.z - p.crd.z;
  if (DoNorm(&ve))
    GraphError("DoLight: Objekt geht durchs Auge!");
  /* ------------------ gerichtete Lichtquellen: --------------------------*/
  LsP = firstInf;        /* Pointer auf gerichtete Lichtq. */
  while (LsP != NULL) {  /* fuer alle gerichteten Lichtq.:  */
    cosa = -p.nrm.x * LsP->Ld.x - p.nrm.y * LsP->Ld.y - p.nrm.z * LsP->Ld.z;
	/* cos(Einfallswinkel)      */
    if (cosa > 0.0)
    {                               /* Lichtquelle von vorne?   */
      Cd.r += LsP->KdLc.r * cosa;   /* diffusen Anteil addieren */
      Cd.g += LsP->KdLc.g * cosa;
      Cd.b += LsP->KdLc.b * cosa;
      tcosa = 2.0 * cosa;           /* fuer Reflexionsvektor     */
      vr.x = tcosa * p.nrm.x + LsP->Ld.x;   /* Reflexionsvektor x       */
      vr.y = tcosa * p.nrm.y + LsP->Ld.y;   /* Reflexionsvektor y       */
      vr.z = tcosa * p.nrm.z + LsP->Ld.z;   /* Reflexionsvektor z       */
      cosb = ve.x * vr.x +         	        /* cos(<(Reflexionsvektor,  */
             ve.y * vr.y +                  /*       Vektor(p,Auge)))   */
             ve.z * vr.z;
      if (cosb > 0.0) {            /* Reflexionsvektor zum Betrachter ? */
 	      fl = gpow(cosb, surfaceProperty.Oe); /* Phong'sche Reflexion     */
	      Cs.r += LsP->KsOsLc.r * fl;          /* specularen Anteil add.   */
	      Cs.g += LsP->KsOsLc.g * fl;
	      Cs.b += LsP->KsOsLc.b * fl;
      }
    }
    LsP = LsP->NextActThisTyp;   /* Ptr. auf naechste Lichtq. */
  }  /* end all infinite ls */
  /* ------------------ Punkt-Lichtquellen: -------------------------------*/
  LsP = firstPos;        /* Ptr. auf erste Punkt-Lq. */
  while (LsP != NULL) {  /* fuer alle Punkt-Lichtq.   */
    TEMP = p.crd.x - LsP->Lp.x;
    TEMP1 = p.crd.y - LsP->Lp.y;
    TEMP2 = p.crd.z - LsP->Lp.z;
    norm = sqrt(TEMP * TEMP +   	/* Abstand (p,Lichtqelle)   */
                TEMP1 * TEMP1 +
                TEMP2 * TEMP2);
    La = 1.0 / (LsP->C1 + LsP->C2 * norm);   /* Lichtschwaechung          */
    if (La < 0)
      La = 0.0;
    vl.x = LsP->Lp.x - p.crd.x;   /* Vektor von p zur Lichtq. */
    vl.y = LsP->Lp.y - p.crd.y;
    vl.z = LsP->Lp.z - p.crd.z;
    if (DoNorm(&vl))
      GraphError("DoLight: Objekt trifft Lichtquelle");
    cosa = p.nrm.x * vl.x +       	/* cos(Einfallswinkel)  */
           p.nrm.y * vl.y +
           p.nrm.z * vl.z;
    if (cosa > 0.0)                 /* Lichtquelle vor p ?  */
    {
      fl = cosa * La;
      tcosa = 2.0 * cosa;
      Cd.r += LsP->KdLc.r * fl;   /* diffusen Anteil addieren */
      Cd.g += LsP->KdLc.g * fl;
      Cd.b += LsP->KdLc.b * fl;
      vr.x = tcosa * p.nrm.x - vl.x;/* Reflexionsvektor     */
      vr.y = tcosa * p.nrm.y - vl.y;
      vr.z = tcosa * p.nrm.z - vl.z;
      cosb = ve.x * vr.x +          /* siehe oben           */
             ve.y * vr.y +
             ve.z * vr.z;
      if (cosb > 0.0) {             /* Reflexion zum Auge?  */
     	  fl = gpow(cosb, surfaceProperty.Oe) * La;  /* siehe oben           */
	      Cs.r += LsP->KsOsLc.r * fl;          /* specularen Anteil add.   */
	      Cs.g += LsP->KsOsLc.g * fl;
	      Cs.b += LsP->KsOsLc.b * fl;
      }
    }
    LsP = LsP->NextActThisTyp;   /* Naechste Lichtquelle  */
  }  /* end of all positional ls */
  /* ------------------ Spot-Lichtquelln (Strahler): ----------------------*/
  LsP = firstSpt;        /* Ptr. auf erste Spot-Lichtq. */
  while (LsP != NULL) {  /* Fuer alle Spot-Lichtq.       */
    vl.x = LsP->Lp.x - p.crd.x;   /* Vektor von p zur Lichtq.    */
    vl.y = LsP->Lp.y - p.crd.y;
    vl.z = LsP->Lp.z - p.crd.z;
    if (DoNorm(&vl))
      GraphError("DoLight: Objekt trifft Lichtquelle");
    cosc = -LsP->Ld.x * vl.x -    	/* cos(<(Lichtrichtung,        */
            LsP->Ld.y * vl.y -      /*       Vektor(p,Lichtpos.))) */
            LsP->Ld.z * vl.z;
    if (cosc > LsP->cosAsh)         /* im Kegel des Strahlers?     */
    {
      TEMP = p.crd.x - LsP->Lp.x;
      TEMP1 = p.crd.y - LsP->Lp.y;
      TEMP2 = p.crd.z - LsP->Lp.z;
      norm = sqrt(TEMP * TEMP +     /* Siehe Punkt-Licht           */
                  TEMP1 * TEMP1 +
                  TEMP2 * TEMP2);
      La = 1.0 / (LsP->C1 + LsP->C2 * norm); 	  /* Lichtschwaechung             */
      if (La < 0)
     	  La = 0.0;
      cosa = p.nrm.x * vl.x +       /* siehe oben       */
             p.nrm.y * vl.y +
             p.nrm.z * vl.z;
      if (cosa > 0.0) {             /* Expon. Abfall der Lichtq.   */
	      fl1 = La * gpow(cosc, LsP->Le);
	      fl = cosa * fl1;
	      tcosa = 2.0 * cosa;
        Cd.r += LsP->KdLc.r * fl;   /* diffusen Anteil addieren */
        Cd.g += LsP->KdLc.g * fl;
        Cd.b += LsP->KdLc.b * fl;
	      vr.x = tcosa * p.nrm.x - vl.x;   /* siehe oben        */
	      vr.y = tcosa * p.nrm.y - vl.y;
	      vr.z = tcosa * p.nrm.z - vl.z;
	      cosb = ve.x * vr.x +        	    /* siehe oben        */
               ve.y * vr.y +
               ve.z * vr.z;
	      if (cosb > 0.0) {
	        fl = gpow(cosb, surfaceProperty.Oe) * fl1;
 	        Cs.r += LsP->KsOsLc.r * fl;          /* specularen Anteil add.   */
	        Cs.g += LsP->KsOsLc.g * fl;
	        Cs.b += LsP->KsOsLc.b * fl;
	      }
      }
    }  /* of lightsource is active */
    LsP = LsP->NextActThisTyp;   /* naechste Lichtquelle         */
  }  /*end of all spot ls */
  /* ------------------ ambiente Lichtquelle: -----------------------------*/
  if (ambLSdefined) {
    Ca.r = ambLsC.r * p.c.r;   /* Ambiente Farbe * ambienter Anteil der Lq.    */
    Ca.g = ambLsC.g * p.c.g;
    Ca.b = ambLsC.b * p.c.b;
  }
  else {
    Ca.r = 0.0; Ca.g = 0.0; Ca.b = 0.0 ;
  }
  Cd.r *= p.c.r;   /* Diffuse Farbe * diffuser Anteil d. Reflexion */
  Cd.g *= p.c.g;   /* Diffuse Farbe * diffuser Anteil d. Reflexion */
  Cd.b *= p.c.b;   /* Diffuse Farbe * diffuser Anteil d. Reflexion */

  fl = (Ca.r + Cd.r + Cs.r) * ColRange;   /* Summe u. normieren */
  if (fl < 0)
    c->r = 0;
  else
    if (fl > ColRange - 1.5)
      c->r = ColRange - 1;
    else
      c->r = (unsigned char)floor(fl + 0.5);

  fl = (Ca.g + Cd.g + Cs.g) * ColRange;   /* Summe u. normieren */
  if (fl < 0)
    c->g = 0;
  else
    if (fl > ColRange - 1.5)
      c->g = ColRange - 1;
    else
      c->g = (unsigned)floor(fl + 0.5);

  fl = (Ca.b + Cd.b + Cs.b) * ColRange;   /* Summe u. normieren */
  if (fl < 0)
    c->b = 0;
  else
    if (fl > ColRange - 1.5)
      c->b = ColRange - 1;
    else
      c->b = (unsigned char)floor(fl + 0.5);
}


boolean LsNrExists(int nr, LsEntry **LsP)
{
  /* liefert TRUE und pointer auf Lichtquelle mit dieser Nr. zurueck,
     falls sie existiert, sonst FALSE */
  boolean found;

  *LsP = LsListRoot;
  found = false;
  while (*LsP != NULL && !found) {
    found = ((*LsP)->nr == nr);
    if (!found)
      *LsP = (*LsP)->Next;
  }
  return found;
}


void addLs(int LsNr, boolean LsActive, LSType LsTyp,
           rgb LsC, float C1, float C2, float Le, float As,
           vct3 Ld, vct3 Lp)
{
  /* Traegt eine Lichtquelle mit der Nr. LsNr und dem Typ LsTyp in Lichtquellen-
     liste ein und berechnet die noetigen Zwischenergebnisse. Informationen, die
     nicht benoetigt werden (z.B. die Lichtrichtung Ld bei Punkt-Lichtquellen)
     muessen zwar uebergeben werden, brauchen aber keine sinvollen Werte haben.
     Diese Routine dient nur zum internen Gebarauch. Besser ist es,die Routinen
     AddAmbLs,AddInfLs,AddPosLs und AddSptLs (siehe weiter unten) aufzurufen */
  char s[256];      /* fuer Fehlermeldungen */
  LsEntry **first;  /* Adresse der Pointer auf ersten bzw. letzen Eintrag */
  LsEntry **last;   /* der Liste der aktive Lichtquellen des akt. Typs    */
  LsEntry *dummy;
  LsEntry *WITH;

  if (LsNrExists(LsNr, &dummy)) {  /* Lichtq. mit dieser Nr. schon da? */
    sprintf(s, "addLs: Lichtquelle Nr.%d existiert schon!", LsNr);
    GraphError(s);
    return;
  }
  if (LsListRoot == NULL) {  /* Erster Eintrag in Lichtquelleliste? */
    firstInf = NULL;
    firstPos = NULL;
    firstSpt = NULL;          /* typ-Listen auf NIL  */
    ambLSdefined = false;     /* keine ambiente Lq.  */
    LsListRoot = (LsEntry *)malloc(sizeof(LsEntry));/* neuer Eintrag       */
    LsListRoot->Pred = NULL;  /* Kein Vorgaenger      */
    LsListEnd = LsListRoot;   /* letzter = erster    */
  } else {                    /* nicht erster Eintrag*/
    LsListEnd->Next = (LsEntry *)malloc(sizeof(LsEntry));/* neuer Eintrag  */
    LsListEnd->Next->Pred = LsListEnd;   /* Zeiger auf Vorgaenger*/
    LsListEnd = LsListEnd->Next;         /* Ende weiter         */
  }
  LsListEnd->Next = NULL;     /* Kein Nachfolger     */
  LsListEnd->nr = LsNr;       /* Informationen eintragen       */
  LsListEnd->active = LsActive;
  LsListEnd->typ = LsTyp;
  LsListEnd->Lc = LsC;
  LsListEnd->KaLc.r = surfaceProperty.Ka * LsC.r;/* Zwischenergebnisse eintragen*/
  LsListEnd->KaLc.g = surfaceProperty.Ka * LsC.g;
  LsListEnd->KaLc.b = surfaceProperty.Ka * LsC.b;
  if ((long)LsTyp > (long)ambient) {       /* Zwischenergbnisse fuer diffuse */
    LsListEnd->KdLc.r = surfaceProperty.Kd * LsC.r;
    LsListEnd->KdLc.g = surfaceProperty.Kd * LsC.g;
    LsListEnd->KdLc.b = surfaceProperty.Kd * LsC.b;
    LsListEnd->KsOsLc.r = surfaceProperty.Ks *	/* und speculare Reflexion    */
                          surfaceProperty.Os.r * LsC.r;
    LsListEnd->KsOsLc.g = surfaceProperty.Ks *
                          surfaceProperty.Os.g * LsC.g;
    LsListEnd->KsOsLc.b = surfaceProperty.Ks *
                          surfaceProperty.Os.b * LsC.b;
    if ((long)LsTyp > (long)infinite) {    /* bei Punkt- u. Spot-Lichtq.    */
      LsListEnd->Lp = Lp;
      LsListEnd->C1 = C1;
      LsListEnd->C2 = C2;
    }
    if (((1L << ((long)LsTyp)) &
       ((1L << ((long)infinite)) | (1L << ((long)spot)))) != 0)
    {  /* Lichtrichtung normieren: */
      if (DoNorm(&Ld))
	      GraphError("addLs: Lichtrichtung nicht definiert!");
      LsListEnd->Ld = Ld;
    }
    if (LsTyp == spot) {
      LsListEnd->cosAsh = cos(As * M_PI / 180 * 0.5);
      LsListEnd->Le = Le;
    }
  }
  if (LsActive) {             /* Lichtquelle aktiv?        */
    WITH = LsListEnd;
    if (LsTyp == ambient) {   /* ambient */
      if (ambLSdefined) {     /* schon eine ambiente def.? */
   	    ambLsC.r += WITH->KaLc.r; /* Ambiente Lq. aufaddieren  */
   	    ambLsC.g += WITH->KaLc.g;
   	    ambLsC.b += WITH->KaLc.b;
      }
      else {
	      ambLSdefined = true;
	      ambLsC.r = WITH->KaLc.r;  /* ambiente Lq. an u. setzen */
 	      ambLsC.g = WITH->KaLc.g;
 	      ambLsC.b = WITH->KaLc.b;
      }
    } else {
      switch (LsTyp) { /* Je nach Typ Adr. der Pointer auf ersten u. letzten*/
	case infinite:   first = &firstInf; last = &lastInf; break;
        case positional: first = &firstPos; last = &lastPos; break;
        case spot:       first = &firstSpt; last = &lastSpt; break;
        case ambient:;
      }
      if (*first == NULL) {  /* Noch keine akt. Lichtq. diese Typs? */
      	*first = LsListEnd;
      	*last = *first;   /* erste u. letzte auf Lq.   */
      	(*last)->NextActThisTyp = NULL; /* Nein!  Das ist kein Druckfehler! */
	      (*first)->PredActThisTyp = NULL;/* Viel Spass beim Gruebeln!         */
      } else {
	      (*last)->NextActThisTyp = LsListEnd; /* alte letze Lq. wird vorletze*/
	      LsListEnd->PredActThisTyp = *last;   /* alte letze Lq. wird vorletze*/
	      *last = LsListEnd;   /* diese Lq. wird letzte       */
      }  /* *first != NULL */
    }  /* not ambient */
  }  /* if active */
  LsListEnd->NextActThisTyp = NULL;   /* Keine naechste Lq. diese Typs*/
}


void ClearLs(int nr)
{
  /* Loescht die Lichtquelle mit der angegebenen Nummer aus der Lichtquellen-
     liste. Danach steht die Nummer fuer neue Lichtquelle zur Verfuegung.      */
  LsEntry *LsP;   /* Pointer auf Lichtquelle dieser Nummer */
  char s[256];   /* Fuer Fehlermeldung                     */

  if (LsNrExists(nr, &LsP)) {   /* Lichtquelle def. ?     */
    if (LsP->Pred != NULL)      /* abketten               */
      LsP->Pred->Next = LsP->Next;
    if (LsP->Next != NULL)      /* abketten               */
      LsP->Next->Pred = LsP->Pred;
    if (LsP == LsListRoot)      /* erste?  Dann neue root */
      LsListRoot = LsP->Next;
    if (LsP->active) {
      if (LsP->typ == ambient) {
	      ambLsC.r -= LsP->KaLc.r;    /* Lichtq. "wegrechnen"   */
	      ambLsC.g -= LsP->KaLc.g;
	      ambLsC.b -= LsP->KaLc.b;
	      ambLSdefined = (fabs(ambLsC.r) > epsilon) &&
                       (fabs(ambLsC.g) > epsilon) &&
                       (fabs(ambLsC.b) > epsilon); /* 0? keine ambiente Lq! */
      } else {
	      if (LsP->PredActThisTyp != NULL)   /* Nicht erste aktive ?   */
	        LsP->PredActThisTyp->NextActThisTyp = LsP->NextActThisTyp;/*abketten*/
	      else {
	        switch (LsP->typ) {   /* zweite Lq. wird erste  */
	        case infinite:   firstInf = LsP->NextActThisTyp; break;
	        case positional: firstPos = LsP->NextActThisTyp; break;
	        case spot: 	     firstSpt = LsP->NextActThisTyp; break;
		case ambient:;		 
	        }
	      }
	      if (LsP->NextActThisTyp != NULL)   /* Nicht letzte Lq.?      */
	        LsP->NextActThisTyp->PredActThisTyp = LsP->PredActThisTyp;/*abketten*/
      }
    }
    free(LsP);   /* loeschen      */
    return;
  }
  sprintf(s, "ClearLs: Lichtquelle mit Nr %d existiert nicht!, nr");
  GraphError(s);
}


void SwitchLs(int nr, boolean on)
{
  /* Schaltet Lichtquelle mit Nummer nr aus (on=FALSE) bzw. an. Im Gegensatz
     zu ClearLs loescht SwitchLs die Lichtquelle bei not on nicht, sondern
     kettet sie nur aus der Liste der aktiven Lichtquellen aus. Die Lq.
     existiert weiter und kann wieder eingeschaltet werden.                   */
  LsEntry **first, **last;   /* wie bei addLs       */
  LsEntry *LsP;   /* Pointer auf Lichtquelle, die geschaltet wird */
  char s[256];    /* Fuer Fehlermeldungen   */

  if (LsNrExists(nr, &LsP)) {
    if (on && !LsP->active) {  /* einschalten:          */
      if (LsP->typ == ambient) {
	      ambLsC.r += LsP->KaLc.r;   /* Anteil der Lq. add.   */
	      ambLsC.g += LsP->KaLc.g;   /* Anteil der Lq. add.   */
	      ambLsC.b += LsP->KaLc.b;   /* Anteil der Lq. add.   */
	      ambLSdefined = true;
      } else {
	      switch (LsP->typ) {   /* wie bei addLS         */
	      case infinite:   first = &firstInf; last = &lastInf; break;
	      case positional: first = &firstPos; last = &lastPos; break;
	      case spot:    	 first = &firstSpt; last = &lastSpt; break;
		case ambient:;	       
	      }
	      if (*first == NULL) {  /* einzige dieses Typs?  */
	        *first = LsP;
	        *last = LsP;   /* Anfang u. Ende setzen */
	      } else {
	        (*last)->NextActThisTyp = LsP;   /* anketten              */
	        LsP->PredActThisTyp = *last;   /* anketten              */
	        *last = LsP;   /* diese Lq. = letze Lq. */
	      }  /* not first */
      }  /* not ambient */
    } else
      if (!on && LsP->active) {
        if (LsP->typ == ambient) {  /* ambient?              */
	        ambLsC.r -= LsP->KaLc.r;   /* Lq. "rausrechnen"     */
	        ambLsC.g -= LsP->KaLc.g;   /* Lq. "rausrechnen"     */
	        ambLsC.b -= LsP->KaLc.b;   /* Lq. "rausrechnen"     */
          ambLSdefined = (fabs(ambLsC.r) > epsilon) &&
                         (fabs(ambLsC.g) > epsilon) &&
                         (fabs(ambLsC.b) > epsilon); /* 0? keine ambiente Lq! */
        } else {
	        if (LsP->PredActThisTyp != NULL) {  /* nicht erste Lq.?      */
	        if (LsP->NextActThisTyp != NULL)   /* nicht letzte des Typs */
	          LsP->NextActThisTyp->PredActThisTyp = LsP->PredActThisTyp;/*abketten*/
	        else {
	          switch (LsP->typ) {   /* letzte des Typs       */

	          case infinite:
              if (LsP->PredActThisTyp->PredActThisTyp != NULL)
		            lastInf = LsP->PredActThisTyp->PredActThisTyp->NextActThisTyp;
	            else
		            lastInf = firstInf;
	            break;

  	        case positional:
	            if (LsP->PredActThisTyp->PredActThisTyp != NULL)
		            lastPos = LsP->PredActThisTyp->PredActThisTyp->NextActThisTyp;
	            else
		            lastPos = firstPos;
	            break;

  	        case spot:
	            if (LsP->PredActThisTyp->PredActThisTyp != NULL)
		            lastSpt = LsP->PredActThisTyp->PredActThisTyp->NextActThisTyp;
	            else
		            lastSpt = firstSpt;
	            break;
	    case ambient:;
  	        }
	        }
	        LsP->PredActThisTyp->NextActThisTyp = LsP->NextActThisTyp;/* abketten */
	      } else {  /* erste Lichtquelle:    */
		switch (LsP->typ) {           /* naechste Lq. wird erste*/
  	      case infinite:   firstInf = LsP->NextActThisTyp; break;
      	  case positional: firstPos = LsP->NextActThisTyp; break;
      	  case spot: 	     firstSpt = LsP->NextActThisTyp; break;
         case ambient:;
	        }
	          if (LsP->NextActThisTyp != NULL)   /* nicht einzige?        */
	            LsP->NextActThisTyp->PredActThisTyp = NULL;
  	      }  /* erste Lichtquelle */
	      LsP->PredActThisTyp = NULL;
	      LsP->NextActThisTyp = NULL;   /* abketten              */
      }
    }
    LsP->active = on;   /* Flag setzen           */
    return;
  }
  sprintf(s, "SwitchLs: Lichtquelle mit Nr %d existiert nich!, nr");
  GraphError(s);
}


void ChangeSurfaceProperty(float NewKa, float NewKd, float NewKs,
                           rgb NewOs, float NewOe)
{
  /* Setzt die Oberflaecheneigenschaften der Objekte, die anschliessend
     gezeichnet werden.
     Parameter:
       NewKa: ambienter Anteil der Reflexion  (0..1)
       NewKd: diffuser Anteil der Reflexion   (0..1)
       NewKs: spekularer Anteil der Reflexion (0..1)
       ( Die Summe aus Ka,Kd u. Ks sollte in etwa 1 betragen )
       NewOs: Farbe bei spekularer Reflexion
       NewOe: Spekularer Exponent             (1..ca.50)                     */
  LsEntry *LsP;   /* Pointer auf Lichtquelle */

  LsP = LsListRoot;   /* Pointer auf erste Lq.   */
  while (LsP != NULL) {  /* fuer alle Lichtquellen:  */
    LsP->KaLc.r = LsP->Lc.r * NewKa;   /* Zwischenerg. erneuern   */
    LsP->KaLc.g = LsP->Lc.g * NewKa;
    LsP->KaLc.b = LsP->Lc.b * NewKa;

    LsP->KdLc.r = LsP->Lc.r * NewKd;
    LsP->KdLc.g = LsP->Lc.g * NewKd;
    LsP->KdLc.b = LsP->Lc.b * NewKd;

    LsP->KsOsLc.r = LsP->Lc.r * NewOs.r * NewKs;
    LsP->KsOsLc.g = LsP->Lc.g * NewOs.g * NewKs;
    LsP->KsOsLc.b = LsP->Lc.b * NewOs.b * NewKs;

    LsP = LsP->Next;   /* naechste Lichtquelle     */
  }
  if (ambLSdefined) { /* alte amb. gegen neue  */
    ambLsC.r = ambLsC.r / surfaceProperty.Ka * NewKa;
    ambLsC.g = ambLsC.g / surfaceProperty.Ka * NewKa;
    ambLsC.b = ambLsC.b / surfaceProperty.Ka * NewKa;
  }
  surfaceProperty.Ka = NewKa;
  surfaceProperty.Kd = NewKa;
  surfaceProperty.Ks = NewKa;   /* neue Werte in Record    */
  surfaceProperty.Os = NewOs;
  surfaceProperty.Oe = NewOe;
}


void addAmbLs(int Nr, boolean active, rgb Lc)
{
  /* Traegt eine ambiente Lichtquelle mit Nummer Nr und Farbe Lc in die
     Lichtquellenliste ein. Ist active=TRUE, wird die Lq. bei der Lighting-
     berechnung beruecksichtigt.                                             */
  addLs(Nr, active, ambient, Lc, 0.0, 0.0, 0.0, 0.0, e_z, e_z);
}


void addInfLs(int Nr, boolean active, rgb Lc, float LdX, float LdY, float LdZ)
{
  /* wie addAmbLs fuer gerichtete Lichtquellen. Zusaetzlich (LdX,LdY,LdZ) als
     Lichtrichtung */
  vct3 Ld;

  Ld.x = LdX;
  Ld.y = LdY;
  Ld.z = LdZ;
  addLs(Nr, active, infinite, Lc, 0.0, 0.0, 0.0, 0.0, Ld, e_z);
}


void addPosLs(int Nr, boolean active, rgb Lc, float LpX, float LpY,
              float LpZ, float C1,  float C2)
{
  /* wie addInfLs fuer Punktlichtquellen. Hier wird nicht die Lichtrichtung
     sonder die Position der Lichtquelle (LpX,LpY,LpZ) angegeben. C1 und C2
     dienen zur Lichtschwaechung. ( Fuer C1=1 und C2=0 nimmt das Licht bei
     wachsender Entfernung nicht ab! )                                      */
  vct3 Lp;

  Lp.x = LpX;
  Lp.y = LpY;
  Lp.z = LpZ;
  addLs(Nr, active, positional, Lc, C1, C2, 0.0, 0.0, e_z, Lp);
}


void addSptLs(int Nr, boolean active,
              rgb Lc, float LdX, float Ldy, float LdZ, float LpX,
              float LpY, float LpZ, float C1, float C2, float Le, float As)
{
  /* Traegt einen Strahler mit der Nummer Nr in die Lichtquellenliste ein.
     Bei active=TRUE wird dieser Strahler bei der Lightingberechnung berueck-
     sichtigt. Parameter:
     Lc:            Lichtquellenfarbe
     (LdX,LdY,LdZ): Bevorzugte Lichtrichtung
     (LpX,LpY,LpZ): Position des Strhlers
     C1,C2:         Koeffizienten fuer Lichtschwaechung (siehe addPosLs)
     Le:            Abklingexponent des Strahlers (0..ca.30)
     As:            Oeffnungswinkel des Lichtkegels in Grad (0..180)          */
  vct3 Lp, Ld;

  Ld.x = LdX;
  Ld.y = Ldy;
  Ld.z = LdZ;
  Lp.x = LpX;
  Lp.y = LpY;
  Lp.z = LpZ;
  addLs(Nr, active, spot, Lc, C1, C2, Le, As, Ld, Lp);
}
