//  LAST EDIT: Mon Feb 20 17:23:15 1995 by ekki(@prakinf.tu-ilmenau.de)
#include "fdither.h"

// dither stuff:
// this is parameterized so that (in theory), you could query for the
// "standard" colormap (perhaps by calling XmuGetColormapAllocation)
// to get the best values of rt_[r,g,b]Mult and rt_[r,g,b]Max

int rt_rMult = 25, rt_rMax = 4, rt_rDitherMultiplier;
int rt_gMult = 5, rt_gMax = 4, rt_gDitherMultiplier;
int rt_bMult = 1, rt_bMax = 4, rt_bDitherMultiplier;
int *rt_Cmap = 0;

int RT_ditherRGB(int x, int y, const RT_Color &col) {
    long cmp, rIntensity, gIntensity, bIntensity;
    int r,g,b;
  
    r = (int)(col.r * rt_rDitherMultiplier);
    g = (int)(col.g * rt_gDitherMultiplier);
    b = (int)(col.b * rt_bDitherMultiplier);

    static unsigned char ditherMatrix[8][8] = {
	{ 0,  32,  8, 40,  2, 34, 10, 42 },
	{ 48, 16, 56, 24, 50, 18, 58, 26 },
	{ 12, 44,  4, 36, 14, 46,  6, 38 },
	{ 60, 28, 52, 20, 62, 30, 54, 22 },
	{  3, 35, 11, 43,  1, 33,  9, 41 },
	{ 51, 19, 59, 27, 49, 17, 57, 25 },
	{ 15, 47,  7, 39, 13, 45,  5, 37 },
	{ 63, 31, 55, 23, 61, 29, 53, 21 }
    };

    cmp = ditherMatrix[x & 7][y & 7];

    if (r < 0) rIntensity = 0;
    else if (r > rt_rDitherMultiplier) rIntensity = rt_rMax;
    else rIntensity = (r >> 6) + ((r & 63) > cmp);

    if (g < 0) gIntensity = 0;
    else if (g > rt_gDitherMultiplier) gIntensity = rt_gMax;
    else gIntensity = (g >> 6) + ((g & 63) > cmp);

    if (b < 0) bIntensity = 0;
    else if (b > rt_bDitherMultiplier) bIntensity = rt_bMax;
    else bIntensity = (b >> 6) + ((b & 63) > cmp);

    return(rt_Cmap[ 
		   rIntensity * rt_rMult +
		   gIntensity * rt_gMult +
		   bIntensity * rt_bMult
		   ]
	   );
}



