#ifndef __SCENE_H__
#define __SCENE_H__

////////////////////////////////////////////////////////////////////////////////
// A special container class called Scene.                                    //  
// LAST EDIT: Fri Aug  5 08:55:10 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "rlist.h"
#include "object.h"

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <stdarg.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

#include "color.h"

extern const char *RTN_SCENE;

class RT_Camera;
// a forward to avoid cycles

class RT_Scene: public RT_GeneralList, public RT_Object {
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int remF, objG, updF; 
    static char *remV;
    static RT_Color colrV;
    static int colrG, colrF;
    RT_Color xbackground;
  public:
    //##### the Tcl/C++ methods:
    RT_Scene(char *_name = 0): RT_Object(_name) {}
    
    const char *get_description() const { return "A scene containing an unordered set of primitives as input for rendering."; }
    int isA(const char *n) const { return RTM_isA( n, RTN_SCENE) || RT_Object::isA( n ); }
    const char *get_class() const { return RTN_SCENE; }
    void print(FILE *) const; 
    
    void insert(RT_Object *);
    void insert(RT_Object *, RT_Object * ...); 
    
    void remove(RT_Object *o) { RT_GeneralList::remove( o ); } 
    
    const RT_GeneralList &get_objects() const { return *this; }
    // yeah, this is a formal method on C++ level
    
    virtual void update();
    // update a scene before rendering/raytracing
    
    void background(const RT_Color &c) { xbackground = c; }
    const RT_Color &get_background() const { return xbackground; }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

#endif
