#ifndef __RS_IO_H__
#define __RS_IO_H__

////////////////////////////////////////////////////////////////////////////////
//            File based input/output of radiosity computation.               //   
//  LAST EDIT: Fri Aug  5 08:55:09 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "rs_defs.h"

extern int rt_RSYMsg; // set it to 1 to print debugging messages

//in/out functions
class RT_RS_IO {
protected:
  static char fmt[RS_LINE_LEN];
  static char RS_s[RS_LINE_LEN];
  static char RS_s1[RS_LINE_LEN];

  boolean getfloat(char* filename, FILE *fp, float& f, char* _s, int& j);

  boolean getlong(char* filename, FILE *fp, long& l, char* _s, int& j);

  boolean getint(char* filename, FILE *fp, int& i, char* _s, int& j);

  boolean getstr(char* filename, FILE *fp, char* _s, char* _str, int& j);

  boolean getlinestr(char* filename, FILE *fp, char* _s, char* _str, int& j);

  boolean getline(char* filename, FILE *fp, char *s);

  boolean isclass(char* filename, char* s);

  boolean checkdim(char* filename, long dim, long min, long max);

  boolean openfile(char* filename, FILE*& fp, char* mode);

  boolean isfloat(char c);

  boolean islong(char c);

public:
  virtual char* get_class() = 0;

  virtual boolean read(char *filename, FILE *fp) = 0; // read ASCII from a file. 

  virtual boolean write(char *filename, FILE *fp) = 0; // write to ASCII file. 

  virtual void print(FILE *f, char *n, int width, int decimalPlaces) = 0;
};


#endif

