#ifndef __RS_INMAT_H__
#define __RS_INMAT_H__

////////////////////////////////////////////////////////////////////////////////
//                      Intensity function class.                             //   
//  LAST EDIT: Fri Aug  5 08:55:09 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <math.h>
#include "rs_sphr.h"
#include "rs_io.h"

//intensity distribution function
class RT_RS_InsMatrix : public RT_RS_MVGeneral, public RT_RS_IO, public RT_RS_spherical_harmonics {
  protected:
    float max, min;
    float *fm;           // pointer to the coefficients vector
    unsigned char *cm;   // pointer to compressed coefficients Vector
    void alloch(int n, float cf, char atemp); //allocate heap memory
    void freeh();        //free heap
  public:
    float avg;           //average of the function
    char *get_class() { return "RS_InsMatrix"; }
    
    //constructors
    RT_RS_InsMatrix(char *filename, FILE *fp = NULL);
    RT_RS_InsMatrix(int n = 0, float cf = .0, char atemp = 'n') { alloch(n, cf, atemp); }
    RT_RS_InsMatrix( RT_RS_InsMatrix& a);
    //destructor
    ~RT_RS_InsMatrix() { freeh(); }
    
    void compress();     //pack coefficients vector
    void expand();       //expand packed coefficients
    
    void set(float f = .0);
    float eval(float theta_out, float phi_out);   //evaluate the function at theta_out, phi_out
    float&           operator () (int i, int j);  //range checked element
    RT_RS_InsMatrix& operator =  ( RT_RS_InsMatrix& a);
    RT_RS_InsMatrix  operator +  ( RT_RS_InsMatrix& a);
    RT_RS_InsMatrix  operator -  ( RT_RS_InsMatrix& a);
    RT_RS_InsMatrix  operator *  ( float f);
    RT_RS_InsMatrix  operator /  ( float f);
    
    //in/out functions
    boolean read(char *filename, FILE *fp = NULL); // read from a file.
    boolean write(char *filename, FILE *fp = NULL); // write to file.
    void print(FILE *f, char *n = NULL, int width = 8, int decimalPlaces = 2);
};

#endif

