#ifndef __RS_BRDF_H__
#define __RS_BRDF_H__

////////////////////////////////////////////////////////////////////////////////
//          Bidirectional Reflectance Distribution Function classes.          //   
//  LAST EDIT: Fri Aug  5 08:55:09 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "rs_vec.h"
#include "rs_sphr.h"
#include "rs_inmat.h"
#include "rs_io.h"

//BRDF-coefficient (one-dimensional cubic spline)
class RT_RS_SpCoeff : public RT_RS_MVGeneral, public RT_RS_IO
{
  RT_RS_Vector *x, *y, *b, *c, *d; //control points / coefficients
  int isZero;
  void alloch(int npnts, float f, char atemp); //allocate heap memory
  void freeh(); // free heap memory
public:
  char *get_class() { return "RS_SpCoeff"; }

  //constructors:
  RT_RS_SpCoeff(char *filename, FILE *fp = NULL);
  RT_RS_SpCoeff(int npnts, float cf = .0, char atemp = 'n')
    { alloch(npnts, cf, atemp); }
  RT_RS_SpCoeff(RT_RS_SpCoeff& a);
  //destructor
  ~RT_RS_SpCoeff() { freeh(); }

  void set(float f = .0);  
  void set_spl(RT_RS_Vector& ax, RT_RS_Vector& ay);   //set spline with control points ax ,ay
  void comp_spl();    //compute the spline-coefficients
  RT_RS_Vector& get_x() { return *x; } //get the x-values of the control points
  RT_RS_Vector& get_y() { return *y; } //get the y-values of the control points
  RT_RS_SpCoeff& operator = (RT_RS_SpCoeff& a);
  float eval(float theta_in); //evaluate the function at theta_in

  //in/out functions
  boolean read(char *filename, FILE *fp = NULL); // Read ASCII from a file.
  boolean write(char *filename, FILE *fp = NULL); // Write to ASCII file.
  void print(FILE *f, char *n = NULL, int width = 8, int decimalPlaces = 2);
};

//BRDF
class RT_RS_BRDFMatrix : public RT_RS_MVGeneral, public RT_RS_IO,
                         public RT_RS_spherical_harmonics
{
  char* description;
  char* name;
  RT_RS_SpCoeff **scm; //the coefficients
  RT_RS_SpCoeff *avg;  //the average of the function
  int npnts;           //number of coefficients- control points
  void alloch(int n, int anpnts, float cf, char atemp);  //allocate heap memory
  void freeh(); // free heap memory
public:
  char *get_class() { return "RS_BRDFMatrix"; }
  char *get_name() { return name ? name : NONAME; }
  char *get_description() { return description ? description : NODESCRIPTION; }

  //constructors:
  RT_RS_BRDFMatrix(char *filename, FILE *fp = NULL);
  RT_RS_BRDFMatrix(int n, int anpnts, float cf = .0, char atemp = 'n',
                   char* aname = NULL, char* adescription = NULL) :
    name(aname), description(adescription) { alloch(n, anpnts, cf, atemp); }
  RT_RS_BRDFMatrix(RT_RS_BRDFMatrix& a);
  //destructor
  ~RT_RS_BRDFMatrix() { freeh(); }

  void set(float f = .0);
  void set_scm(RT_RS_lmMatrix& mx, RT_RS_lmMatrix& my, int pnt); //set the coefficients- control point pnt
  void set_avg(float x, float y, int pnt);   //set average control point pnt
  RT_RS_SpCoeff& get_avg() { return *avg; }  //returns the average
  void comp_scm();                           //compute the coefficients
  int get_npnts() { return npnts; }          
  RT_RS_InsMatrix eval(float theta_in, float phi_in, float scale_val); //evaluate the function at theta_in, phi_in
  RT_RS_SpCoeff& operator() (int i, int j);  //get coefficient at i, j

  //in/out functions
  boolean read(char *filename, FILE *fp = NULL); // Read ASCII from a file.
  boolean write(char *filename, FILE *fp = NULL); // Write to ASCII file.
  void print(FILE *f, char *n = NULL, int width = 8, int decimalPlaces = 2);
};

//BRDF-container (contains the BRDFs of the scene)
class RT_RS_BRDFs : public RT_RS_IO
{
protected:
  int cnt;
  RT_RS_BRDFMatrix* BRDFs[RS_MAX_BRDFS];
  void freeh();
public:
  char* get_class() { return "RS_BRDFs"; }

  //constructors:
  RT_RS_BRDFs(char *filename, FILE *fp = NULL);
  RT_RS_BRDFs() : cnt(0) {}
  //destructor
  virtual ~RT_RS_BRDFs() { freeh(); }

  int get_cnt() { return cnt; } //returns the number of BRDFs
  boolean insert(RT_RS_BRDFMatrix* a); //insert a new BRDF
  RT_RS_BRDFMatrix* get_at(int n);  //get the BRDF  at index n
  RT_RS_BRDFMatrix* get_brdf(char* name); // get the BRDF with name
  int get_brdfidx(char* name); //get index of BRDF with name

  //in/out functions
  boolean read(char *filename, FILE *fp = NULL); // Read ASCII file.
  boolean write(char *filename, FILE *fp = NULL); // Write to ASCII file.
  void print(FILE *f, char *n = NULL, int width = 8, int decimalPlaces = 2);
};


#endif
