////////////////////////////////////////////////////////////////////////////////
//  LAST EDIT: Mon Mar 28 14:14:03 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              ekki@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1993 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef __RS_AREAS_H__
#define __RS_AREAS_H__

#include "rs_scene.h"
#include "rs_pnts.h"
#include "rs_inmat.h"
#include "rs_brdf.h"
#include "rs_io.h"

//some forwards to avoid cycles:
//a patch defined by four vertices
class RT_RS_Area;
//a diffuse patch
class RT_RS_DiffArea;
//a non-diffuse patch
class RT_RS_InsArea;

//a contains the patches of the scene
class RT_RS_Areas : public RT_RS_IO
{
protected:
  RT_RS_Scene* scene;   //pointer to the scene
  long dcnt, icnt, max_mesh_nr;
  int dspns, ispns;
  RT_RS_DiffArea** dArs[1024];
  RT_RS_InsArea** iArs[1024];

  void dallc(); //allocate memory for diffuse patches
  void iallc(); //allocate memory for non-diffuse patches
  void freeh(); //free heap

  //the meshing functions:
    //subdivide a patch:
  void subdivide(RT_RS_Area* a, long n);
    //anchor the neighbors:
  void anchor1(RT_RS_Area* a, long n, long to_old_area,
         long to_new_area1, long to_new_area2,
         long shared_vtxidx, long& area1_nb, long& area2_nb);
  void anchor1to2a(RT_RS_Area* ab, long ab_idx, long ac_idx, long ad_idx,
         long to_old_area, long to_new_area1, long to_new_area2,
         long shared_vtxidx, long& area1_nb, long& area2_nb);
  void anchor1to2b(RT_RS_Area* ab, long ab_idx, long ac_idx, long ad_idx,
         long to_new_area1, long to_new_area2, long shared_vtxidx);
  void anchor2ato3(RT_RS_Area* ae, long ae_idx, long af_idx, long ag_idx, long ah_idx,
         long to_old_area, long to_new_area1, long to_new_area2,
         long shared_vtxidx, long& area1_nb, long& area2_nb);
  void anchor2bto3(RT_RS_Area* ai, long ai_idx, long aj_idx, long ak_idx,
         long to_old_area, long to_new_area1, long to_new_area2,
         long shared_vtxidx, long& area1_nb, long& area2_nb);
    //re-anchor before subdivision of anchored patches:
  void re_anchor1(RT_RS_Area* ab, long ab_idx, long ac_idx, long ad_idx);
  void re_anchor2a(RT_RS_Area* ae, long ae_idx, long af_idx, long ag_idx, long ah_idx);
  void re_anchor2b(RT_RS_Area* ai, long ai_idx, long aj_idx, long ak_idx);
  void re_anchor3(RT_RS_Area* al, long al_idx, long am_idx, long an_idx, long ao_idx,
         long& area1_nb, long& area2_nb, long to_old_area = -1,
         long to_new_area1 = -1, long to_new_area2 = -1,
         long shared_vtxidx = -1);
    //make square:
  void make_square();
  void make_square_diff(long n);
  void make_square_ins(long n);

public:
  //the meshing parameters:
  boolean auto_mesh;  
  float diff_min_area,
        ins_min_area,
        edge_min_area,
        shadow_min_area,
        light_min_area,
        grad_min_area,
        grad_max_delta;

  char* get_class() { return "RS_Areas"; }
  //constructors
  RT_RS_Areas(RT_RS_Scene* ascene, char *filename, FILE *fp = NULL) :
    scene(ascene), dcnt(0), icnt(0), dspns(0), ispns(0), max_mesh_nr(0)
    {  if(!read(filename, fp)) freeh(); }
  RT_RS_Areas(RT_RS_Scene* ascene);
  //destructor
  virtual ~RT_RS_Areas() { freeh(); }

  RT_RS_Scene* get_scene() { return scene; }
  long get_diffcnt() { return dcnt; }   //get the number of diffuse patches
  long get_inscnt() { return icnt; }    //get the number of non-diffuse patches
  void insert(RT_RS_DiffArea* a);       //insert a diffuse patch
  void insert(RT_RS_InsArea* a);        //insert a non-diffuse patch
  void get(long n, RT_RS_DiffArea*& darea); //get the diffuse patch at index n
  void get(long n, RT_RS_InsArea*& iarea);  //get the non-diffuse patch at index n
  long get_mesh_nr() { return max_mesh_nr; }//get number of meshs
  long get_new_mesh_nr() { return max_mesh_nr++; }
  RT_RS_DiffArea* get_diff(long n) { RT_RS_DiffArea* da; get(n, da); return da; }
  RT_RS_InsArea*  get_ins(long n) { RT_RS_InsArea* ia; get(n, ia); return ia; }

  void subdivide_init();  //the initial meshing steps (before solution)
  void subdivide_grad();  //intensity dependend meshing (during solution)
#ifdef RS_DEBUG
  void check_mesh();
#endif

  //in/out functions
  boolean read(char *filename, FILE *fp = NULL); // Read ASCII file.
  boolean write(char *filename, FILE *fp = NULL); // Write to ASCII file.
  void print(FILE *f, char *n = NULL, int width = 8, int decimalPlaces = 2);
};

//a patch defined by four vertices
class RT_RS_Area : public RT_RS_IO
{
  friend RT_RS_Areas; //the container
protected:
  RT_RS_Scene* scene; //pointer to the scene
  float ar;           //patch's area
  long mesh_nr;       //the mesh this patch belongs to
  unsigned char anchor_type;
  long neighbors[4];  //the neighbor-patches of the patch
public:
  long vidx[4];       //the vertices of the patch

  char* get_class() { return "RS_Area"; }
  //constructors:
  RT_RS_Area(RT_RS_Scene* ascene, char *filename, FILE *fp = NULL) :
    scene(ascene) { read(filename, fp); }
  RT_RS_Area(RT_RS_Scene* ascene = NULL) : scene(ascene) {}
  RT_RS_Area(long v0, long v1, long v2, long v3,
            long n0, long n1, long n2, long n3, long amesh_nr,
            RT_RS_Scene* ascene = NULL);

  void set_scene(RT_RS_Scene* ascene) { scene = ascene; }
  virtual long get_cnt() = 0; //get the number of patches
  virtual void insert(RT_RS_Area* a) = 0;  //insert into container
  virtual void insert_ip(int n, long* vtxidx,
    RT_RS_Vtx*& new_vtx, long& new_vtxidx) = 0; //interpolate a vertex and insert into container
  virtual RT_RS_Vtx* get_vtx(long i) = 0;  //get a vertex from container
  virtual RT_RS_Area* get_area(long i) = 0; //get a patch from container
  virtual RT_RS_Area* new_area(long v0, long v1, long v2, long v3,
            long n0, long n1, long n2, long n3, long amesh_nr,
            RT_RS_Scene* ascene = NULL) = 0;  //create a new patch
  RT_RS_Vtx comp_center();   //compute the center vertex of the patch
  void comp_ar(); //compute area
  void sub_ar();  //subtract area
  void set_ar0(); //set the area of the vertices 0

  //in/out functions
  boolean read(char *filename, FILE *fp = NULL); // Read ASCII file.
  boolean write(char *filename, FILE *fp = NULL); // Write to ASCII file.
  void print(FILE *f, char *n = NULL, int width = 8, int decimalPlaces = 2);
};


//a diffuse patch
class RT_RS_DiffArea : public RT_RS_Area
{
public:
  char* get_class() { return "RS_DiffArea"; }
  //constructors:
  RT_RS_DiffArea(RT_RS_Scene* ascene, char *filename, FILE *fp = NULL) :
    RT_RS_Area(ascene) { read(filename, fp); }
  RT_RS_DiffArea(RT_RS_Scene* ascene = NULL) : RT_RS_Area(ascene) {}
  RT_RS_DiffArea(long v0, long v1, long v2, long v3,
                long aright, long aupper, long aleft, long abottom,
                long amesh_nr, RT_RS_Scene* ascene = NULL) :
    RT_RS_Area(v0, v1, v2, v3, aright, aupper, aleft, abottom, amesh_nr, ascene) {}
  //destructor:
  virtual ~RT_RS_DiffArea() { set_ar0(); };

  long get_cnt() { return scene->Areas->get_diffcnt(); }
  void insert(RT_RS_Area* a) { scene->Areas->insert((RT_RS_DiffArea*) a); }
  void insert_ip(int n, long* vtxidx, RT_RS_Vtx*& new_vtx, long& new_vtxidx);
  RT_RS_DiffVtx* get_dvtx(long i);
  RT_RS_Vtx* get_vtx(long i) { return get_dvtx(i); }
  RT_RS_Area* get_area(long i);
  RT_RS_Area* new_area(long v0, long v1, long v2, long v3,
            long n0, long n1, long n2, long n3, long amesh_nr,
            RT_RS_Scene* ascene = NULL)
    { RT_RS_DiffArea* new_a = new RT_RS_DiffArea(v0, v1, v2, v3, n0, n1, n2, n3, amesh_nr, ascene);
      return new_a;
    }
};

//a non-diffuse patch
class RT_RS_InsArea : public RT_RS_Area
{
public:
  char* get_class() { return "RS_InsArea"; }

  //constructors:
  RT_RS_InsArea(RT_RS_Scene* ascene, char *filename, FILE *fp = NULL) :
    RT_RS_Area(ascene) { read(filename, fp); }
  RT_RS_InsArea(RT_RS_Scene* ascene = NULL) : RT_RS_Area(ascene) {}
  RT_RS_InsArea(long v0, long v1, long v2, long v3,
                long aright, long aupper, long aleft, long abottom,
                long amesh_nr, RT_RS_Scene* ascene = NULL) :
    RT_RS_Area(v0, v1, v2, v3, aright, aupper, aleft, abottom, amesh_nr, ascene) {}
  //destructor:
  virtual ~RT_RS_InsArea() { set_ar0(); };

  long get_cnt() { return scene->Areas->get_inscnt(); }
  void insert(RT_RS_Area* a) { scene->Areas->insert((RT_RS_InsArea*) a); }
  void insert_ip(int n, long* vtxidx, RT_RS_Vtx*& new_vtx, long& new_vtxidx);
  RT_RS_InsVtx* get_ivtx(long i);
  RT_RS_Vtx* get_vtx(long i) { return get_ivtx(i); }
  RT_RS_Area* get_area(long i);
  RT_RS_Area* new_area(long v0, long v1, long v2, long v3,
            long n0, long n1, long n2, long n3, long amesh_nr,
            RT_RS_Scene* ascene = NULL)
    { RT_RS_InsArea* new_a = new RT_RS_InsArea(v0, v1, v2, v3, n0, n1, n2, n3, amesh_nr, ascene);
      return new_a;
    }
};

#endif 
