#ifndef __OBJECT_H__
#define __OBJECT_H__

////////////////////////////////////////////////////////////////////////////////
//  The class RT_Object. All Tcl accessible  YART classes are inherited from  //
//  this class.                                                               //  
//  LAST EDIT: Mon Aug  8 10:35:49 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "global.h"
#include "error.h"
#include "strings.h"
#include "utils.h"
#include "rlist.h"
#include "glist.h"
#include "macros.h"

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <assert.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

extern const char *RTN_OBJECT;

class RT_Object: public RT_GeneralListEntry {
    static RT_String res;
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int classG, nameG, descG, kwdG; 
    static int isF; static char *printV; static char *isV;
    static int printF; static int deleteF;
  protected:
    char *name;
    // you shouldn't use the name directly
    // only when you absolutely need it
    RT_Object( char *);
    RT_GeneralList relObjects;
    // list of objects that are related with this object
  public:
    virtual void objectKilled(RT_Object *a) { relObjects.remove( a ); }
    // this will be called when a related object is deleted

    virtual ~RT_Object();

    //#### Tcl/C++ methods:
    virtual const char *get_class() const { return "<NoClass>"; }
    // This method was abstract before (=0). It was changed because a
    // compiler bug in g++ 2.5.*

    int isA(const char *_c) const { return RTM_isA( _c, RTN_OBJECT ); }
    // returns 1 if the requested classname is identical with the name of the object
    // subclasses wil recursively call its superclasses

    const char *get_name() const { return name ? name : "<noname>"; }

    virtual const char *get_description() const { return "<This object hasn't a description!>"; }
    // This method was abstract before (=0). It was changed because a
    // compiler bug in g++ 2.5.*
 
    virtual const char *get_keywords() const { return ""; }

    virtual void print(FILE *f) const { printCon( f ); fprintf( f, "\n"); }
    virtual void printCon(FILE *f) const { fprintf( f, "%s %s ", get_class(), get_name() ); }

    //#### static public stuff:
    static RT_Object *getObject( const char *);
    static void result(const char *r) {
	if (strcmp( (char*)res, "" )) res += ' ';
	res += r; 
    }
    static void resResult() { res = ""; }
    static char *getResult() { return (char*)res; }

    //#### the Tcl commands:
    static int generalCMD(ClientData, Tcl_Interp *, int, char *[]);
    virtual int objectCMD(char *[]) = 0;
    // return 1 if at least one argument was set
    static int _classCMD(ClientData, Tcl_Interp *, int, char *[]);

    // generic object dependency mechanism:
    void addRelatedObject(RT_Object *a) { 
	relObjects.remove( a ); 
	relObjects.append( a ); 
    }
    void removeRelatedObject(RT_Object *a) { 
	relObjects.remove( a ); 
    }
};

#endif

