////////////////////////////////////////////////////////////////////////////////
//  Definition of a Vertex Manipulator                                        //  
//  LAST EDIT: Tue Mar  7 18:07:26 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef __VPICK_H__
#define __VPICK_H__

#include "rlist.h"
#include "../high/analytic.h"
#include "mdevice.h"

#ifndef DBL_MAX
#define DBL_MAX              1.7976931348623157e+308
#endif

class RT_VertexCursor: public RT_Quader {
  protected:
    RT_VertexCursor(): RT_Quader(NULL, 0.1, 0.1, 0.1) { box(RTE_NO_BOX); }
  public:
    void color(const RT_Color &c) { ambient(c); diffuse(c); }
};

extern const char *RTN_VERTEX_ENTRY;

class RT_VertexEntry: public RT_VertexCursor {
    int index; // the vertex index
    int xchanged; // 1 if moved
    void get(const RT_Primitive *);
    void put(RT_Primitive *);
  public:
    const char *get_class() const { return RTN_VERTEX_ENTRY; }
    int isA(const char *_c) const { return RT_VertexCursor::isA(_c)
					|| RTM_isA(_c, RTN_VERTEX_ENTRY);}
    RT_VertexEntry(const RT_Primitive *p, int i) {setIdx(p,i);}
    ~RT_VertexEntry() { }
    void changed() { xchanged = 1; }
    // this method should called if the entry was moved
    void setIdx(const RT_Primitive *, int);  // sets the index
    int getIdx() const {return index;}
    void sync(RT_Primitive *p) {if (xchanged) put(p); else get(p);}
    // synchronize the entry with his vertex
    RT_Primitive* get_Primitive();
};

extern const char *RTN_VERTEX_COLLECTION;

class RT_VertexCollection: public RT_Primitive {
    RT_Primitive *prim;
  public:
    const char *get_class() const { return RTN_VERTEX_COLLECTION; }
    int isA(const char *_c) const { return RT_Primitive::isA(_c)
					|| RTM_isA(_c, RTN_VERTEX_COLLECTION);}
    RT_VertexCollection(RT_Primitive *, int idx);
    void objectKilled(RT_Object *o) {
	if (prim == o) prim = 0;
	RT_Primitive::objectKilled(o);
	if (!prim) delete this;
    }
    RT_Primitive *get_Primitive() const {return prim;}
    void addVertexEntry(int );
    void removeVertexEntry(int );
    void invertCollection();
    // all existing vertex entries will delete
    // all other verticies get vertex entry
    int isVertexInList(int ) const ;
    // true, if a vertex entry exists for this index
    void sync();
    // synchronize all vertex entries
    RT_VertexEntry *getEntry(int ) const;
    int vertexEntryLeft() const {return parts.getNumber() != 0;}
    void doFixedCoordTrans(const RT_Vector &);
    // insert and delete vertices of polyvertices
    void insertVertex(int) const;
    void deleteVertex(int) const;
};

extern const char *RTN_PRIMITIVE_VERTEX_ASSOCIATION;

class RT_PrimitiveVertexAssociation: public RT_Primitive {
  public:
    const char *get_class() const { return RTN_PRIMITIVE_VERTEX_ASSOCIATION; }
    int isA(const char *_c) const { return RT_Primitive::isA(_c) || RTM_isA(_c, RTN_PRIMITIVE_VERTEX_ASSOCIATION);}
    RT_PrimitiveVertexAssociation();
    ~RT_PrimitiveVertexAssociation() {}
    int isPrimitiveInList(const RT_Primitive *) const ;
    void addVertexEntry(RT_Primitive *, int );
    void addAllVertexEntrys(RT_Primitive *);
    void removeVertexEntry(RT_Primitive *, int);
    void removeAllVertexEntrys(RT_Primitive *);
    void invertVertexCollection(RT_Primitive *);
    void insertVertex(RT_Primitive *, int);
    void deleteVertex(RT_Primitive *, int);
    void sync(RT_Primitive * = 0);
    void checkScene(const RT_Scene *);
    RT_VertexEntry *getEntry(const RT_Primitive *, int ) const;
    void doFixedCoordTrans(RT_Primitive *,const RT_Vector &);
};

extern const char *RTN_VERTEX_MANIPULATOR;

class RT_VertexManipulator: public RT_Manipulator {
    static RT_ParseEntry table[];
    static int insertF, deleteF;

    static int pickF;
    static char *pickS;
    static int addVCBF, remVCBF;
    static char *addVCBS,*remVCBS;
    static int coordF, coordGF;
    static int wcoordGF;
    static RT_Vector coordV;
    static RT_Matrix wcoordGM;
    static int chkscF, lockF, unlockF, lockGF, idxGF;
    static int surfGF, surfF;
    static char *surfS;

    RT_PrimitiveVertexAssociation *pva;
    RT_VertexEntry *vc;
    RT_Camera *last_camera;
    RT_Scene *last_scene;

    double oldx,oldy;

    RT_GeneralList cbList;

    int xlock; // lock the current object

    static int pickVertex(const RT_Primitive *, const RT_Ray &);

  public:
    const char *get_class() const { return RTN_VERTEX_MANIPULATOR; }
    int isA(const char *c) const { return RT_Manipulator::isA( c ) || RTM_isA( RTN_VERTEX_MANIPULATOR, c ); }
    const char *get_description() const { return "A vertex manipulator object can be used as a normal manipulator, but you can pick and transform the vertices of the current object. The magic keys are: <ctrl> to move the selected vertex and <ctrl+alt> to move all picked verticies of the current object (with right button)."; }
    RT_VertexManipulator(char *_name) : RT_Manipulator(_name) {
	pva = new RT_PrimitiveVertexAssociation();
	last_scene = 0;
	last_camera = 0;
	vc = 0;
	oldx = oldy = 0;
	unlock();
    }
    ~RT_VertexManipulator() {
	if ( last_camera ) {
	    last_camera->removeRelatedObject(this);
	    last_camera->feedback->remove( pva );
	    last_camera->refresh();
	}
	if ( last_scene )
	    last_scene->removeRelatedObject(this);
	delete pva;
    }
    virtual void event(RT_Event *);
    virtual void updateFeedback();
    void select(RT_VertexEntry *);
    void deselect(int =0);
    virtual void currentObject(RT_Primitive *p) {
	if (!xlock) {
	    if (get_currentObject() != p) deselect();
	    RT_Manipulator::currentObject(p);
	}
    }
    static int classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]);
    int objectCMD(char *[]);
    void objectKilled(RT_Object *o);

    void callVertexCBs();
    // call all callbacks in the callback list
    void addVertexCB( RT_Callback *fun) { 
	cbList.append( fun); fun->setList( &cbList ); 
    }
    // add a C++ callback to the list
    void removeVertexCB( RT_Callback *fun) { cbList.remove( fun ); }
    // remove a C++ callback from list
    int addVertexTclCB(char*);
    // add a tcl callback to the list
    // returns TRUE if successful else FALSE
    // (if there is already a cb with this name)

    int removeVertexTclCB(char *);
    // remove a tcl callback 
    // returns TRUE if successful else FALSE
    // (if there is not a cb with this name)

    // pick 0 NONE, 1 ALL, 2 ALL OTHER verticies of the current object
    void pick(int );

    void lock() { xlock=1; }
    void unlock() { xlock=0; }
    int get_lock() { return xlock != 0; }

    void checkScene() { if (last_scene) pva->checkScene(last_scene); }

    int get_currentIndex() { return (vc) ? vc->getIdx() : -1; }

    void VertexCoords(const RT_Vector&);
    // set the coords of the current vertex
    RT_Vector get_VertexCoords(RT_Vector* =0);
    // get the coords of the current vertex

    RT_Surface get_VertexSurface();
    // set the surface of the current vertex
    void VertexSurface(const RT_Surface& );
    // get the surface of the current vertex
};

#endif
