#ifndef __LOCATOR_H__
#define __LOCATOR_H__

////////////////////////////////////////////////////////////////////////////////
//  A sample implementation of a locator device.                              //  
//  LAST EDIT: Fri Aug  5 09:23:07 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "device.h"

class RT_Pixmap;
// forward declaration of pixmap

extern const char *RTN_LOCATOR;

class RT_Locator: public RT_InputDevice {
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int locG;
    RT_Primitive *fdb;
    RT_Primitive *fdb2;
    // the feedback of interaction
    RT_Vector xlocation;
    double oldx,oldy;
  public:
    void event(RT_Event*);

    void on();
    void off();

    //#### Tcl/C++ methods:
    RT_Locator(char *); 
    virtual ~RT_Locator();  

    const char *get_description() const { return "A locator providing world coordinates."; }
    const char *get_class() const { return RTN_LOCATOR; }
    int isA(const char *c) const { return RT_InputDevice::isA( c ) || RTM_isA( RTN_LOCATOR, c ); }

    void father(RT_Object*);
    RT_Vector get_location() { return xlocation; }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
    int objectCMD(char *[]);
};

#endif



