////////////////////////////////////////////////////////////////////////////////
//  Implementation of locator input device.                                   //  
//  LAST EDIT: Thu Nov 10 13:05:45 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "locator.h"
#include "../camera.h"
#include "../high/usefprim.h"
#include "../high/text.h"

const char *RTN_LOCATOR = "Locator";

int RT_Locator::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a {ARG 1 Locator} object.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	if (argc != 2) {
	    Tcl_AppendResult( ip, argv[0], ": Need one argument.", 0 );
	    return TCL_ERROR;
	}
	new RT_Locator( argv[1] ); 
	RTM_classReturn;
    }
    return res; 
}

int RT_Locator::locG;

RT_ParseEntry RT_Locator::table[] = {
    {"-get_location", RTP_NONE, 0, &locG, "Return the last location.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
}; 

int RT_Locator::objectCMD(char *argv[]) { 
    int ret = RT_InputDevice::objectCMD( argv );
    RT_parseTable( argv, table );
    if (locG) {
	static char tmp[60];
	RT_vector2string( get_location(), tmp );
	RT_Object::result( tmp );
	ret++;
    }
    return ret;
}

void RT_Locator::event(RT_Event *ev) {
    if ( ev && ev->isA( RTN_MOTION_EVENT )) {
	RT_MotionEvent &mev = *(RT_MotionEvent*)ev;
	double x = mev.x/((double)mev.w);
	double y = mev.y/((double)mev.h);
	double dx = x - oldx;
	double dy = y - oldy;
	oldx = x;
	oldy = y;

	if ( mev.right || mev.middle ) {
	    if ( mev.shift ) {
		fdb->translate( RT_Vector( 0, 0, -dy ) );
		fdb2->translate( RT_Vector( 0, 0, -dy ) );
	    }
	    else {
		fdb->translate( RT_Vector( dx, dy, 0 )) ;
		fdb2->translate( RT_Vector( dx, dy, 0 ) );
	    }
	    xlocation = fdb->get_matrix() * RT_Vector( 0, 0, 0 );
	    xtime = ev->getTime();

	    static char tmp[40];
	    sprintf( tmp, "%.1lf %.1lf %.1lf", 
		    xlocation.x, xlocation.y, xlocation.z );
	    ((RT_Text*)fdb2)->text( tmp );

	    if (get_camera()) get_camera()->refresh();
	    callCBs();
	}
    }
}

RT_Locator::RT_Locator(char *_name): RT_InputDevice(_name) { 
    fdb = new RT_Axes( 0 );
    fdb->diffuse( RT_Color( 1,1,1));
    fdb->update( 1 );
    fdb2 = new RT_Text( 0, "0.0 0.0 0.0", RT_Vector( 0, -1, 0 ));
    fdb2->diffuse( RT_Color( 1,1,1));
    fdb2->update( 1 );
    oldx = oldy = 0;
} 

RT_Locator::~RT_Locator() {
    if (get_camera()) {
	get_camera()->feedback->remove( fdb );
	get_camera()->feedback->remove( fdb2 );
	get_camera()->refresh();
    }
    delete fdb; 
    delete fdb2; 
}

void RT_Locator::father(RT_Object *f) {
    if (get_camera()) {
	get_camera()->feedback->remove( fdb );
	get_camera()->feedback->remove( fdb2 );
	get_camera()->refresh();
    }
    RT_InputDevice::father( f );
    if (get_camera()) {
	get_camera()->feedback->insert( fdb );
	get_camera()->feedback->insert( fdb2 );
	get_camera()->refresh();
    }
}

void RT_Locator::on() {
    RT_InputDevice::on();
    fdb->diffuse( RT_Color( 1, 1, 1 ));
    fdb2->diffuse( RT_Color( 1, 1, 1 ));
    if (get_camera()) get_camera()->refresh();
}

void RT_Locator::off() {
    RT_InputDevice::off();
    fdb->diffuse( RT_Color( 0.2, 0.2, 0.2 ));
    fdb2->diffuse( RT_Color( 0.2, 0.2, 0.2 ));
    if (get_camera()) get_camera()->refresh();
}
