////////////////////////////////////////////////////////////////////////////////
//  Event loop implementation.                                                //  
//  LAST EDIT: Fri Aug  5 09:23:14 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "input.h"
#include "device.h"
#include "../pixmap.h"

RT_InputServer *rt_InputServer;

void RT_InputServer::event(RT_Event *ev) {
    class LFunctoid: public RT_GeneralListFunctoid {
	void exec(RT_GeneralListEntry *e, void *ev ) {

	    if ( e->isA( RTN_PIXMAP )) ((RT_Pixmap*)e)->event();
	    // a pixmap doesnt get an external event
	    
	    if ( e->isA( RTN_INPUT_DEVICE )) {
		RT_InputDevice *dv = (RT_InputDevice*)e;
		if ( dv->get_on() ) dv->event( (RT_Event*)ev);
	    }
	}
    } func;
    doWithElements( &func, ev );
}

