////////////////////////////////////////////////////////////////////////////////
//  Implementations of events.                                                //  
//  LAST EDIT: Fri Aug  5 09:23:15 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "event.h"

const char *RTN_EVENT = "Event";
const char *RTN_BUTTON_EVENT = "ButtonEvent";
const char *RTN_MOTION_EVENT = "MotionEvent";
const char *RTN_SPACEBALL_EVENT = "SpaceballEvent";
const char *RTN_UPDATE_EVENT = "UpdateEvent";

const char *RT_Event::getValue() const {
    static RT_String data(100);
    data = getClass();
    char tmp[10];
    sprintf( tmp, " %d", time ); data += tmp;
    return data.getValue();
}

const char *RT_ButtonEvent::getValue() const {
    static RT_String data(100);
    data = RT_Event::getValue();
    char tmp[10];
    sprintf( tmp, " %d",left ); data += tmp;
    sprintf( tmp, " %d",middle ); data += tmp;
    sprintf( tmp, " %d",right ); data += tmp;
    sprintf( tmp, " %d",shift ); data += tmp;
    sprintf( tmp, " %d",ctrl ); data += tmp;
    sprintf( tmp, " %d",alt ); data += tmp;
    sprintf( tmp, " %d",x ); data += tmp;
    sprintf( tmp, " %d",y ); data += tmp;
    sprintf( tmp, " %d",w ); data += tmp;
    sprintf( tmp, " %d",h ); data += tmp;
    return data.getValue();
}

const char *RT_MotionEvent::getValue() const {
    static RT_String data(100);
    data = RT_Event::getValue();
    char tmp[10];
    sprintf( tmp, " %d",left ); data += tmp;
    sprintf( tmp, " %d",middle ); data += tmp;
    sprintf( tmp, " %d",right ); data += tmp;
    sprintf( tmp, " %d",shift ); data += tmp;
    sprintf( tmp, " %d",ctrl ); data += tmp;
    sprintf( tmp, " %d",alt ); data += tmp;
    sprintf( tmp, " %d",x ); data += tmp;
    sprintf( tmp, " %d",y ); data += tmp;
    sprintf( tmp, " %d",w ); data += tmp;
    sprintf( tmp, " %d",h ); data += tmp;
    return data.getValue();
}

const char *RT_SpaceballEvent::getValue() const {
    static RT_String data(300);
    data = RT_Event::getValue();
    char tmp[10];
    sprintf( tmp, "%d ",transX ); data += tmp;
    sprintf( tmp, "%d ",transY ); data += tmp;
    sprintf( tmp, "%d",transZ ); data += tmp;
    sprintf( tmp, "%d ",twistX ); data += tmp;
    sprintf( tmp, "%d ",twistY ); data += tmp;
    sprintf( tmp, "%d",twistZ ); data += tmp;
    sprintf( tmp, "%d ",b1 ); data += tmp;
    sprintf( tmp, "%d ",b2 ); data += tmp;
    sprintf( tmp, "%d ",b3 ); data += tmp;
    sprintf( tmp, "%d ",b4 ); data += tmp;
    sprintf( tmp, "%d ",b5 ); data += tmp;
    sprintf( tmp, "%d ",b6 ); data += tmp;
    sprintf( tmp, "%d ",b7 ); data += tmp;
    sprintf( tmp, "%d",b8 ); data += tmp;
    sprintf( tmp, "%d ",pick ); data += tmp;
    sprintf( tmp, "%d ",period ); data += tmp;
    return data.getValue();
}

const char *RT_UpdateEvent::getValue() const {
    RT_String data(100);
    data += RT_Event::getValue();
    char tmp[50];
    sprintf( tmp, "%d %d %d %d %d", partial, x0, y0, x1, y1 ); data += tmp;
    return data.getValue();
}

