#ifndef __USEFUL_TEXTURES_H__
#define __USEFUL_TEXTURES_H__

//////////////////////////////////////////////////////////////////////////////// 
// All the  following textures are taken from GRIS UNI Tuebingen (Armin Krauss//
//, Alwin Groene) - used with friendly permission                             //    
// LAST EDIT: Tue Aug 16 16:10:09 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "texture.h"

void rt_initTextureCommands( Tcl_Interp* );

extern const char *RTN_POLY_BLOB_TEXTURE;

class RT_PolyBlobTexture: public RT_Texture3D {
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the public methods:   
    RT_PolyBlobTexture(char *_name = 0) : RT_Texture3D( _name ) {}
    const char *get_class() const { return RTN_POLY_BLOB_TEXTURE; }
    const char *get_description() const { return "This texture simulates poly blobs."; }
    int isA(const char *c) const { return RT_Texture3D::isA( c ) || RTM_isA( c, RTN_POLY_BLOB_TEXTURE ); }

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

extern const char *RTN_NOISE_TEXTURE;

class RT_NoiseTexture: public RT_Texture3D {
    RT_Color col;
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int colF, colG;
    static RT_Color colV;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_NoiseTexture(char *_name, const RT_Color &_col): RT_Texture3D( _name ) { col = _col; }
    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); col.print( f ); }
    const char *get_class() const { return RTN_NOISE_TEXTURE; }
    const char *get_description() const { return "This texture simulates noise. The color of the noise can be changed."; }
    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_NOISE_TEXTURE ); }

    void color( const RT_Color &_col) { col = _col; }
    const RT_Color &get_color() const { return col; }

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_UNI_COLOR_TEXTURE;

class RT_UniColorTexture: public RT_Texture3D {
    RT_Color col;
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int colF, colG;
    static RT_Color colV;
  public:
    RT_Color getSample( const RT_Vector &) const { RT_Color c; c = col; return c; }

    //##### the Tcl/C++ methods:   
    RT_UniColorTexture(char *_name, const RT_Color &_col): RT_Texture3D( _name ) { col = _col; }
    const char *get_class() const { return RTN_UNI_COLOR_TEXTURE; }
    const char *get_description() const { return "The texture consists homogeneously of only one color. Objects of this class can be used in other textures."; }
    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_UNI_COLOR_TEXTURE ); }
    void color( const RT_Color &_col) { col = _col; }
    const RT_Color &get_color() const { return col; }
    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); col.print( f ); }
    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_WOOD_TEXTURE;

class RT_WoodTexture: public RT_Texture3D {
    RT_Texture3D *tex0, *tex1;
    int xlight;
  public:
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int brF, brV, brG;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_WoodTexture(char *_name, RT_Texture3D *t0, RT_Texture3D *t1): RT_Texture3D( _name ) { 
	xlight = 0; tex0 = t0; tex1 = t1; tex0->ref(); tex1->ref();
    }
    virtual ~RT_WoodTexture() { tex0->deref(); tex1->deref(); }

    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); fprintf( f, "%s %s ", tex0->get_name(), tex1->get_name() ); }
    void print(FILE *f) const {
	RT_Texture3D::print( f );
	fprintf( f, "%s -bright %i\n", get_name(), get_bright() ); 
    }
    const char *get_class() const { return RTN_WOOD_TEXTURE; }
    const char *get_description() const { return "This texture simulates wood consisting of a bright and a dark surface."; }
    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_WOOD_TEXTURE ); }

    void bright( const int i) { xlight = i; }
    int get_bright() const { return xlight; }
    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_CHECKER_TEXTURE;

class RT_CheckerTexture: public RT_Texture3D {
    RT_Texture3D *tex0, *tex1;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_CheckerTexture(char *_name, RT_Texture3D *t0, RT_Texture3D *t1): RT_Texture3D( _name ) { 
	tex0 = t0; tex1 = t1; tex0->ref(); tex1->ref();
    }
    virtual ~RT_CheckerTexture() { tex0->deref(); tex1->deref(); }

    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); fprintf( f, "%s %s ", tex0->get_name(), tex1->get_name() ); }

    const char *get_class() const { return RTN_CHECKER_TEXTURE; }
    const char *get_description() const { return "Objects of this class create a chessboard-like 3D texture consisting of two other textures."; }
    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_CHECKER_TEXTURE ); }

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

extern const char *RTN_GRID_TEXTURE;

class RT_GridTexture: public RT_Texture3D {
    RT_Texture3D *tex0, *tex1;
    double xwidth;
  public:
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int wiF, wiG; static double wiV;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_GridTexture(char *_name, RT_Texture3D *t0, RT_Texture3D *t1): RT_Texture3D( _name ) { 
	xwidth = 0.1; tex0 = t0; tex1 = t1; tex0->ref(); tex1->ref();
    }
    virtual ~RT_GridTexture() { tex0->deref(); tex1->deref(); }

    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); fprintf( f, "%s %s ", tex0->get_name(), tex1->get_name() ); }
    void print(FILE *f) const {
	RT_Texture3D::print( f );
	fprintf( f, "%s -width %lf\n", get_name(), get_width() ); 
    }

    const char *get_class() const { return RTN_GRID_TEXTURE; }
    const char *get_description() const { return "This texture generates a grid consisting of two further textures."; }
    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_GRID_TEXTURE ); }

    void width( const double d) { 
	xwidth = d; if (xwidth < 0) xwidth = 0; 
	if (xwidth > 1) xwidth = 1; 
    }
    double get_width() const { return xwidth; }

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_TURBULENCE_TEXTURE;

class RT_TurbulenceTexture: public RT_Texture3D {
    RT_Texture3D *tex0, *tex1;
    int xiter;
    double xlevel;
  public:
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int itF, itV, itG, lvF, lvG; static double lvV;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_TurbulenceTexture(char *_name, RT_Texture3D *t0, RT_Texture3D *t1): RT_Texture3D( _name ) { 
	xiter = 10; xlevel = 0.5; tex0 = t0; tex1 = t1; 
	tex0->ref(); tex1->ref();
    }
    virtual ~RT_TurbulenceTexture() { tex0->deref(); tex1->deref(); }

    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); fprintf( f, "%s %s ", tex0->get_name(), tex1->get_name() ); }
    void print(FILE *f) const {
	RT_Texture3D::print( f );
	fprintf( f, "%s -iter %i -level %lf\n", get_name(), get_iter(), get_level() ); 
    }

    const char *get_class() const { return RTN_TURBULENCE_TEXTURE; }
    const char *get_description() const { return "This texture generates a turbulence from two further surfaces."; }
    int isA(const char *c) const { return RT_Texture3D::isA( c ) || RTM_isA( c, RTN_TURBULENCE_TEXTURE ); }

    void iter(const int i) { xiter = i; if (xiter < 0) xiter = 0;}
    int get_iter() const { return xiter; }

    void level(const double d) { xlevel = d; }
    double get_level() const { return xlevel; }

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_INTERPOLATION_TEXTURE;

class RT_InterpolationTexture: public RT_Texture3D {
    RT_Texture3D *tex0, *tex1;
    int xsteps;
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int stF, stV, stG;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_InterpolationTexture(char *_name, RT_Texture3D *t0, RT_Texture3D *t1): RT_Texture3D( _name ) { 
	xsteps = 2; tex0 = t0; tex1 = t1; tex0->ref(); tex1->ref(); 
    }
    virtual ~RT_InterpolationTexture() { tex0->deref(); tex1->deref(); }

    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); fprintf( f, "%s %s ", tex0->get_name(), tex1->get_name() ); }
    void print(FILE *f) const {
	RT_Texture3D::print( f );
	fprintf( f, "%s -steps %i\n", get_name(), get_steps() ); 
    }

    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_INTERPOLATION_TEXTURE ); }
    const char *get_class() const { return RTN_INTERPOLATION_TEXTURE; }
    const char *get_description() const { return "This texture interpolates two further surfaces in a variable number of steps."; }

    void steps(const int i) { xsteps = i; if (xsteps < 0) xsteps = 0;}
    int get_steps() const { return xsteps; }

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_TRUNC_TEXTURE;

class RT_TruncTexture: public RT_Texture3D {
    RT_Texture3D *tex;
    int xsteps;
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int stF, stV, stG;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_TruncTexture(char *_name, RT_Texture3D *_tex) : RT_Texture3D( _name ) {
	tex = _tex; xsteps = 2; tex->ref();
    }
    virtual ~RT_TruncTexture() { tex->deref(); }

    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); fprintf( f, "%s ", tex->get_name() ); }
    void print(FILE *f) const {
	RT_Texture3D::print( f );
	fprintf( f, "%s -steps %i\n", get_name(), get_steps() ); 
    }

    const char *get_class() const { return RTN_TRUNC_TEXTURE; }
    const char *get_description() const { return "This texture truncs an another continuous texture."; }

    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_TRUNC_TEXTURE ); }

    void steps(const int i) { xsteps = i; if (xsteps < 0) xsteps = 0;}
    int get_steps() const { return xsteps; }

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_MARBLE_TEXTURE;

class RT_MarbleTexture: public RT_Texture3D {
    RT_Texture3D *tex0, *tex1;
    double w[4];
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int wiG, wiF;
    static char *wiV;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_MarbleTexture(char *_name, RT_Texture3D *_tex0,  RT_Texture3D *_tex1) : RT_Texture3D( _name ) {
	tex0 = _tex0; tex1 = _tex1; tex0->ref(); tex1->ref();
	w[0] = 5; w[1] = 10; w[2] = 15; w[3] = 20;
    }
    virtual ~RT_MarbleTexture() { tex0->deref(); tex1->deref(); }

    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); fprintf( f, "%s %s ", tex0->get_name(), tex1->get_name() ); }
    void print(FILE *f) const {
	RT_Texture3D::print( f );
	fprintf( f, "%s -widths {%lf %lf %lf %lf}\n", get_name(), w[0], w[1], w[2], w[3] ); 
    }

    const char *get_class() const { return RTN_MARBLE_TEXTURE; }
    const char *get_description() const { return "This texture simulates marple by linear interpolating between two other textures."; }
    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_MARBLE_TEXTURE ); }

    void widths(const double _w[4]) { w[0] = _w[0]; w[1] = _w[1]; w[2] = _w[2]; w[3] = _w[3];}
    double *get_widths() const { return (double*)w; };

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_X_LINEAR_MARBLE_TEXTURE;

class RT_XLinearMarbleTexture: public RT_Texture3D {
    RT_Texture3D *tex0, *tex1, *tex2, *tex3;
    double w[7];
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int wiG, wiF;
    static char *wiV;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_XLinearMarbleTexture(char *_name, RT_Texture3D *_tex0,  RT_Texture3D *_tex1, RT_Texture3D *_tex2,  RT_Texture3D *_tex3 ) : RT_Texture3D( _name ) {
	tex0 = _tex0; tex1 = _tex1; tex2 = _tex2; tex3 = _tex3;
	tex0->ref(); tex1->ref(); tex2->ref(); tex3->ref();
	w[0] = 5; w[1] = 10; w[2] = 15; w[3] = 20; w[4] = 25; w[5] = 30; w[6] = 35; 
    }
    virtual ~RT_XLinearMarbleTexture() { 
	tex0->deref(); tex1->deref(); tex2->deref(); tex3->deref(); 
    }

    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); fprintf( f, "%s %s %s %s ", tex0->get_name(), tex1->get_name(), tex2->get_name(), tex3->get_name() ); }
    void print(FILE *f) const {
	RT_Texture3D::print( f );
	fprintf( f, "%s -widths {%lf %lf %lf %lf %lf %lf %lf}\n", get_name(), w[0], w[1], w[2], w[3], w[4], w[5], w[6] ); 
    }
    const char *get_class() const { return RTN_X_LINEAR_MARBLE_TEXTURE; }
    const char *get_description() const { return "This texture simulates marple by linear interpolating between four other textures."; }
    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_X_LINEAR_MARBLE_TEXTURE ); }

    void widths(const double _w[7]) { for (int i = 0; i < 7; i++) w[i] = _w[i]; }
    double *get_widths() const { return (double*)w; };

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_X_CUBIC_MARBLE_TEXTURE;

class RT_XCubicMarbleTexture: public RT_Texture3D {
    RT_Texture3D *tex0, *tex1, *tex2, *tex3;
    double w[5];
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int wiG, wiF;
    static char *wiV;
  public:
    RT_Color getSample( const RT_Vector &) const;

    //##### the Tcl/C++ methods:   
    RT_XCubicMarbleTexture(char *_name, RT_Texture3D *_tex0,  RT_Texture3D *_tex1, RT_Texture3D *_tex2,  RT_Texture3D *_tex3 ) : RT_Texture3D( _name ) {
	tex0 = _tex0; tex1 = _tex1; tex2 = _tex2; tex3 = _tex3;
	tex0->ref(); tex1->ref(); tex2->ref(); tex3->ref();
	w[0] = 5; w[1] = 10; w[2] = 15; w[3] = 20; w[4] = 25;
    }
    virtual ~RT_XCubicMarbleTexture() { 
	tex0->deref(); tex1->deref(); tex2->deref(); tex3->deref(); 
    }

    void printCon(FILE *f) const { RT_Texture3D::printCon( f ); fprintf( f, "%s %s %s %s ", tex0->get_name(), tex1->get_name(), tex2->get_name(), tex3->get_name() ); }
    void print(FILE *f) const {
	RT_Texture3D::print( f );
	fprintf( f, "%s -widths {%lf %lf %lf %lf %lf}\n", get_name(), w[0], w[1], w[2], w[3], w[4] ); 
    }

    const char *get_class() const { return RTN_X_CUBIC_MARBLE_TEXTURE; }
    const char *get_description() const { return "This texture simulates marple by cubic interpolating between four other textures."; }
    int isA(const char *c) const { return  RT_Texture3D::isA( c ) || RTM_isA( c, RTN_X_CUBIC_MARBLE_TEXTURE ); }

    void widths(const double _w[5]) { for (int i = 0; i < 5; i++) w[i] = _w[i]; }
    double *get_widths() const { return (double*)w; };

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_LATTICE_TEXTURE;

class RT_LatticeTexture: public RT_Texture3D {
  public:
    RT_Vector getNormal( const RT_Vector & ) const;

    //##### the public methods:   
    RT_LatticeTexture(char *_name = 0) : RT_Texture3D( _name ) { 
	smode = RTE_NO_SAMPLE;
	nmode = RTE_REPLACE_NORMAL; 
    }
    const char *get_class() const { return RTN_LATTICE_TEXTURE; }
    const char *get_description() const { return "This demo texture creates a bump mapping in the x-y plane. The space between the grid is 1, but can be changed via the texture matrix. This texture is very useful for planar primitives, e.g. a quader or a plane. Surface components will not be changed directly."; }
    int isA(const char *c) const { return RT_Texture3D::isA( c ) || RTM_isA( c, RTN_LATTICE_TEXTURE ); }

    //##### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

#endif
