////////////////////////////////////////////////////////////////////////////////
//  Implementations of hi-level primitives.                                   //  
//  LAST EDIT: Fri Aug  5 08:55:00 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "usefprim.h"

const char *RTN_AXES = "Axes";

int RT_Axes::fl = 0;
RT_Vector RT_Axes::pts[15];

int RT_Axes::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{ ", argv[0], " { String } {Creates a new axes cross called {ARG 1 Name}.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	new RT_Axes( argv[1] ); 
	RTM_classReturn;
    }
    return res; 
}

const char *RTN_TOP = "Top";

int RT_Top::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " {String} {Creates a new top object called {ARG 1 Name}.}}", 0 );
	return TCL_OK;
    }
    if ( res  == TCL_OK ) {  
	new RT_Top( argv[1] ); 
	RTM_classReturn;
    }
    return res; 
}



