#ifndef __USEFUL_IMAGES_H__
#define __USEFUL_IMAGES_H__

////////////////////////////////////////////////////////////////////////////////
//  Some concrete image classes.                                              //  
//  LAST EDIT: Fri Aug  5 08:54:57 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "image.h"

extern const char *RTN_SGI_IMAGE;

#define RT_SGI_IMAGIC 	                0732
#define RT_SGI_TYPEMASK	         	0xff00
#define RT_SGI_BPPMASK			0x00ff
#define RT_SGI_ITYPE_VERBATIM		0x0000
#define RT_SGI_ITYPE_RLE		0x0100
#define RT_SGI_ISRLE(type)		(((type) & 0xff00) == RT_SGI_ITYPE_RLE)
#define RT_SGI_ISVERBATIM(type)	(((type) & 0xff00) == RT_SGI_ITYPE_VERBATIM)
#define RT_SGI_BPP(type)		((type) & RT_SGI_BPPMASK)
#define RT_SGI_RLE(bpp)		(RT_SGI_ITYPE_RLE | (bpp))
#define RT_SGI_VERBATIM(bpp)		(RT_SGI_ITYPE_VERBATIM | (bpp))

#define RT_SGI_RINTLUM (79)
#define RT_SGI_GINTLUM (156)
#define RT_SGI_BINTLUM (21)

#define RT_SGI_ILUM(r,g,b)     ((int)(RT_SGI_RINTLUM*(r)+RT_SGI_GINTLUM*(g)+RT_SGI_BINTLUM*(b))>>8)

#define RT_SGI_OFFSET_R	3	// this is byte order dependent 
#define RT_SGI_OFFSET_G	2
#define RT_SGI_OFFSET_B	1
#define RT_SGI_OFFSET_A	0
#define RT_SGI_CHANOFFSET(z)	(3-(z))	// this is byte order dependent 
#define RT_SGI_TAGLEN	(5)

typedef struct {
    unsigned short	imagic;		// stuff saved on disk . . 
    unsigned short 	type;
    unsigned short 	dim;
    unsigned short 	xsize;
    unsigned short 	ysize;
    unsigned short 	zsize;
    unsigned long 	min;
    unsigned long 	max;
    unsigned long	wastebytes;	
    char 		name[80];
    unsigned long	colormap;
    
    long 		file;		// stuff used in core only 
    unsigned short 	flags;
    short		dorev;
    short		x;
    short		y;
    short		z;
    short		cnt;
    unsigned short	*ptr;
    unsigned short	*base;
    unsigned short	*tmpbuf;
    unsigned long	offset;
    unsigned long	rleend;		// for rle images 
    unsigned long	*rowstart;	// for rle images 
    long		*rowsize;	// for rle images 
} RT_SGIImageStruct;

class RT_SGIImage:public RT_Image {
    void newGeometry() {
	if (base) delete base;
	base = new unsigned long [xsize*ysize+RT_SGI_TAGLEN];
    }
    int zsize;
    //  zsize specifies what kind of image file to
    // write out.  if zsize is 1, the luminance of the pixels are
    // calculated, and a sinlge channel black and white image is saved.
    // If zsize is 3, an RGB image file is saved.  If zsize is 4, an
    // RGBA image file is saved.
    int sizeOfImage();
    // get x,y of the image file, returns 1 if succesful
    // some utility statics:
    static void interleaveRow(unsigned char *lptr,unsigned char *cptr,int z,int n) {
	lptr += z;
	while(n--) {
	    *lptr = *cptr++;
	    lptr += 4;
	}
    }
    static void lumRow(unsigned char *,unsigned char *,int n);
    static int compressRow(unsigned char *,unsigned char *,int,int);
    static void readTab(FILE *,unsigned long *,int);
    static int writeTab(FILE *,unsigned long *,int);
    static void copyBw(long *,int);
    static void setAlpha(unsigned char *,int);
    static void expandRow(unsigned char *,unsigned char *,int);
    // byte order independent read/write of shorts and longs:
    static int putLong(FILE *,unsigned long);
    static void putShort(FILE *, unsigned short);
    static unsigned long getLong( FILE *);
    static unsigned short getShort(FILE *);
    // extract image data from core dumps:
    static void addLongImgTag(unsigned long *, int, int);
  public:
    RT_SGIImageStruct image;
    void readHeader(FILE *);
    int writeHeader(FILE *);

    //#### the Tcl/C++ methods:
    RT_SGIImage(char *NAME, char *FILENAME);

    const char *get_keywords() const { return "SGI RGB"; }
    const char *get_class() const { return RTN_SGI_IMAGE; }
    const char *get_description() const { return "Import/export of SGI RGB files. The code is based on stuff by Paul Haeberli (Silicon Graphics Inc.), used with friendly permission."; }
    int isA(const char *_c) const { return RT_Image::isA( _c ) || RTM_isA(_c, RTN_SGI_IMAGE ); }

    int read(); 
    int write();

    void color(int, int, const RT_Color &);
    RT_Color get_color(int, int) const; 
    const char *get_extension() const { return "rgb"; }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

extern const char *RTN_TARGA_IMAGE;

typedef struct RT_TargaImageHeader {
  unsigned char ident_len, cmap_type, image_type;
  unsigned short int cmap_origin, cmap_len;
  unsigned char centry_size;
  unsigned short int image_xorg, image_yorg, image_width, image_height;
  unsigned char pixel_size, image_discr;
}  RT_TargaImageHeader; 
          
typedef struct {
  unsigned char b, g, r;       // Note b - g - r order.
} RT_TargaRGB;
  
class RT_TargaImage:public RT_Image {
    int lh;             
    void newGeometry() {
	if (base) delete base;
	base = new unsigned long [xsize * ysize];
    }
    int compressRow(RT_TargaRGB *, unsigned char *);
    int sizeOfImage();  // get x,y of the image file, returns 1 if succesful
    // byte order independent read/write of shorts:
    void putShort(FILE *, unsigned short);
    unsigned short getShort(FILE *);

    RT_TargaImageHeader Header;
    void readHeader(FILE *);
    int writeHeader(FILE *);
  public:
    //#### the Tcl/C++ methods:
    RT_TargaImage(char *a, char *b);

    const char *get_keywords() const { return "TGA RGB"; }
    const char *get_class() const { return RTN_TARGA_IMAGE; }
    const char *get_description() const { return "Import/export of Targa RGB files."; }
    int isA(const char *_c) const { return RT_Image::isA( _c ) || RTM_isA(_c, RTN_TARGA_IMAGE ); }

    int read(); 
    int write();

    void color(int, int, const RT_Color &);
    RT_Color get_color(int, int) const; 
    const char *get_extension() const { return "tga"; }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

// ##### class RT_RGBAImage

typedef struct RT_RGBAImageHeader {
    unsigned int imagic, xsize, ysize;
} RT_RGBAImageHeader;

#define RT_RGBA_IMAGIC			0730

extern const char *RTN_RGBA_IMAGE;

class RT_RGBAImage : public RT_Image {
    RT_RGBAImageHeader image;
    static int putLong(int ,unsigned long);
    static int putShort(int, unsigned short);
    static unsigned long getLong( int );
    static unsigned short getShort(int );
    void readHeader( int );
    void writeHeader( int );

    void newGeometry() {}
  public:
    void *getBasePtr() { return base; }

    // ##### the Tcl/C++ methods:
    RT_RGBAImage( char *_name, char *_fname ) :  RT_Image( _name, _fname ) {};

    const char *get_keywords() const { return "RGBA"; }
    const char *get_class() const { return RTN_RGBA_IMAGE; }
    const char *get_description() const { return "Import/export of RGBA files."; }
    int isA(const char *_c) const { return RT_Image::isA( _c ) || RTM_isA(_c, RTN_RGBA_IMAGE ); }

    int read();
    int write();

    void color(int, int, const RT_Color &);
    RT_Color get_color(int, int) const;
    const char *get_extension() const { return "rgb"; }

    //#### the Tcl commands:
    static int classCMD( ClientData, Tcl_Interp *, int, char *[] );  
};

#endif

