#ifndef __ONE_RAY_CAMERA_H__
#define __ONE_RAY_CAMERA_H__

////////////////////////////////////////////////////////////////////////////////
//  one ray camera for test purposes                                          //  
//  LAST EDIT: Fri Aug  5 08:54:59 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../camera.h"

extern const char *RTN_ONE_RAY_CAMERA;
extern const char *RTSN_ORC;

class RT_OneRayCamera: public RT_RayCamera {
    //##### statics for parameter parsing:
    static RT_Vector ptV; static int ptF, ptG;
    static RT_Vector drV; static int drF, drG;
    RT_Vector pt, dir;
    static RT_ParseEntry table[];
  public:
    void buildRay( double, double, RT_Ray &ray ) { ray.dir = dir; ray.pt = pt; }

    //#### the Tcl/C++ methods:
    RT_OneRayCamera( char *_name, RT_Vector _pt, RT_Vector _dir): RT_RayCamera(_name) { viewpoint( _pt); direction( _dir ); }
    const char *get_description() const { return "A camera sending only one ray! You can use this camera for test purposes. Just set rt_RayDebug to 1 to see the intersect protocols."; }
    const char *get_class() const { return RTN_ONE_RAY_CAMERA; }
    int isA(const char *c) const { return RT_Camera::isA( c ) || RTM_isA( c, RTN_ONE_RAY_CAMERA ); }
    void printCon( FILE *f) const {
	RT_Object::printCon( f); pt.print( f ); dir.print( f );
    }

    void rendering();

    void viewpoint(RT_Vector &_pt) { pt = _pt; }
    const RT_Vector &get_viewpoint() const { return pt; }

    void direction(RT_Vector &_dir) { dir = _dir.UNITIZE(); }
    const RT_Vector &get_direction() const { return dir; }

    //#### the Tcl commands: 
    int objectCMD(char *[]);  
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

#endif


