////////////////////////////////////////////////////////////////////////////////
//  OFFPolyhedron implementation.                                             //  
//  LAST EDIT: Wed Nov 23 09:09:02 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//    yart@prakinf.tu-ilmenau.de                                              //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "aoff.h"    
#include "../polyhdrn.h"
#include "offpolyh.h"
#include "intrsect.h"

#ifndef OK
#define  OK 1
#endif

#ifndef FAILURE
#define  FAILURE  0
#endif

const char *RTN_OFF_POLYHEDRON = "OFFPolyhedron";

int RT_OFFPolyhedron::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res = _classCMD( cd, ip, argc, argv );
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], "{ String File } { Creates a polyhedron set from a {ARG 2 File}. First parameter is the {ARG 1 Name} of the new object. } }", 0 );
	return TCL_OK;
    }
    if (res == TCL_OK) { 
	if ( argc != 3) { 
	    Tcl_AppendResult( ip, "Bad number of arguments. Try \"", RTN_OFF_POLYHEDRON, " ?\".", 0 ); 
	    return TCL_ERROR; 
	}
	int ok = 0;
	// This creates the Polyhedron based on the file named in the command
	new RT_OFFPolyhedron (argv[1], argv[2] );
	RTM_classReturn;
    }
    return TCL_ERROR;
}

////////////////////////////////////////////////////////////////////////////////
// Constructor for reading polyhedron from an OFF formated file               //
// This is derived from the OFFPoly constructor and the other Polyhedron      //
// constructor above.                                                         //
////////////////////////////////////////////////////////////////////////////////

RT_OFFPolyhedron::RT_OFFPolyhedron( char *a, char *fileName ): RT_Polyhedron ( a, 0, 0, 0, 0) {
    *AOFFProp.GeometryFileName = 0;   // Name of the geometry file
    *AOFFProp.PolygonColorsFileName =  0;   // name of the color file 
    *AOFFProp.PolygonColorsType =  0;  // types are indexed file or default
    *AOFFProp.VertexColorsFileName =  0;   // name of the vertex color file 
    *AOFFProp.VertexColorsType =  0;   // types are indexed or generic file or default
    *AOFFProp.VertexNormalFileName = 0;   // name of the VertexNormalFile
    *AOFFProp.FacetNormalFileName = 0;   // name of the FacetNormalFile
    
    // Read the *.aoff file. Only ascii format is supported
    if (readObj(fileName) != OK) return; // Must have been an error
    
    // open the data files for reading:
    RT_String str(40);
    RT_String Typestr(40);
    // Open the geometry file
    FILE *geom = fopen( AOFFProp.GeometryFileName, "r" ); 
    if (!geom) {
	rt_Output->errorVar( get_name(), ": No OFF geometry file, ", AOFFProp.GeometryFileName, "!", 0 ); 
	return;
    }
    
    // Open the color file
    str = AOFFProp.VertexColorsFileName;
    Typestr = AOFFProp.VertexColorsType;
    FILE *ivcol = 0;
    FILE *vcol = 0;
    if ( str ) {
        if (Typestr ==  aoffTokens[INDEXED]) { 
            if ( !(ivcol = fopen( str, "r" )))  
		rt_Output->warningVar( get_name(), ": No OFF indexed vertex color file ", (char*)str, "! Using default.", 0 ); 
        }
        else if (Typestr ==  aoffTokens[GENERIC]) { 
            if ( !(vcol = fopen( str, "r" )))  
		rt_Output->warningVar( get_name(), ": No OFF generic vertex color file ", (char*)str, "! Using default.", 0 ); 
        }
    }
    
    int dum;
    fscanf( geom, "%i %i %i", &npoints, &nfacets, &dum ); 
    RT_Vector *pointVector = new RT_Vector;
    
    if ( npoints ) vertices = new RT_Vertex[ npoints ];
    else vertices = 0;
    if (!vertices) return;
    
    int i;
    // read the vertex colors:
    RT_Color *colors = 0;
    if (ivcol) {
        int ncl, dum;
        fscanf( ivcol, "%i %i", &ncl, &dum);
        colors = new RT_Color[ ncl ];
        RT_Color *tmpc = colors;
        for (i = 0; i < ncl; i++ ) {
            fscanf( ivcol, "%lf %lf %lf", &tmpc->r, &tmpc->g, &tmpc->b );
            tmpc++;
	}
    }
    
    // initialize points: this is where we'll initially put the points from the file
    for (i = 0; i < npoints; i++) vertices[i] = RT_NULL_NORMAL;
    
    RT_Vertex *tmp = vertices;
    RT_Surface *tmpSurface = new RT_Surface;
    
    int ivIndex;
    for (i = 0; i < npoints; i++ ) {
	fscanf( geom, "%lf %lf %lf", &pointVector->x, &pointVector->y, &pointVector->z );
	// Read in the points and point each one in
	tmp->point( *pointVector );
	// Set the color of the vertex based on the index file values
	if (ivcol) {
	    // read the color index
	    fscanf (ivcol, "%i", &ivIndex);
	    //There is currently no surface for the vertex.
	    // set the tmpSurface to desired diffusion
	    tmpSurface->diff = colors[ivIndex-1];
	    tmp->surface(*tmpSurface);
        }
	tmp++;
    }
    if (ivcol) fclose (ivcol);
    
    RT_Vector *norms = 0;
    fnormals = 0; fdist = 0; ifunc = 0; fvalid = 0; intersections = 0;
    
    // Process the facets
    // Create an array of facet objects
    facets = 0;
    if ( nfacets ) facets = new RT_Facet[nfacets];
    if (!facets) return;
    // Read in the facets one at a time loading them into an int object array
    // load these into alligned facet objects
    // should add tests for reads
    int facet_error = 0;
    for (i = 0; i < nfacets; i++ ) {
        char stmp[10];
        // Get the number of verticies in this facet
        int nvt;
        fscanf( geom, "%i", &nvt );
        // Allocate space for the verticies
        int *tmpint = 0;
        if (nvt) tmpint = new int[nvt];
        // read vertices. Remenber to change the indexing to 0 based counting
        for (int j = 0; j < nvt; j++ ) {
            fscanf( geom, "%i", &tmpint[j] );
            tmpint[j]--;
        }
        if (nvt) facets[i].set(nvt, tmpint);
        if (facets[i].not_enough_points()) {
	    sprintf(stmp, "%d", i);
	    rt_Output->errorVar( get_name(), ": found a bad facet (# ", stmp, "). Need at least three points.", 0);
	    facet_error = 1;
	}
        if (facets[i].has_bad_pointer(npoints)) {
            sprintf(stmp, "%d", i);
            rt_Output->errorVar( get_name(), ": found a bad facet (# ",stmp,"). At least  one index in list points to the universe!", 0);
            facet_error = 1;
        }
        if (tmpint) delete tmpint;
    }
    if (facet_error) {
	rt_Output->errorVar( get_name(), ": Could not create a polyhedron! Could not fix errors in facet list", 0);
	delete facets;
	return;
    }

    // if there is a vcol file open then read it into the facets
    if (vcol) {
        int nColors;
        RT_Color tmpColor;
        // How many vertices
        fscanf( vcol, "%i", &nColors);
        for (i = 0; i < nColors; i++ ) {
            fscanf( vcol, "%lf %lf %lf", &tmpColor.r, &tmpColor.b, &tmpColor.b );
            //There is currently no surface for the vertex.
            // set the tmpSurface to desired diffusion
            tmpSurface->diff = colors[ivIndex-1];
            get(i)->surface(*tmpSurface);
        }
        fclose(vcol);
    }
    
    // if vertex normals file provided
    FILE *vnorm = 0;
    int NumNorms, dum1, dum2;
    RT_Vector norm;
    if (*AOFFProp.VertexNormalFileName) {
	if ( !(vnorm = fopen( AOFFProp.VertexNormalFileName, "r" )))  
	    rt_Output->warningVar( get_name(), ": No OFF vertex normal file ", AOFFProp.VertexNormalFileName, "!", 0 ); 
	else {
	    // Number of normals to read
	    fscanf(vnorm,"%i %i %i", &NumNorms, &dum1, &dum2 );
	    // Read the normals
	    for (i = 0; i < NumNorms; i++ ) {
		fscanf(vnorm, "%lf %lf %lf ", &norm.x, &norm.y, &norm.z);
		get(i)->normal(norm);
	    }
	    fclose(vnorm);
	}
    }
    // if facet normals file provided
    // Facet normals not currently supported
#ifdef NEVER
    if (*AOFFProp.FacetNormalFileName) {
	if ( !(vnorm = fopen( AOFFProp.FacetNormalFileName, "r" )))  
            rt_Output->warningVar( get_name(), ": No OFF facet normal file ", AOFFProp.FacetNormalFileName, "!", 0 ); 
	else {
	    fnormals = new RT_Vector[nfacets];
	    // Number of normals to read
	    fscanf(vnorm,"%i %i %i", &NumNorms, &dum1, &dum2 );
	    // Read the normals
	    for (i = 0; i < NumNorms; i++ ) {
		fscanf(vnorm, "%lf %lf %lf ", &fnormals[i].x, &fnormals[i].y, &fnormals[i].z);
	    }
	    fclose(vnorm);
	}
    }
#endif

    fclose ( geom );
    //if (colors) delete colors;
}

////////////////////////////////////////////////////////////////////////////////
// Read the *.aoff file loading the current objects Off header structure
// along the way

RT_OFFPolyhedron::readObj(char *fileName) {
    // open the header file for reading:
    RT_String str(40);
    str = fileName; str += ".aoff";
    FILE *offHeader = fopen( str, "r" ); 
    if (!offHeader) {
     rt_Output->errorVar( get_name(), ": No OFF Header file ", (char*)str, "!", 0 ); 
     return FAILURE;
    }

    RT_String strbuf(OFF_BIGSTR);
    RT_String StrKey(OFF_SMSTR);
    RT_String BufTail(OFF_BIGSTR);
    char StrInputBuffer[OFF_BIGSTR];
    
    char PropertyName[OFF_SMSTR];
    char DataType[OFF_SMSTR], Format[OFF_SMSTR];
    
    while (fgets(StrInputBuffer, OFF_BIGSTR, offHeader) != NULL) {
        strbuf = StrInputBuffer;
        // remove the newline
        int strbufLen;
        strbufLen = strbuf.length() -1;
        strbuf.del(strbufLen,strbufLen);
        // don't process the line if it starts with a "#" or if it is empty
        if (strbuf[0] != '#' && strbuf.length() > 0 ) {
            // get the first word from the buffer
            StrKey = strbuf.car();
            // Look for this Key in the list
            int i;
            for (i = 0; i < LASTAOFFTOKEN && StrKey != aoffTokens[i]; i++);
            BufTail = strbuf.cdr();
            switch (i) {
	      case LASTAOFFTOKEN: // it was not really found
		rt_Output->errorVar( get_name(), "WARNING: Ignore line, undefined keyword", (char*)StrKey, "!", 0 ); 
		break;
	      case NAME:
		strcpy (AOFFProp.Name, BufTail.getValue());
		break;
	      case AUTHOR:
		strcpy (AOFFProp.Author, BufTail.getValue());
		break;
	      case DESCRIPTION:
		strcpy (AOFFProp.Description, BufTail.getValue());
		break;
	      case COPYRIGHT:
		strcpy (AOFFProp.Copyright, BufTail.getValue());
		break;
	      case TYPE:
		// need to cut the head off of the BufTail to see if it is indexed_poly
		StrKey = BufTail.car();
		strcpy (AOFFProp.Type, StrKey.getValue());
		// Only can process polyhedron
		if (aoffTokens[POLYHEDRON]!=(AOFFProp.Type)) {
		    rt_Output->errorVar( get_name(), ": TYPE Only polyhedron off files supported ", (char*)strbuf, "!", 0 ); 
		    fclose (offHeader);
		    return FAILURE;
		}
		break;
	      case GEOMETRY:
		sscanf ( (char *)BufTail, "%s %s %s", DataType, Format, AOFFProp.GeometryFileName);
		if (aoffTokens[INDEXED_POLY]!=DataType) {
                    // print an error message and return
                    rt_Output->errorVar( get_name(), " Geometry: Only indexed_poly off files supported ", (char*)strbuf, "!", 0 ); 
		    fclose (offHeader);
                    return FAILURE;
		}
		break;
	      case POLYGON_COLORS:
		// two types supported here default and indexed file *.ipcol
		// The file name will be the 4th argument (but the 1st was cdr'ed off)
		StrKey = BufTail.car();
		strcpy (AOFFProp.PolygonColorsType, StrKey.getValue());
		// This may be a indexed or flat file
		if (StrKey == aoffTokens[INDEXED] || StrKey == aoffTokens[GENERIC]) { 
		    if (1 != sscanf ( (char *)BufTail, "%*s %*s %s", AOFFProp.PolygonColorsFileName)) 
                        rt_Output->warningVar( get_name(), " Polygon_Colors: Could not find file name, Using default colors.\n ", (char*)strbuf, 0 ); 
		}
		else if (StrKey == aoffTokens[DEFAULT] ) { // this is default colors 
		    if (3 != sscanf ( (char *)BufTail, "%*s %*s %f %f %f", 
				     &AOFFProp.PolygonColorsDefault[0],&AOFFProp.PolygonColorsDefault[1],&AOFFProp.PolygonColorsDefault[2])) 
			rt_Output->warningVar( get_name(), " Polygon_Colors: Could not find default colors. Ignoring line.\n ", (char*)strbuf, 0 );
		    else {
			RT_Color DiffColor;
			DiffColor.r =  AOFFProp.PolygonColorsDefault[0];
			DiffColor.g = AOFFProp.PolygonColorsDefault[1];
			DiffColor.b = AOFFProp.PolygonColorsDefault[2];
			diffuse(DiffColor);
		    } 
		}
		else  // Unknown type of polygon_color command
		    rt_Output->warningVar( get_name(), " Polygon_Colors: Unknown Type. Ignoring line.\n ", (char*)strbuf, 0 ); 
		break;
	      case VERTEX_COLORS:
		// two types supported here default and indexed generic file *.vcol *.ivcol
		// The file name will be the 4th argument (but the 1st was cdr'ed off)
		StrKey = BufTail.car();
		strcpy (AOFFProp.VertexColorsType, StrKey.getValue());
		// This may be a indexed or flat file
		if (StrKey == aoffTokens[INDEXED] || StrKey == aoffTokens[GENERIC]) { 
		    if (1 != sscanf ( (char *)BufTail, "%*s %*s %s", AOFFProp.VertexColorsFileName)) 
			rt_Output->warningVar( get_name(), " Vertex_Colors: Could not find file name, Using default colors.\n ", (char*)strbuf, 0 ); 
		}
		else if (StrKey == aoffTokens[DEFAULT] ) { // this is default colors 
		    if (3 != sscanf ( (char *)BufTail, "%*s %*s %f %f %f", 
				     &AOFFProp.PolygonColorsDefault[0],&AOFFProp.PolygonColorsDefault[1],&AOFFProp.PolygonColorsDefault[2])) 
			rt_Output->warningVar( get_name(), " Vertexn_Colors: Could not find default colors. Ignoring line.\n ", (char*)strbuf, 0 );
		    else {
			RT_Color DiffColor;
			DiffColor.r =  AOFFProp.PolygonColorsDefault[0];
			DiffColor.g = AOFFProp.PolygonColorsDefault[1];
			DiffColor.b = AOFFProp.PolygonColorsDefault[2];
			diffuse(DiffColor);
		    } 
		}
		else  // Unknown type of polygon_color command
		    rt_Output->warningVar( get_name(), " Vertex_Colors: Unknown Type. Ignoring line.\n ", (char*)strbuf, 0 ); 
		break;
	      case VERTEX_NORMALS:
		// one type supported here generic file *.vnorm
		// The file name will be the 4th argument (but the 1st was cdr'ed off)
		StrKey = BufTail.car();
		// This must be a flat file
		if ( StrKey == aoffTokens[GENERIC]) { 
		    if (1 != sscanf ( (char *)BufTail, "%*s %*s %s", AOFFProp.VertexNormalFileName)) 
			rt_Output->warningVar( get_name(), " Vertex_Normal: Could not find file name, Using default colors.\n ", (char*)strbuf, 0 ); 
		}
		else 
		    rt_Output->warningVar( get_name(), " Vertex_Normal: Only GENERIC type Supported.\n ", (char*)strbuf, 0 ); 
		break;
                //case DIFFUSE_COEF:
                //    break;
                //case SPECULAR_COEF:
                //    break;
                //case SPECULAR_POWER:
                //    break;
                } // end switch
	} //End if
    } // End while
    
    fclose (offHeader);
    return OK;
}

