#ifndef __OBA_H__
#define __OBA_H__

////////////////////////////////////////////////////////////////////////////////
//  A primitive for reading polygon files. The formate is used at TU Ilmenau. //
//  LAST EDIT: Fri Aug  5 08:54:59 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../poly.h"

extern const char *RTN_OBA_PRIMITIVE;

class RT_OBAPrimitive: public RT_Primitive {
    char *file;
  public:
    //#### Tcl/C++ methods:
    RT_OBAPrimitive(char *, char *);
    ~RT_OBAPrimitive() { delete file; }
    int isA(const char *_c) const { return RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_OBA_PRIMITIVE ); }
    const char *get_class() const { return RTN_OBA_PRIMITIVE;}
    const char *get_description() const { return "A polygon set created from OBA Files. OBA is a special format used at TU Ilmenau."; }
    void printCon(FILE *f) const { 
	RT_Primitive::printCon( f ); 
	fprintf( f, "%s ", file );
    }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

#endif

