#ifndef __AOFF_H__
#define __AOFF_H__

////////////////////////////////////////////////////////////////////////////////
// Definition of the AOFF format file reader                                  //  
// LAST EDIT: Mon Dec  5 09:55:12 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//        yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////
// Author: P. Bryan Heidorn                                                   //
// Parts of this module are derived from the RT_OFFPolygon code and OFF       //
// Specifications from DEC.  Deviations from the specification are for a      //
// combination of efficiency and lazyness... mostly the latter.               //
////////////////////////////////////////////////////////////////////////////////

#define OFF_BIGSTR	256
#define OFF_SMSTR	40

#include "../strings.h"

typedef struct OFFProp {
    char Name[OFF_SMSTR];	// Name of the object
    char Author[OFF_SMSTR]; // Author of the OFF files
    char Description[OFF_BIGSTR]; // Description of the object
    char Copyright[OFF_SMSTR]; 
    char Type[OFF_SMSTR];	// Type of object (only polyhedron supported here
    int  GeometryType;	
    char GeometryFileName[OFF_SMSTR];   // Name of the geometry file
    char PolygonColorsFileName[OFF_SMSTR];   // name of the color file 
    char PolygonColorsType[OFF_SMSTR];	// types are indexed file or default
    char VertexColorsFileName[OFF_SMSTR];   // name of the vertex color file 
    char VertexColorsType[OFF_SMSTR];	// types are indexed or generic file or default
    float  PolygonColorsDefault[3];	// The default color if any
    char VertexNormalFileName[OFF_SMSTR];   // name of the VertexNormalFile
    char FacetNormalFileName[OFF_SMSTR];   // name of the FacetNormalFile
    float  diffuse_coef;	
    float  specular_coef;	
    float  vertex_normals;
} OFFProperty;

extern RT_String aoffTokens[];

enum { NAME, AUTHOR, DESCRIPTION, COPYRIGHT, TYPE, GEOMETRY,
       POLYGON_COLORS, DIFFUSE_COEF, SPECULAR_COEF, SPECULAR_POWER,
       POLYHEDRON, INDEXED_POLY, INDEXED, GENERIC, DEFAULT, VERTEX_COLORS,
       VERTEX_NORMALS, LASTAOFFTOKEN };
	
#endif
