////////////////////////////////////////////////////////////////////////////////
//  Definiton of a facet class. A facet consists of a number of integers.     //  
//  LAST EDIT: Wed Mar  8 16:12:59 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __FACET_H__
#define __FACET_H__

#include "rlist.h"

extern const char *RTN_FACET;

class RT_Facet: public RT_GeneralListEntry {
    int nIndex;
    int *ind;
  public:
    RT_Facet() { 
	nIndex = 0; 
	ind = 0; 
    }
    
    RT_Facet(int _nIndex, int *_ind) { 
	set( _nIndex, _ind );
    }
    
    ~RT_Facet() { if (ind) delete ind; }
    
    void print(FILE *f) const { 
	fprintf( f, "{ ");
	for (int i=0; i<nIndex; i++) fprintf( f, "%d ", ind[i]);
	fprintf( f, "} ");
    }
    
    void set( int, int *);
	
    void operator=(const RT_Facet &f) {
	set( f.nIndex, f.ind );
    }
	
    // returns pointer to vertex list:
    int get_pointer_to_vertex( int ni ) const { return ind[ni]; }
    
    // returns number of vertices in facet:
    int get_number() const { return nIndex; }
    
    // returns the index of the pointer in facet:
    int get_vertex_index( int );
    
    // returns TRUE if vertex-pointer ci is in this facet:
    int vertex_in_facet(int);
    
    // returns TRUE if vertex-pointer ci is the first in facet:
    int first_vertex(int ci) { return (ci == ind[0]); }
    
    // returns TRUE if vertex-pointer ci is the first in facet:
    int last_vertex(int ci)  { return (ci == ind[nIndex - 1]); }

    // returns TRUE if facet contains less than three points:
    int not_enough_points() {
	if (nIndex < 3) return 1;
	   else return 0;
    }

    // returns TRUE if one index is greater than the specified:
    int has_bad_pointer( int );

    int isA(const char *_c) const { return RTM_isA( _c, RTN_FACET ); }
};

#endif
