////////////////////////////////////////////////////////////////////////////////
// Implementation of the output devices.                                      //  
// LAST EDIT: Thu Oct 20 13:29:45 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "error.h"

extern "C" {
#include <stdlib.h>
#include <stdarg.h>
}

void RT_SystemOutput::message(const char *s) {
    fprintf( stderr, "%s message: %s\n ", (char*)prog, s);
}

void RT_SystemOutput::messageVar(const char *s ...) {
    fprintf( stderr, "%s message: %s", (char*)prog, s );
    va_list args;
    va_start( args, s );
    while ( s = va_arg( args, char*))  fputs( s, stderr );
    fputc( '\n', stderr );
    va_end( args );
}

void RT_SystemOutput::warning(const char *s) {
    fprintf( stderr, "%s warning: %s\n ", (char*)prog, s);
}

void RT_SystemOutput::warningVar(const char *s ...) {
    fprintf( stderr, "%s warning: %s", (char*)prog, s );
    va_list args;
    va_start( args, s );
    while ( s = va_arg( args, char*))  fputs( s, stderr );
    fputc( '\n', stderr );
    va_end( args );
}

void RT_SystemOutput::error(const char *s) {
    fprintf( stderr, "%s error: %s\n ", (char*)prog, s );
}

void RT_SystemOutput::errorVar(const char *s ...) {
    fprintf( stderr, "%s error: %s", (char*)prog, s );
    va_list args;
    va_start( args, s );
    while ( s = va_arg( args, char*))  fputs( s, stderr );
    fputc( '\n', stderr );
    va_end( args );
}

void RT_SystemOutput::fatal(const char *s) {
    fprintf( stderr, "%s fatal error: %s\n ", (char*)prog, s);
    exit( 1 );
}

void RT_SystemOutput::fatalVar(const char *s ...) {
    fprintf( stderr, "%s fatal error: %s", (char*)prog, s );
    va_list args;
    va_start( args, s );
    while ( s = va_arg( args, char*))  fputs( s, stderr );
    fputc( '\n', stderr );
    va_end( args );
    exit( 1 );
}

