#ifndef __COLOR_H__
#define __COLOR_H__

////////////////////////////////////////////////////////////////////////////////
//  A simple class for representation of color values.                        //  
//  LAST EDIT: Wed Aug 17 09:02:03 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <stdio.h>
#include <math.h>

#ifndef RTD_CPP_INCLUDES
}
#endif
#include "strings.h"

class RT_Color {
  public:
    double r, g, b;

    void correct() {
	if (r < 0) r = 0; if (r > 1) r = 1;
	if (g < 0) g = 0; if (g > 1) g = 1;
	if (b < 0) b = 0; if (b > 1) b = 1;
    }

    RT_Color() { r = g = b = 0; }
    RT_Color(const RT_Color &c) { r = c.r; g = c.g; b = c.b; } 
    RT_Color(double rr, double gg, double bb ) { setRGB( rr, gg, bb ); } 
    RT_Color(unsigned long);

    void setHSL(double[3]);
    void getHSL(double[3]) const;
    void setRGB(double rr, double gg, double bb) { r = rr; g = gg; b = bb; }
    void setRGB(double rgb[3]) { r = rgb[0]; g = rgb[1]; b = rgb[2]; }

    // ASCII set&get:
    int set(const char*);
    const char *get() const {
	static RT_String str(40);
	char tmp[20];
	str = "";
	sprintf( tmp, "{%lf ", r );
	str += tmp;
	sprintf( tmp, "%lf ", g );
	str += tmp;
	sprintf( tmp, "%lf} ", b );
	str += tmp;
	return (char*)str; 
    }

    operator unsigned long () const;
    // convert it to a GL like long
   
    RT_Color operator *(const double x) const {
	RT_Color c( r*x, g*x, b*x );
	return c;
    }

    RT_Color operator *(const RT_Color x) const {
	RT_Color c( r*x.r, g*x.g, b*x.b );
	return c;
    }

    RT_Color operator +(const RT_Color &c) const { 
	return RT_Color( r + c.r, g + c.g, b + c.b); }

    int operator==(const RT_Color &) const;
    void operator=(const RT_Color &c) { r = c.r; g = c.g; b = c.b; }

    double ABS() { return sqrt( r * r + g * g + b * b); }

    // print the color:
    void print(FILE *f, char *n = 0) const {
	fprintf( f, "%s{%lf %lf %lf} ", n ? n : "", r, g, b );
    }

    void get_float( float f[3] ) const {
	f[0] = r;
	f[1] = g;
	f[2] = b;
    }
};

#endif
