#ifndef __CAMERA_H__
#define __CAMERA_H__

////////////////////////////////////////////////////////////////////////////////
//  Abstract camera classes:                                                  //  
// LAST EDIT: Fri Aug  5 08:55:11 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "scene.h"
#include "input/event.h"
#include "input/device.h"
#include "intrsect.h"
#include "pixmap.h"
#include "vector.h"
#include "object.h"

extern const char *RTN_CAMERA;

class RT_Camera: public RT_Object {
    static RT_ParseEntry table[];
  protected:
    //#### the statics for parameter parsing:
    static int pixF, pixG, rendF, refrF, scnF, scnG;
    static char *pixV, *scnV; 
    //#### the tcl commands:
    int objectCMD(char *[]);
    RT_Camera(char *_name): RT_Object(_name) { 
	xpixmap = 0; xscene = 0; 
	feedback = new RT_Scene( 0 );
    }
    ~RT_Camera() { delete feedback; }

    RT_Scene *xscene;
    // the scene we are working on

    RT_Pixmap *xpixmap;
    // the current pixmap 

  public:
    RT_Scene *feedback;
    // a special scene private to the camera
    // usable for feedback of input devices

    //#### Tcl/C++ methods:
    int isA(const char *c) const { return RT_Object::isA( c ) || RTM_isA( c, RTN_CAMERA ); }

    // access to the related pixmap:
    void pixmap(RT_Pixmap *);
    RT_Pixmap *get_pixmap() const { return xpixmap; }

    // set related scene to the camera:
    void scene(RT_Scene *); 
    RT_Scene *get_scene() const { return xscene; }
 
    virtual void rendering();

    virtual void refresh() {  rendering(); }
    
    // #### further public stuff:
    virtual void event(RT_Event &);
    // evaluate event from pixmap

    void print( FILE * ) const;

    void objectKilled(RT_Object *a) {
	if (a == xpixmap) pixmap( (RT_Pixmap*)-1 );
	if (a == xscene) scene( (RT_Scene*)-1 );
	RT_Object::objectKilled( a );
    }

    // #### internally used methods:
    virtual void buildRay( double, double, RT_Ray& ) = 0;
    // build ray from relative pixmap coordinates
    // cooordinates between 0 and 0 in each direction
    // lower left corner: (0, 0 )

    virtual RT_Primitive *getPrimitive(const RT_Ray&) = 0;
    // get the primitive by tracing the overgiven ray
    // can be used for picking
};

extern const char *RTN_RAY_CAMERA;

class RT_RayCamera: public RT_Camera {
  protected:
    int traceCnt;
    
    RT_Scene *emiScene;
    // this subscene contains all light sources

    RT_RayCamera(char *_name): RT_Camera(_name) { emiScene = new RT_Scene; }
    virtual ~RT_RayCamera() { delete emiScene; }

    // the main ray-tracing methods, may be used in subclasses.
    // for parameter description see camera.C

    virtual void trace(int LEVEL, double WEIGHT, const RT_Ray &RAY, RT_Color &COLOR);

    virtual void shade(int LEVEL, double WEIGHT, const RT_Vector &PT, const RT_Vector &N,
		       const RT_Vector &I, const RT_InterSectionList &HIT, RT_Color &COLOR);

    void specularDirection(const RT_Vector &I, const RT_Vector &N, RT_Vector &R);
    int transmissionDirection(const RT_Surface *M1, const RT_Surface *M2, const RT_Vector &I,
			      const RT_Vector &N, RT_Vector &T);

  public:

    int isA(const char *c) const { return RT_Camera::isA( c ) || RTM_isA( c, RTN_RAY_CAMERA ); }

    RT_Primitive *getPrimitive(const RT_Ray&);

    virtual void rendering();
    // collect emitting objects and lights into a sub scene
};

// some functoids:

class RT_RenderLightFunc: public RT_GeneralListFunctoid {
  public:
    void exec(RT_GeneralListEntry *e, void * = 0);
};

class RT_RenderPrimitiveFunc: public RT_GeneralListFunctoid {
  public:
    void exec(RT_GeneralListEntry *e, void * = 0);
};

class RT_IntersectPrimitiveFunc: public RT_GeneralListFunctoid {
    const RT_Ray &ray;
    RT_InterSectionList &inter;
    int interSect;
  public:
    RT_IntersectPrimitiveFunc(const RT_Ray &_ray, RT_InterSectionList &_i) : ray( _ray ), inter( _i ) {
	interSect = 0;
    }
    void exec(RT_GeneralListEntry *, void *);
    int getInterSect() { return interSect; }
};

class RT_PrimitiveBoundingFunc: public RT_GeneralListFunctoid {
    void exec(RT_GeneralListEntry *e, void * = 0) {
	// setup the WC boxes inside the primitives:
	if ( e->isA( RTN_PRIMITIVE )) ((RT_Primitive*)e)->get_hierarchBounds();
    }
};

#endif


