////////////////////////////////////////////////////////////////////////////////
// Implementation of attribute object                                         //  
// LAST EDIT: Wed Nov 30 12:49:53 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "attrobj.h"

const char *RTN_ATTRIBUTE_OBJECT = "AttributeObject";

RT_AttributeObject *rt_AttributeObject;

const RT_Attribute *RT_AttributeObject::getDefault( const char *cls ) const {
    // a local functoid class to find the default attribute:
    class LFunctoid: public RT_GeneralListFunctoid {
	const RT_Attribute *at;
	void exec(RT_GeneralListEntry *a, void *cls) {
	    assert( a->isA( RTN_ATTRIBUTE ) );
	    if (!strcmp( (char*)cls, ((RT_Attribute*)a)->getClass() ))
		at = ((RT_Attribute*)a)->getDefault();
	}
      public:
	LFunctoid(): at(0) {}
	const RT_Attribute *get() { return at; }
    } func;
    
    rt_DefaultAttributes.doWithElements( &func, (void*)cls );
    const RT_Attribute *at = func.get();
    if (!at) rt_Output->errorVar( "Attribute type ", cls, " not supported.", 0 );
    return at;
}

RT_Attribute *RT_AttributeObject::create(const char *cls, const char *val) const {
    // this method supports the pre-defined attribute types
    // others have to be supported in user-defined subclasses
    RT_Attribute *at = 0;

    if (!at && !strcmp( cls, RTN_RESOLUTION_ATTR )) 
	at = new RT_ResolutionAttribute;

    if (!at && !strcmp( cls, RTN_SURFACE_ATTR )) 
	at  = new RT_SurfaceAttribute;

    if (!at && !strcmp( cls, RTN_FILLSTYLE_ATTR ))
	at = new RT_FillstyleAttribute;

    if (!at && !strcmp( cls, RTN_MAPPING_ATTR )) 
	at = new RT_MappingAttribute;

    if (!at) return 0;

    if (!val || at->set( val)) return at;

    delete at;
    return 0;    
}

int RT_AttributeObject::parse(char *argv[], RT_Primitive *p) {
    int r = 0;
    r += RT_ResolutionAttrImpl::parseCMD( argv, p );
    r += RT_SurfaceAttrImpl::parseCMD( argv, p );
    r += RT_FillstyleAttrImpl::parseCMD( argv, p );
    r += RT_MappingAttrImpl::parseCMD( argv, p );
    return r;
};

int RT_AttributeObject::attributeCMD(ClientData, Tcl_Interp *, int argc, char *argv[]) { 
    // NOTE, by convention the default mapping attribute cannot be changed! 

    int r = (argc > 1) && !strcmp ( argv[1], RT_HELP ); 
    // skip over function name:
    argv = &argv[1];
    
    RT_Object::resResult();
    
    // solution:
    RT_parseTable( argv, RT_ResolutionAttrImpl::table );
    if (solF) { rt_AttributeObject->resolution( solV ); r++; }
    if (solG) { RT_Object::result( RT_ResolutionAttribute::Default.get() ); r++; }

    // surface:
    RT_parseTable( argv, RT_SurfaceAttrImpl::table );
    if (surfF) { rt_AttributeObject->surface(surfV); r++; }
    if (surfG) { RT_Object::result( RT_SurfaceAttribute::Default.get() ); r++; }
    if (ambiF) { rt_AttributeObject->ambient(ambiV); r++; }
    if (ambiG) { RT_Object::result( rt_AttributeObject->get_ambient().get() ); r++; }
    if (diffF) { rt_AttributeObject->diffuse(diffV); r++; }
    if (diffG) { RT_Object::result( rt_AttributeObject->get_diffuse().get() ); r++; }
    if (specF) { rt_AttributeObject->specular(specV); r++; }
    if (specG) { RT_Object::result( rt_AttributeObject->get_specular().get() ); r++; }
    if (emmiF) { rt_AttributeObject->emission(emmiV); r++; }
    if (emmiG) { RT_Object::result( rt_AttributeObject->get_emission().get() ); r++; }
    if (transF) { rt_AttributeObject->transmission(transV); r++; }
    if (transG) {
	static char tmp[20];
	RT_double2string( rt_AttributeObject->get_transmission(), tmp );
	RT_Object::result( tmp );
	r++;
    }
    if (refrF) { rt_AttributeObject->refraction(refrV); r++; }
    if (refrG) {
	char tmp[20];
	RT_double2string( rt_AttributeObject->get_refraction(), tmp );
	RT_Object::result( tmp );
	r++;
    }
    if (shinF) { rt_AttributeObject->shininess(shinV); r++; }
    if (shinG) {
	char tmp[20];
	RT_double2string( rt_AttributeObject->get_shininess(), tmp );
	RT_Object::result( tmp );
	r++;
    }
    if (sfuncF) { rt_AttributeObject->specfunc( sfuncV ); r++; }
    if (sfuncG) { RT_Object::result( rt_AttributeObject->get_specfunc() ); r++; }

    // fillstyle:
    RT_parseTable( argv, RT_FillstyleAttrImpl::table );
    if (styF) rt_AttributeObject->fillstyle( styV );
    if (styG) RT_Object::result( RT_FillstyleAttribute::Default.get() );
    r += styF + styG;

    r += rt_AttributeObject->objectCMD( argv );

    if (!r) rt_Output->error( "AttributeObject: Could not perform any method!" );
    else Tcl_SetResult( rt_Ip, RT_Object::getResult(), TCL_VOLATILE );
    return TCL_OK; 
}

void RT_AttributeObject::print(FILE *f) {
    // a local functoid class to print the default attributes:
    class LFunctoid:public RT_GeneralListFunctoid {
	void exec(RT_GeneralListEntry *a, void *f) {
	    assert( a->isA( RTN_ATTRIBUTE ) );
	    const RT_Attribute *at = ((RT_Attribute*)a)->getDefault();
	    if ( strcmp( at->getClass(), RTN_MAPPING_ATTR )) at->print( (FILE*)f );
	    // the default mapping cannot be changed!
	}
    } func;
    
    fprintf( f, "%s ", RTN_ATTRIBUTE_OBJECT );
    rt_DefaultAttributes.doWithElements( &func, (void*)f );
}
