################################################################################
##  Some functions to read/write objects from/to files.                       ##  
##  LAST EDIT: Thu Feb  9 18:33:17 1995 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

# IOM_getObjectSource
#
# Return the contents of the {ARG 1 Object} and put the 
# {ARG 2 Prefix} before the objectname.

proc IOM_getObjectSource {Object Prefix} {
    if [catch "open /tmp/__IOM__TMP w" fid] {
	rt_Output "$THIS: cant open the file /tmp/__IOM__TMP: $fid" 
	return
    }
    $Object -print $fid
    close $fid
    
    if [catch "open  /tmp/__IOM__TMP r" fid] {
	rt_Output "$THIS: cant open the file /tmp/__IOM__TMP: $fid" 
	return
    }
    set Contents [read $fid]
    close $fid
    
    regsub -all "\n$Object " $Contents "\n$Prefix$Object " Contents
    regsub -all " $Object " $Contents " $Prefix$Object " Contents
    regsub -all " $Object\n" $Contents " $Prefix$Object\n" Contents
    return $Contents
}

# IOM_getObjectSourceHierachical
#
# Return the contents of the {ARG 1 Object} of his children
# and put the {ARG 2 Prefix} before the object names.

proc IOM_getObjectSourceHierachical {Object Prefix {Father ""}} {
    proc IOM__local__proc_shp {obj pref father} {
	
	# get the object code:
	set Contents  [IOM_getObjectSource $obj $pref]
	
	# set the parent:
	regsub "father \[^\n\]*\n" $Contents "father \"$father\"\n" Contents

	# create the childern code:
	set clds [$obj -get_children]
	foreach cld $clds {
	    append Contents [IOM__local__proc_shp $cld $pref $pref$obj]
	}
	return $Contents
    }

    set ret [IOM__local__proc_shp $Object $Prefix $Father]
    rename IOM__local__proc_shp ""
    return $ret
}    

# IOM_buildClassFromTree
#
# Create a new class with the primitive tree of the {ARG 1 Primitiv} 
# and set the the name of the new class to {ARG 2 ClassName}.

proc IOM_buildClassFromTree {Primitive ClassName} {
    set ret ""
    append ret "#################################################\n"
    append ret "#\n# Class of the primitive tree of $Primitive\n"
    append ret "#\n#################################################\n\n"
    
    append ret "Tcl_Primitive $ClassName {} {} {Name} {String} \\\n"
    append ret "{<Description>} {\n"
    append ret [IOM_getObjectSourceHierachical $Primitive \$THIS. \$THIS]
    append ret "}\n\n"
    append ret "#################################################\n"
    append ret "#\n# end of $ClassName\n"
    append ret "#\n#################################################\n\n"
    
    return $ret
}

# IOM_buildClassFileFromTree
#
# Create a new class in the {ARG 3 FileName} with the primitive tree 
# of the {ARG 1 Primitiv} 
# and set the the name of the new class to {ARG 2 ClassName}.

proc IOM_buildClassFileFromTree {Primitive ClassName FileName} {
    if [catch "open $FileName w" file] {
	rt_Output -error "erorr in file open: $file"
    }  
    
    puts $file [IOM_buildClassFromTree $Primitive $ClassName] 
    close $file
}
    
# IOM_saveHierarchicalPrimitive
#
# Save the contents of the object to a file with the 
# descriptor {ARG 1 File}. As file descriptors are 
# supported: stdout and stderr and such you get when 
# using the Tcl procedure open().

proc IOM_saveHierarchicalPrimitive {Name File} {
    
    proc IOM__local__proc_shp {obj file {father ".i"}} {
	set objSource [IOM_getObjectSource $obj ""]
	# set the parent: ""
	regsub "father \[^\n\]*\n" $objSource "father \"$father\"\n" objSource
	
	puts $file $objSource
	
	# get the cildren objects
        if [regexp get_children [$obj ?]] {
	    set clds [$obj -get_children] 
	} {
	    set clds ""
	}
	
	foreach cld $clds {
	    IOM__local__proc_shp $cld $file $obj
	}
    }
    IOM__local__proc_shp $Name $File
    rename IOM__local__proc_shp ""
}

# IOM_create_YRT_File
#
# Create an yrt file for the RSH-Shell
# with the primitiv and lights of the scene.
# Put a camera and an pixmap at the end of the file.

proc IOM_create_YRT_File {FileName} {
    global IOM_Version
    if [catch "open $FileName w" File] {
	rt_Output -error "Erorr in file open: $File"
    }  
    
    puts $File "# IOM_YART_FILE_$IOM_Version\n\n"
    
    puts $File "######################################################"
    puts $File "#"
    puts $File "# IOM - YART Scene Script"
    puts $File "#"
    puts $File "# date: [exec date]"
    puts $File "#"
    puts $File "######################################################"
    
    set cam  iom_Camera
    set sc   [$cam -get_scene]
    set objs [$sc -get_objects]
    
    foreach obj $objs {
	IOM_saveHierarchicalPrimitive $obj $File
    }
    
    puts $File "\n\nif {\"\"==\"\[info vars IOM_Version\]\"} \{"
    $sc -print $File
    puts $File "PixmapDisplay yrt_Pixmap 300 300"
    puts $File "LookatCamera yrt_Camera \
	    {[$cam -get_viewpoint]} {[$cam -get_refpoint]}"
    puts $File "yrt_Camera -pixmap yrt_Pixmap"
    puts $File "yrt_Camera -scene $sc"
    puts $File "yrt_Camera -znear [$cam -get_znear]"
    puts $File "yrt_Camera -zfar [$cam -get_zfar]"
    puts $File "yrt_Camera -angle [$cam -get_angle]"
    puts $File "yrt_Camera -mode [$cam -get_mode]"
    puts $File "yrt_Camera -twist [$cam -get_twist]"
    puts $File "yrt_Camera -rendering"
    puts $File "\}"
    
    close $File
}


