#! /bin/sh
# run this file with the tkrt - wish
set {} { $*
shift
shift
exec $GOOD_ROOT_DIR/YART/bin/tkrt -file $0 $*
}

# TCL CODE:
# LAST EDIT: Wed Oct  5 13:57:16 1994 by ekki(@prakinf.tu-ilmenau.de)


proc mkindex {files} {
    global errorCode errorInfo
    append index "# Tcl autoload index file: each line identifies a Tcl\n"
    append index "# procedure and the file where that procedure is\n"
    append index "# defined.  Generated by the \"buildTclIndex\" command.\n"
    append index "\n"
    foreach file $files {
	puts stderr "Build index for file $file." 
	set f ""
	set error [catch {
	    set f [open $file]
	    while {[gets $f line] >= 0} {
		if [regexp {^proc[ 	]+([^ 	]*)} $line match procName] {
		    append index "[list $procName $file]\n"
		}

		# add Tcl_Object to the index list
		if [regexp {^Tcl_Object[ 	]+([^ 	]*)} $line match className] {
		    append index "[list $className $file]\n"
		}
	    }
	    close $f
	} msg]
	if $error {
	    set code $errorCode
	    set info $errorInfo
	    catch [close $f]
	    error $msg $info $code
	}
    }
    set f [open tclIndex w]
    puts $f $index nonewline
    close $f
}

mkindex $argv 

destroy .

