################################################################################
##  A front end to the manual pages.                                          ##  
##  LAST EDIT: Thu Feb  9 18:02:05 1995 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1993 - 1995 YART team                                        ##
################################################################################

IOM_TopBox ?

Tcl_Object IOM_ManualBox IOM_TopBox {} {Name} {String} {
    Creates a manual page viewer.} {
    wm title [set $THIS->tkTop] "IOM.manual"

    set path [set $THIS->frCenter]
    # create the selection box:
    frame $path.f -relief raise -border 2
    pack append $path $path.f {top frame center expand fill}

    scrollbar $path.f.s -command "$path.f.l yview" -relief sunken

    listbox $path.f.l \
	-yscrollcommand "$path.f.s set"\
	-exportselection false
    bind $path.f.l <ButtonPress-1> "$THIS -select %y"

    pack append $path.f\
	$path.f.s {right frame center filly}\
	$path.f.l {top frame center expand fill}

    # put all YART/IOM man pages into the selection list:
    global env
    set dir $env(GOOD_ROOT_DIR)
    set pages [exec ls $dir/man/man3] 

    foreach page $pages {
	set page [lindex [split $page .] 0 ]
	$path.f.l insert end $page 
    }
    
    # create the text field:
    frame $path.ft -relief raise -border 2
    pack append $path $path.ft {top frame center expand fill}

    scrollbar $path.ft.s -command "$path.ft.t yview" -relief sunken

    text $path.ft.t \
	-relief {sunken}\
	-height {25}\
	-width {80}\
	-yscrollcommand "$path.ft.s set"\
	-wrap {word}
    # no interaction with the text widget:
    bind $path.ft.t <Any-Key> {;} 
    bind $path.ft.t <Any-Button> {;} 

    pack append $path.ft\
	$path.ft.s {right frame center filly} \
	$path.ft.t {top frame center expand fill} 

    # the bottom button line:
    set path [set $THIS->frBottom]
    button $path.update -text "Close" -command  "delete $THIS"
    pack append $path \
	    $path.update {fill expand left} 
}

Tcl_Method IOM_ManualBox -manpage {page} {String} {Load the desired {ARG 1 Page} into the viewer.} {
    set path [set $THIS->frCenter].ft.t
    catch "exec man -c $page | col -b" desc
    $path delete 1.0 end
    $path insert end "$desc" 
}

Tcl_Method IOM_ManualBox -select {yy} {Integer} {Callback procedure for listbox selection. The argument specifies the {ARG 1 y-Value} of the mouse selection.} {
    set w [set $THIS->frCenter].f.l
    set nearest [$w nearest $yy]
    if {$nearest >= 0} {
	$w select from $nearest
	$w select to $nearest
	$THIS -manpage [$w get $nearest]
    }
}

IOM_ManualBox -description {This class/object provides an interface to the YART/IOM manual pages.}

IOM_ManualBox -keywords {IOM {User Interface} Manual Manpage}
