################################################################################
##  The basic interface widget class with some callback features.             ##  
##  LAST EDIT: Fri Feb 10 08:20:40 1995 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

IOM_Object ?

Tcl_Object IOM_InterfaceDevice IOM_Object {path xcurrentObject  xcallbackList xautoUpdate } {Name} {String} \
	{Create a new InterfaceObject  called {ARG 1 Name}.} \
	{
    set $THIS->xautoUpdate 1
    set $THIS->xexpertMode 0
}

# the "Current-Object" interface:

Tcl_Method IOM_InterfaceDevice  -currentObject {Name} {String}  {Set the current object.} {
    global IOM_InterfaceDevice::object
    set IOM_InterfaceDevice::object $Name
	
    if [string compare [set $THIS->xcurrentObject] $Name] {
	set $THIS->xcurrentObject $Name
	if [set $THIS->xautoUpdate] {$THIS -callCBs}
	$THIS -update
    }
}

Tcl_Method IOM_InterfaceDevice  -get_currentObject {} {}  {Get the current object.} { 
    return [set $THIS->xcurrentObject]
}

Tcl_Method IOM_InterfaceDevice  -callObject {} {}  {If there are a current object, the arguments of callObject are send to this object.} { 
    if [string length [set $THIS->xcurrentObject]] {
	if $argc { eval  "[set $THIS->xcurrentObject] $argv" }
    }
}

Tcl_Method IOM_InterfaceDevice  -call {} {}  {Call the kernel with the current argument list.} { 
    if $argc { eval  "$argv" }
}

# the callback interface:

Tcl_Method IOM_InterfaceDevice -addCB {Name} {String} {Add a callback {ARG 1 Name} in the callback list. Callbacks are the name of an Object with an exec method. The arguments to the exec method are an object and the name of the caller. } { 
    # check if the object exists:
    if [string length [info commands $Name]] {
	# if there is a callback with the name  Name in xcallbackList ignore the add command
	if -1==[lsearch [set $THIS->xcallbackList] $Name] {
	    lappend $THIS->xcallbackList $Name
	}
    }
}

Tcl_Method IOM_InterfaceDevice  -removeCB {Name} {String}  {Remove a callback from the callback list} { 
    # replace the callback in the list
    regsub $Name [set $THIS->xcallbackList] "" $THIS->xcallbackList
}

Tcl_Method IOM_InterfaceDevice  -clearCallbackList {} {}  {Reset the callback list.} \
	{ 
    set $THIS->xcallbackList {}
}

Tcl_Method IOM_InterfaceDevice  -getCallbackList {} {}  {Get the contents of the callback list.} { 
    return [set $THIS->xcallbackList]
}

Tcl_Method IOM_InterfaceDevice -callCBs {} {} {Call each callback in the callback list with the currentObject and the name of the sender as arguments. If an error is found in on callback then this callback are removed.} {
    set obj [set $THIS->xcurrentObject]
    
    # If there is no current object then do noting.
    if ![string length $obj] {return}
    
    foreach cb [set $THIS->xcallbackList] {
	if [catch "$cb -exec $obj $THIS" err] {
	    $THIS -removeCB $cb
	}
    }
}

Tcl_Method IOM_InterfaceDevice  -exec {Object Caller} {String String}  {Call the object with a new currentObject {ARG 1 Object} from the {ARG 2 Caller}.} {
    if [string compare [set $THIS->xcurrentObject] $Object] {
	set $THIS->xcurrentObject $Object
    }
    if [set $THIS->xautoUpdate] {
	foreach cb [set $THIS->xcallbackList] {
	    # call all cb-objects but not the caller
	    if [string compare $Caller $cb] {
		if [catch "$cb -exec $Object $THIS" err] {
		    $THIS -removeCB $cb
		}
	    }
	}
    }
    $THIS -update
}

Tcl_Method IOM_InterfaceDevice -update {} {} {This method is called, if an update of the datapresentation is necessary.} {}

# the auto update interface:

Tcl_Method IOM_InterfaceDevice -autoUpdate {Value} {Integer} \
{Set the {ARG 1 Value} to the autoUpdate flag of the object. \
The values are {ENUM 1 "On Off" }.} \
{
    if "($Value==0) || ($Value==1)" {
	set $THIS->autoUpdate $Value
    } {error "Wrong value $Value to $THIS -autoUpdate!"} 
}

Tcl_Method IOM_InterfaceDevice -get_autoUpdate {} {} \
{Get the value of the autoUpdate flag} {

    return [set $THIS->autoUpdate]
}

# build an another interface device with the same callback list:

Tcl_Method IOM_InterfaceDevice  -buildInterfaceDevice {Class Name} {String String}  {\
Build an interface device of the {ARG 1 Class} with the {ARG 2 Name}\
    and copy the contents of the callback list to the new object.
} { 
    # check if there is a command with the name Name
    if [string length [info commands $Name]] {return}
    
    # check if there is an current object
    #if ![string length [set $THIS->xcurrentObject]] {return}
    
    # build the interface
    $Class $Name 
    $Name -currentObject "[$THIS -get_currentObject]"

    # put the callbackList to the box
    # foreach cb [set $THIS->xcallbackList] {$Name -addCB $cb;} 

    # put the callCurrentObject methods to the callbackLists
    $THIS -addCB "$Name"
    $Name -addCB "$THIS"
}

IOM_InterfaceDevice -description {The base class for the interface objects. Defines a callback mechanism for all interface objects, too.}

IOM_InterfaceDevice -keywords {IOM User Interface}

