################################################################################
##  Dialog box for Fillstyle attribute.                                       ##  
##  LAST EDIT: Thu Aug  4 10:31:05 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

Tcl_Object IOM_FillstyleBox IOM_TopBox {updateCommands} {Name} {String} \
	{Creates a new Fillstyle editor box called {ARG 1 Name}.} \
	{
    $THIS -buildCurrentObjectLabel
    wm title [set $THIS->tkTop] "IOM.fillstyle"
    
    set path [set $THIS->frCenter]
    
    append $THIS->updateCommands [enumbutton  $path.f1 Fillstyle     \
	    "$THIS -callObject -get_fillstyle" \
	    "$THIS -callObject -fillstyle" \
	    "Wire Solid " 12]

    set path [set $THIS->frBottom]
    button $path.attrClear -text "Clear Fillstyle" -command  \
	    "$THIS -callObject -attrClear Fillstyle;\
	    $THIS -update; $THIS -callCBs;"
    button $path.update -text "Update" -command  \
	    "$THIS -update; $THIS -callCBs;"
    button $path.quit -text "Close" -command  "delete $THIS"
    pack append $path \
	    $path.update {fill expand left} \
	    $path.attrClear {fill expand left} \
	    $path.quit {fill expand left}
}

Tcl_Method IOM_FillstyleBox -update {} {} {Update the data representation of the widgets.} {
    eval [set $THIS->updateCommands]
}

IOM_FillstyleBox -description {The interface to the fillstyle attribute.}
IOM_FillstyleBox -keywords {IOM User-Interface Fillstyle}
