#!/bin/sh
#\
exec ${GOOD_ROOT_DIR}/packages/deltabl/dbsh -file $0 $*

# LAST EDIT: Thu Aug 18 14:08:22 1994 by ekki(@prakinf.tu-ilmenau.de)

LC cam { 2 7 3 } { 0 0 0 }
Scene sc 
PixmapDisplay d 300 300
d -doublebuffer
cam -scene sc -pixmap d -angle 50
AttributeObject -fillstyle 1
sc -insert [PointLight pl]
pl -origin { 2 7 0}

sc -insert [Cylinder c1 0.2 1 ]
c1 -translate { -1 0 0 } -diffuse { 1 0 0 }

sc -insert [Cylinder c2 0.2 2.3 ]
c2 -diffuse { 0 1 0 }

sc -insert [Cylinder c3 0.2 3 ]
c3 -translate { 1 0 0 } -diffuse { 0 0 1 }

sc -insert [Quader q1 2.4 1 1]
q1 -diffuse { 1 0 0 } -fillstyle 0

sc -insert [Quader q3 2.4 1 1]
q3 -diffuse { 0 0 1 } -fillstyle 0

Variable C1 "c1 -length" "c1 -get_length"
Constant C2 "c2 -length" "c2 -get_length"
Variable C3 "c3 -length" "c3 -get_length"
Variable Q1 "q1 -zdim"   "q1 -get_zdim"
Variable Q3 "q3 -zdim"   "q3 -get_zdim"
 
# co1: C2 = (C1 + 0.4*C3)/2
Constraint co1 { C1 C2 C3 } {\
     case $whichMethod \
	 0 { C1 -set [expr 2*[C2 -get]-0.4*[C3 -get]]} \
	 1 { C2 -set [expr [C1 -get]+0.4*[C3 -get]]} \
	 2 { C3 -set [expr (2*[C2 -get]-[C1 -get]])/0.4} \
} required

## co2: Q1 = C1 
Constraint co2 { Q1 C1} {\
     case $whichMethod \
	 0 { Q1 -set [C1 -get]} \
	 1 { C1 -set [Q1 -get]} \
} required

## co3: Q3 = C3 
Constraint co3 { Q3 C3 } {\
     case $whichMethod \
	 0 { Q3 -set [C3 -get]} \
	 1 { C3 -set [Q3 -get]} \
} required

set arc 0
while 1 {
    C3 -assign [expr 2.6+[cos $arc]*[sin [expr 1.6*$arc]]]
    cam -rendering
    set arc [expr $arc+0.2]
}

