//  LAST EDIT: Thu Mar  9 14:50:17 1995 by ekki(@prakinf.tu-ilmenau.de)
#include "list.h"
#include "constr.h"

DB_List *db_allVariables, *db_hot, *db_todo1, *db_todo2;
long db_currentMark;
DB_Strength db_strength;

const DB_Strength db_Strengths[] = {
    DBS_REQUIRED,
    DBS_STRONG_PREFERRED,
    DBS_PREFERRED,
    DBS_STRONG_DEFAULT,
    DBS_DEFAULT,
    DBS_WEAK_DEFAULT,
    DBS_WEAKEST
};

class DB_CntF: public RT_GeneralListFunctoid {
    int i;
    void exec(RT_GeneralListEntry *, void* ) {i++;}
  public:
    DB_CntF() { i = 0;}
    int get() { return i; } 
};

int DB_List::listSize() {
    class Functoid: public RT_GeneralListFunctoid {
	int i;
	void exec(RT_GeneralListEntry *, void* ) {i++;}
      public:
	Functoid() { i = 0;}
	int get() { return i; } 
    } func;
    doWithElements( &func );
    return func.get();
}

void DB_List::executePlan() {
    class Functoid: public RT_GeneralListFunctoid {
	void exec(RT_GeneralListEntry *e, void* = 0) {
	    if ( e->isA( DBN_CONSTRAINT ))
		((DB_Constraint*)e)->execute(); 
	}
    } func;
    doWithElements( &func );
}

DB_List *DB_List::makePlan() {
    db_currentMark++; 
    DB_List *plan = new DB_List;
    DB_Constraint *nextC = (DB_Constraint*)db_hot->removeFirst();
    while (nextC ) {
	DB_Variable *out = DBM_OUT_VAR(nextC);
	if ((out->mark != db_currentMark) && nextC->inputsKnown()) {
	    plan->add( nextC);
	    out->mark = db_currentMark;
	    nextC = out->nextDownstreamConstraint(db_hot);
	}
	else nextC = (DB_Constraint*) db_hot->removeFirst();
    }
    return plan;
}

class DB_AddIfSatisfiedInputFunctoid: public RT_GeneralListFunctoid {
    void exec(RT_GeneralListEntry *, void* );
};

void DB_AddIfSatisfiedInputFunctoid::exec(RT_GeneralListEntry *a,void* ) {
    if ( a->isA( DBN_CONSTRAINT )) {
	DB_Constraint *b = (DB_Constraint*)a;
	if (b->inputFlag && b->satisfied()) db_hot->add( b);
    }
}

class DB_CollectSatisfiedInputsFunctoid: public RT_GeneralListFunctoid {
    void exec(RT_GeneralListEntry *, void* );
};

void DB_CollectSatisfiedInputsFunctoid::exec(RT_GeneralListEntry *a,void* ) {
    if ( a->isA( DBN_VARIABLE )) {
	DB_Variable *b = (DB_Variable*)a;
	DB_AddIfSatisfiedInputFunctoid func;
	b->constraints.doWithElements( &func );
    }
}

DB_List *DB_List::extractPlan() {
    delete db_hot;
    db_hot = new DB_List;

    DB_CollectSatisfiedInputsFunctoid func;
    db_allVariables->doWithElements( &func );

    return makePlan();
}

DB_List *DB_List::extractPlanFromConstraints() {
    delete db_hot;
    db_hot = new DB_List;
    DB_AddIfSatisfiedInputFunctoid func;
    this->doWithElements( &func );
    return makePlan();
}

RT_GeneralListEntry *DB_List::removeFirst() {
    if (!root) return 0;
    RT_GeneralListEntry *e = root->elem;
    if (root->next) root->next->prev = 0;
    RT_GeneralListElem *tmp = root->next;
    if (root == last) last = 0;
    delete root; 
    if (tmp) root = tmp;
    else root = 0;
    return e;
}  

void DB_List::destroyContents() {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do delete tmp->elem;
    while(tmp = tmp->next); 
}
