#include "deltabl.h"

#ifdef DB_DEBUG

#include <malloc.h>

void *::operator new(size_t s) {
    void *tmp = malloc( s );
    printf( "malloc: %i (%i bytes)\n", tmp, s );
    return tmp;
}

void ::operator delete(void *p) {
    printf( "free: %i\n", p );
    free( p );
}

#endif

void DB_init() {
    db_allVariables = new DB_List;
    db_hot = new DB_List;
    db_todo1 = new DB_List;
    db_todo2 = new DB_List;
    db_currentMark = 0;
}

void DB_exit() {
    db_allVariables->destroyContents();
    db_hot->destroyContents();
    db_todo1->destroyContents();
    db_todo2->destroyContents();
    delete db_allVariables;
    delete db_hot;
    delete db_todo1;
    delete db_todo2;
}

