#ifdef SHIP_BITMAPS
/*
 * with this file, now the user can define and develop new ship bitmap sets
 * more easily.
 * 
 * The user need only create a file in the proper directory with the proper name
 * with the proper format.  The directory is specified by the shipBitmapPath
 * resource in the .xtrekrc.  Its default is /usr/games/lib/netrek.  The name
 * of the file is "R%d.C%d" where the first integer is the race number and
 * the second is the ship class number.
 * 
 * The format of the file is: 3 4-byte integers in network byte order. The first
 * is the number of views in the file (this field is currently ignored but
 * should have the value 16).  The second integer is the width and the third
 * is the height.  Then follows raw bitmap data.  I don't know what the
 * format is, but it's basically a binary version of the X bitmap file
 * format.  Translate those hex numbers to raw bytes and you have it.  I can
 * tell you that each line is padded to 8 bits.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/param.h>
#include <netinet/in.h>

#ifdef m_flags
/* appears under HPUX */
#undef m_flags
#endif

#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

read_ship_bitmaps ()
{
  int             i, race, k;
  int             width, height, size;
  int             nviews;	/* NYI */
  unsigned char  *buf = 0;
  char           *bitmapdir = 0;

  bitmapdir = getdefault ("shipBitmapPath", bitmapdir);

  if (!bitmapdir)
    return;

  printf ("Reading in user specified ship bitmaps...\n");
  
  for (race = 0; race < NUMTEAM; race++)
  {
    for (k = 0; k < NUM_TYPES; k++)
    {
      static char     path[MAXPATHLEN];
      FILE           *fp;
      
      sprintf (path, "%s/R%d.C%d", bitmapdir, race, k);
      fp = fopen (path, "r");
      
      if (fp == 0)
        continue;
      else
      {
	fread (&nviews, sizeof (nviews), 1, fp);
	nviews = ntohl (nviews);
	fread (&width, sizeof (width), 1, fp);
	width = ntohl (width);
	fread (&height, sizeof (height), 1, fp);
	height = ntohl (height);
	size = (width + 7) / 8 * height;
	buf = (unsigned char *) malloc (size);
	
	if (width != 20 || height != 20 || nviews != VIEWS)
	  printf ("Size mismatch on bitmaps R%d.C%d\n", race, k);
      }

      for (i = 0; i < VIEWS; i++)
      {
	if (fp)
	  fread (buf, size, 1, fp);
	else
	  break;
	
	switch (race)
	{
	  case 0:
	    fed_bitmaps [k][i] = W_StoreBitmap (width, height, buf, w);
	  break;
	  case 1:
	    rom_bitmaps [k][i] = W_StoreBitmap (width, height, buf, w);
	  break;
	  case 2:
	    kli_bitmaps [k][i] = W_StoreBitmap (width, height, buf, w);
	  break;
	  case 3:
	    ori_bitmaps [k][i] = W_StoreBitmap (width, height, buf, w);
	  break;
	}
      }

      if (fp)
        fclose (fp);
    }
  }
}
#endif

