/*
 * meta.c     - Nick Trown    May 1993
 */

#ifdef META

#include "copyright.h"
#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>

#ifdef _IBMR2
#include <sys/select.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
/*
  #include "proto.h"
  */
#include <string.h>
#if !defined(SYSV) && !defined(apollo) && !defined(SVR4)
#include <strings.h>
#endif

#define BUF	4096

void metarefresh ();
void metadone ();

/*
   I was planning to use this function a lot but it doesn't look like
   I need it more than once. It finds the next number after position
   'start'.
 */

int
getnumber (string, start)
     char *string;
     int start;
{
  char temp[LINE];
  int c;
  int tc = 0;

  for (c = start; c <= (int)strlen (string); c++)
    {
      if ((string[c] >= '0') && (string[c] <= '9'))
	{
	  temp[tc++] = string[c];
	}
      else if (tc > 0)
	{
	  temp[tc] = '\0';
	  return (atoi (temp));
	}
    }
  return 0;
}


/*  
   The connection to the metaserver is by Andy McFadden.
   This calls the metaserver and parses the output into something
   useful
 */

static int
open_port (host, port, verbose)
     char *host;
     int port;
     int verbose;
{
  struct sockaddr_in addr;
  struct hostent *hp;
  int sock;

  /* Connect to the metaserver */
  /* get numeric form */
  if ((addr.sin_addr.s_addr = inet_addr (host)) == -1)
    {
      if ((hp = gethostbyname (host)) == NULL)
	{
	  if (verbose)
	    fprintf (stderr, "unknown host '%s'\n", host);
	  return (-1);
	}
      else
	{
	  addr.sin_addr.s_addr = *(LONG *) hp->h_addr;
	}
    }
  addr.sin_family = AF_INET;
  addr.sin_port = htons (port);
  if ((sock = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
      if (verbose)
	perror ("socket");
      return (-1);
    }
  if (connect (sock, (struct sockaddr *) &addr, sizeof (addr)) < 0)
    {
      if (verbose)
	perror ("connect");
      close (sock);
      return (-1);
    }
  return (sock);
}


int
readmeta (sock)
     int sock;
{
  int cc, lc=0, c, tc;

  static char buf[BUF + 1];
  static char *numstr;
  static char line[LINE + 1];

#ifndef DEBUG
  while (1)
    {
      if ((cc = read (sock, buf, 4096)) <= 0)
	{
	  if (cc < 0)
	    perror ("read");
	  close (sock);
	  return (cc);
	}
#else
  /* 
     cat the output of the metaserver port 3521 to a 
     file called "output" for testing purposes
   */
  sock = open ("output", O_RDONLY);

  if ((cc = read (sock, buf, BUF)) <= 0)
    {
      if (cc < 0)
	perror ("read");
      close (sock);
      return (cc);
    }
  fwrite (buf, cc, 1, stdout);
  close (sock);
#endif

  for (c = 0; c < cc; c++)
    {
      if (buf[c] != '\n')	/* Break up the buffer into lines */
	line[lc++] = buf[c];
      else
	{
	  if (sscanf (line, "-h %s -p %d %d",	/* parse line */
		      serverlist[num_servers].address,
		      &serverlist[num_servers].port,
		      &serverlist[num_servers].time) == 3)
	    {
	      /* get what type of server it is */
              serverlist[num_servers].typeflag = line[strlen(line)-1];

              serverlist[num_servers].status = -1;

	      /* 
	         I don't have it checking the servers with nobody
	         playing because the menu window would then be too
	         large to fit on a 1024 x 768 window. :(  - NBT
	       */

	      for (tc = 0; tc < KEY; tc++)
		if ((numstr = strstr (line, keystrings[tc])))
		  {
		    serverlist[num_servers].status = tc;
		    serverlist[num_servers].players = getnumber (numstr, 0);
		  }

	      if (strrchr (line, 'R'))
		serverlist[num_servers].RSA_client = 1;
	      else
		serverlist[num_servers].RSA_client = 0;

              if (serverlist[num_servers].typeflag == 'P') 
		serverlist[num_servers].status = -1;

	      if (serverlist[num_servers].status >= 0)
		{

#ifdef DEBUG
		  printf ("HOST:%-30s PORT:%-6d %12s %-5d %d\n",
			  serverlist[num_servers].address,
			  serverlist[num_servers].port,
			  keystrings[serverlist[num_servers].status],
			  serverlist[num_servers].players,
			  serverlist[num_servers].RSA_client);
#endif

		  num_servers++;	/* It's valid */
		}
	    }
	  lc = 0;
	  line[0] = '\0';
	}
    }
  }
  /*close(sock);*/
}


void
parsemeta ()
{
  int sock;
  if (serverName)
    {
      strcpy (serverlist[num_servers].address, serverName);
      serverlist[num_servers].port = xtrekPort;

#ifdef RSA
      serverlist[num_servers].RSA_client = RSA_Client;
#endif

      serverlist[num_servers].status = KEY + 1;
      serverlist[num_servers].players = 0;
      num_servers++;
    }

#ifdef DEBUG
  readmeta (0);
#else

  if (meta_server[0] == '\0')
  { 
    if (getdefault ("metaserver"))
      strcpy (meta_server, getdefault ("metaserver"));
    else
      strcpy (meta_server, METASERVER);
  }

  if ((sock = open_port (meta_server, METAPORT, 1)) > 0)
    {
      readmeta (sock);
    }
  else
    {
      fprintf (stderr, "Cannot connect to MetaServer (%s , %d)\n",
	       meta_server, METAPORT);
      exit (0);
    }
#endif
}


/* Show the meta server menu window */

void metawindow ()
{
  register int i;
/*
  metaWin = W_MakeMenu ("MetaServer List", WINSIDE+10, -BORDER+10, 69,
	      num_servers + 1, NULL, 2);
*/
  for (i = 0; i < num_servers; i++)
    metarefresh (i);

  /* Add quit option */
  W_WriteText (metaWin, 0, num_servers, textColor, "Quit", 4, 0);

  /* Map window */
  W_MapWindow (metaWin);
}

/*
 * Refresh item i
 */
void
metarefresh (i)
     int i;
{
  char buf[BUFSIZ];

  if (serverlist[i].status < KEY)
    {
      sprintf (buf, "%-40s %12s ",
	       serverlist[i].address,
	       keystrings[serverlist[i].status]);
      if(serverlist[i].status != 2)
	 sprintf(buf+strlen(buf),"%-5d ",serverlist[i].players);
      else 
	 strcat(buf,"      ");
      switch (serverlist[i].typeflag) {
	 case 'P': strcat(buf,"Paradise"); break;
	 case 'B': strcat(buf,"Bronco"); break;
	 case 'C': strcat(buf,"Chaos"); break;
	 case 'I': strcat(buf,"INL"); break;
	 case 'S': strcat(buf,"Sturgeon"); break;
	 case 'H': strcat(buf,"Hockey"); break;
      }
    }
  else if (serverlist[i].status == KEY)
    {				/* For when I have checking code */
      sprintf (buf, "%-40s CANNOT CONNECT", serverlist[i].address);
    }
  else if (serverlist[i].status == KEY + 1)
    {
      sprintf (buf, "%-40s   DEFAULT SERVER", serverlist[i].address);
    }

  W_WriteText (metaWin, 0, i, textColor, buf, strlen (buf), 0);
}


/* 
   Check selection to see if was valid. If it was then we have a winner!
 */
void
metaaction (data)
     W_Event *data;
{
  int sock;
  char buf[80];

  if ((data->y >= 0) && (data->y < num_servers))
    {
      xtrekPort = serverlist[data->y].port;
      serverName = serverlist[data->y].address;

#ifdef RSA
      RSA_Client = serverlist[data->y].RSA_client;
#endif

      if ((sock = open_port (serverName, xtrekPort, 0)) <= 0)
	{
	  serverlist[data->y].status = KEY;
	  metarefresh (data->y);
	}
      else
	{
	  close (sock);
	  sprintf (buf, "Netrek  @  %s", serverName);
	  W_RenameWindow (baseWin, buf);
	  metadone ();
	}
    }
  else if (data->y == num_servers)
    exit (0);

}


/*
   Unmap the metaWindow
 */

void
metadone ()
{
  /* Unmap window */
  W_UnmapWindow (metaWin);
}


/* 
   My own little input() function. I needed this so I don't have
   to use all the bull in the main input(). Plus to use it I'd have
   to call mapAll() first and the client would read in the default
   server and then call it up before I can select a server.
 */

void
metainput ()
{
  W_Event data;

  while (W_IsMapped (metaWin))
    {
      W_NextEvent (&data);
      switch ((int) data.type)
	{
	case W_EV_KEY:
	  if (data.Window == metaWin)
	    metaaction (&data);
	  break;
	case W_EV_BUTTON:
	  if (data.Window == metaWin)
	    metaaction (&data);
	  break;
	case W_EV_EXPOSE:
	  break;
	default:
	  break;
	}
    }
}
#endif /* METASERVER */
